/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.shims;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final Logger LOG = LoggerFactory.getLogger(Utils.class);
    public static final String RAW_RESERVED_VIRTUAL_PATH = "/.reserved/raw/";
    public static final String DISTCP_OPTIONS_PREFIX = "distcp.options.";
    public static final String XSRF_CUSTOM_HEADER_PARAM = "custom-header";
    public static final String XSRF_CUSTOM_METHODS_TO_IGNORE_PARAM = "methods-to-ignore";
    private static final String XSRF_HEADER_DEFAULT = "X-XSRF-HEADER";
    private static final Set<String> XSRF_METHODS_TO_IGNORE_DEFAULT = new HashSet<String>(Arrays.asList("GET", "OPTIONS", "HEAD", "TRACE"));

    public static UserGroupInformation getUGI() throws IOException {
        if (UserGroupInformation.isSecurityEnabled()) {
            return UserGroupInformation.getCurrentUser();
        }
        String doAs = System.getenv("HADOOP_USER_NAME");
        if (doAs != null && doAs.length() > 0) {
            return UserGroupInformation.createProxyUser((String)doAs, (UserGroupInformation)UserGroupInformation.getLoginUser());
        }
        return UserGroupInformation.getCurrentUser();
    }

    public static Filter getXSRFFilter() {
        String filterClass = "org.apache.hadoop.security.http.RestCsrfPreventionFilter";
        try {
            Class<?> klass = Class.forName(filterClass);
            Filter f = (Filter)klass.newInstance();
            LOG.debug("Filter {} found, using as-is.", (Object)filterClass);
            return f;
        }
        catch (Exception e) {
            LOG.debug("Unable to use {}, got exception {}. Using internal shims impl of filter.", (Object)filterClass, (Object)e.getClass().getName());
            return Utils.constructXSRFFilter();
        }
    }

    public static boolean checkFileSystemXAttrSupport(FileSystem fs) throws IOException {
        return Utils.checkFileSystemXAttrSupport(fs, new Path("/"));
    }

    public static boolean checkFileSystemXAttrSupport(FileSystem fs, Path path) throws IOException {
        try {
            fs.getXAttrs(path);
            return true;
        }
        catch (UnsupportedOperationException e) {
            LOG.warn("XAttr won't be preserved since it is not supported for file system: " + String.valueOf(fs.getUri()));
            return false;
        }
    }

    private static Filter constructXSRFFilter() {
        return new Filter(){
            private String headerName = "X-XSRF-HEADER";
            private Set<String> methodsToIgnore = XSRF_METHODS_TO_IGNORE_DEFAULT;

            public void init(FilterConfig filterConfig) throws ServletException {
                String customMethodsToIgnore;
                String customHeader = filterConfig.getInitParameter(Utils.XSRF_CUSTOM_HEADER_PARAM);
                if (customHeader != null) {
                    this.headerName = customHeader;
                }
                if ((customMethodsToIgnore = filterConfig.getInitParameter(Utils.XSRF_CUSTOM_METHODS_TO_IGNORE_PARAM)) != null) {
                    this.parseMethodsToIgnore(customMethodsToIgnore);
                }
            }

            void parseMethodsToIgnore(String mti) {
                String[] methods = mti.split(",");
                this.methodsToIgnore = new HashSet<String>();
                for (int i = 0; i < methods.length; ++i) {
                    this.methodsToIgnore.add(methods[i]);
                }
            }

            public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
                if (Utils.doXsrfFilter(request, response, this.methodsToIgnore, this.headerName)) {
                    chain.doFilter(request, response);
                }
            }

            public void destroy() {
            }
        };
    }

    public static boolean doXsrfFilter(ServletRequest request, ServletResponse response, Set<String> methodsToIgnore, String headerName) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        if (methodsToIgnore == null) {
            methodsToIgnore = XSRF_METHODS_TO_IGNORE_DEFAULT;
        }
        if (headerName == null) {
            headerName = XSRF_HEADER_DEFAULT;
        }
        if (methodsToIgnore.contains(httpRequest.getMethod()) || httpRequest.getHeader(headerName) != null) {
            return true;
        }
        ((HttpServletResponse)response).sendError(400, "Missing Required Header for Vulnerability Protection");
        response.getWriter().println("XSRF filter denial, requests must contain header : " + headerName);
        return false;
    }
}

