/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.CheckResult;
import org.apache.hadoop.hive.metastore.HiveMetaStoreChecker;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.LockComponentBuilder;
import org.apache.hadoop.hive.metastore.LockRequestBuilder;
import org.apache.hadoop.hive.metastore.MsckInfo;
import org.apache.hadoop.hive.metastore.MsckPartitionExpressionProxy;
import org.apache.hadoop.hive.metastore.PartitionDropOptions;
import org.apache.hadoop.hive.metastore.PartitionManagementTask;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.AbortTxnRequest;
import org.apache.hadoop.hive.metastore.api.DataOperationType;
import org.apache.hadoop.hive.metastore.api.LockRequest;
import org.apache.hadoop.hive.metastore.api.LockResponse;
import org.apache.hadoop.hive.metastore.api.LockState;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.MetastoreException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.txn.TxnErrorMsg;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.hadoop.hive.metastore.utils.FileUtils;
import org.apache.hadoop.hive.metastore.utils.MetaStoreServerUtils;
import org.apache.hadoop.hive.metastore.utils.RetryUtilities;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Msck {
    public static final Logger LOG = LoggerFactory.getLogger(Msck.class);
    public static final int separator = 9;
    private static final int terminator = 10;
    private static final String TABLES_NOT_IN_METASTORE = "Tables not in metastore:";
    private static final String TABLES_MISSING_ON_FILESYSTEM = "Tables missing on filesystem:";
    private static final String PARTITIONS_NOT_IN_METASTORE = "Partitions not in metastore:";
    private static final String PARTITIONS_MISSING_FROM_FILESYSTEM = "Partitions missing from filesystem:";
    private static final String EXPIRED_PARTITIONS = "Expired partitions:";
    private static final String EXPIRED_PARTITIONS_RETENTION = "Expired partitions (retention period: %ss) :";
    private boolean acquireLock;
    private boolean deleteData;
    private Configuration conf;
    private IMetaStoreClient msc;

    public Msck(boolean acquireLock, boolean deleteData) {
        this.acquireLock = acquireLock;
        this.deleteData = deleteData;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public void init(Configuration conf) throws MetaException {
        if (this.msc == null) {
            this.setConf(conf);
            this.msc = new HiveMetaStoreClient(conf);
        }
    }

    public static Configuration getMsckConf(Configuration conf) {
        Configuration metastoreConf = MetastoreConf.newMetastoreConf((Configuration)new Configuration(conf));
        metastoreConf.set(MetastoreConf.ConfVars.EXPRESSION_PROXY_CLASS.getVarname(), Msck.getProxyClass(metastoreConf));
        return metastoreConf;
    }

    public static String getProxyClass(Configuration metastoreConf) {
        return metastoreConf.get(MetastoreConf.ConfVars.EXPRESSION_PROXY_CLASS.getVarname(), MsckPartitionExpressionProxy.class.getCanonicalName());
    }

    public void updateExpressionProxy(String proxyClass) throws TException {
        this.msc.setMetaConf(MetastoreConf.ConfVars.EXPRESSION_PROXY_CLASS.getVarname(), proxyClass);
    }

    public int repair(MsckInfo msckInfo) throws TException, MetastoreException, IOException {
        long txnId;
        boolean success;
        String qualifiedTableName;
        block34: {
            CheckResult result = null;
            ArrayList<String> repairOutput = new ArrayList<String>();
            qualifiedTableName = null;
            success = false;
            txnId = -1L;
            long partitionExpirySeconds = -1L;
            try {
                Table table = this.getMsc().getTable(msckInfo.getCatalogName(), msckInfo.getDbName(), msckInfo.getTableName());
                partitionExpirySeconds = PartitionManagementTask.getRetentionPeriodInSeconds(table);
                qualifiedTableName = Warehouse.getCatalogQualifiedTableName((Table)table);
                HiveMetaStoreChecker checker = new HiveMetaStoreChecker(this.getMsc(), this.getConf(), partitionExpirySeconds);
                result = checker.checkMetastore(msckInfo.getCatalogName(), msckInfo.getDbName(), msckInfo.getTableName(), msckInfo.getFilterExp(), table);
                Set partsNotInMs = result.getPartitionsNotInMs();
                Set partsNotInFs = result.getPartitionsNotOnFs();
                Set expiredPartitions = result.getExpiredPartitions();
                int totalPartsToFix = partsNotInMs.size() + partsNotInFs.size() + expiredPartitions.size();
                boolean lockRequired = totalPartsToFix > 0 && msckInfo.isRepairPartitions() && (msckInfo.isAddPartitions() || msckInfo.isDropPartitions());
                LOG.info("{} - #partsNotInMs: {} #partsNotInFs: {} #expiredPartitions: {} lockRequired: {} (R: {} A: {} D: {})", new Object[]{qualifiedTableName, partsNotInMs.size(), partsNotInFs.size(), expiredPartitions.size(), lockRequired, msckInfo.isRepairPartitions(), msckInfo.isAddPartitions(), msckInfo.isDropPartitions()});
                if (msckInfo.isRepairPartitions()) {
                    int batchSize;
                    boolean transactionalTable = TxnUtils.isTransactionalTable(table);
                    if (this.acquireLock && lockRequired && table.getParameters() != null && transactionalTable) {
                        long lockId;
                        LockRequest lockRequest = this.createLockRequest(msckInfo.getDbName(), msckInfo.getTableName());
                        txnId = lockRequest.getTxnid();
                        try {
                            LockResponse res = this.getMsc().lock(lockRequest);
                            if (res.getState() != LockState.ACQUIRED) {
                                throw new MetastoreException("Unable to acquire lock(X) on " + qualifiedTableName);
                            }
                            lockId = res.getLockid();
                        }
                        catch (TException e) {
                            throw new MetastoreException("Unable to acquire lock(X) on " + qualifiedTableName, (Throwable)e);
                        }
                        LOG.info("Acquired lock(X) on {}. LockId: {}", (Object)qualifiedTableName, (Object)lockId);
                    }
                    int maxRetries = MetastoreConf.getIntVar((Configuration)this.getConf(), (MetastoreConf.ConfVars)MetastoreConf.ConfVars.MSCK_REPAIR_BATCH_MAX_RETRIES);
                    int decayingFactor = 2;
                    if (msckInfo.isAddPartitions() && !partsNotInMs.isEmpty()) {
                        boolean doSkip;
                        batchSize = MetastoreConf.getIntVar((Configuration)this.getConf(), (MetastoreConf.ConfVars)MetastoreConf.ConfVars.MSCK_REPAIR_BATCH_SIZE);
                        if (batchSize == 0) {
                            batchSize = partsNotInMs.size();
                        }
                        AbstractList vals = null;
                        String settingStr = MetastoreConf.getVar((Configuration)this.getConf(), (MetastoreConf.ConfVars)MetastoreConf.ConfVars.MSCK_PATH_VALIDATION);
                        boolean doValidate = !"ignore".equals(settingStr);
                        boolean bl = doSkip = doValidate && "skip".equals(settingStr);
                        if (doValidate) {
                            Iterator iter = partsNotInMs.iterator();
                            while (iter.hasNext()) {
                                CheckResult.PartitionResult part = (CheckResult.PartitionResult)iter.next();
                                try {
                                    vals = Warehouse.makeValsFromName((String)part.getPartitionName(), vals);
                                }
                                catch (MetaException ex) {
                                    throw new MetastoreException((Throwable)ex);
                                }
                                for (String val : vals) {
                                    String escapedPath = FileUtils.escapePathName((String)val);
                                    assert (escapedPath != null);
                                    if (escapedPath.equals(val)) continue;
                                    String errorMsg = "Repair: Cannot add partition " + msckInfo.getTableName() + ":" + part.getPartitionName() + " due to invalid characters in the name";
                                    if (doSkip) {
                                        repairOutput.add(errorMsg);
                                        iter.remove();
                                        continue;
                                    }
                                    throw new MetastoreException(errorMsg);
                                }
                            }
                        }
                        if (transactionalTable) {
                            if (txnId < 0L) {
                                txnId = this.getMsc().openTxn(this.getUserName());
                            }
                            this.validateAndAddMaxTxnIdAndWriteId(partsNotInMs, table.getDbName(), table.getTableName(), txnId);
                        }
                        try {
                            this.createPartitionsInBatches(this.getMsc(), repairOutput, partsNotInMs, table, batchSize, decayingFactor, maxRetries);
                        }
                        catch (Exception e) {
                            throw new MetastoreException((Throwable)e);
                        }
                    }
                    if (!(!msckInfo.isDropPartitions() || partsNotInFs.isEmpty() && expiredPartitions.isEmpty())) {
                        batchSize = MetastoreConf.getIntVar((Configuration)this.getConf(), (MetastoreConf.ConfVars)MetastoreConf.ConfVars.MSCK_REPAIR_BATCH_SIZE);
                        if (batchSize == 0) {
                            batchSize = partsNotInFs.size() + expiredPartitions.size();
                        }
                        try {
                            this.dropPartitionsInBatches(this.getMsc(), repairOutput, partsNotInFs, expiredPartitions, table, batchSize, decayingFactor, maxRetries);
                        }
                        catch (Exception e) {
                            throw new MetastoreException((Throwable)e);
                        }
                    }
                    if (transactionalTable && !MetaStoreServerUtils.isPartitioned(table) && result.getMaxWriteId() > 0L) {
                        if (txnId < 0L) {
                            txnId = this.getMsc().openTxn(this.getUserName());
                        }
                        this.validateAndAddMaxTxnIdAndWriteId(result.getMaxWriteId(), result.getMaxTxnId(), table.getDbName(), table.getTableName(), txnId);
                    }
                }
                success = true;
                if (result == null) break block34;
                this.logResult(result);
                if (msckInfo.getResFile() == null) break block34;
            }
            catch (Exception e) {
                try {
                    LOG.warn("Failed to run metacheck: ", (Throwable)e);
                    success = false;
                    throw e;
                }
                catch (Throwable throwable) {
                    if (result != null) {
                        this.logResult(result);
                        if (msckInfo.getResFile() != null) {
                            Collections.sort(repairOutput);
                            success &= this.writeResultToFile(msckInfo, result, repairOutput, partitionExpirySeconds);
                        }
                    }
                    if (txnId > 0L) {
                        success &= this.closeTxn(qualifiedTableName, success, txnId);
                    }
                    if (this.getMsc() != null) {
                        this.getMsc().close();
                        this.msc = null;
                    }
                    throw throwable;
                }
            }
            Collections.sort(repairOutput);
            success &= this.writeResultToFile(msckInfo, result, repairOutput, partitionExpirySeconds);
        }
        if (txnId > 0L) {
            success &= this.closeTxn(qualifiedTableName, success, txnId);
        }
        if (this.getMsc() != null) {
            this.getMsc().close();
            this.msc = null;
        }
        return success ? 0 : 1;
    }

    private boolean closeTxn(String qualifiedTableName, boolean success, long txnId) {
        boolean ret = true;
        if (success) {
            try {
                LOG.info("txnId: {} succeeded. Committing..", (Object)txnId);
                this.getMsc().commitTxn(txnId);
            }
            catch (Exception e) {
                LOG.error("Error while committing txnId: {} for table: {}", new Object[]{txnId, qualifiedTableName, e});
                ret = false;
            }
        } else {
            LOG.info("txnId: {} failed. Aborting..", (Object)txnId);
            AbortTxnRequest abortTxnRequest = new AbortTxnRequest(txnId);
            abortTxnRequest.setErrorCode(TxnErrorMsg.ABORT_MSCK_TXN.getErrorCode());
            try {
                this.getMsc().rollbackTxn(abortTxnRequest);
            }
            catch (Exception e) {
                LOG.error("Error while aborting txnId: {} for table: {}", new Object[]{txnId, qualifiedTableName, e});
                ret = false;
            }
        }
        return ret;
    }

    private void logResult(CheckResult result) {
        StringBuilder sb = new StringBuilder();
        sb.append(TABLES_NOT_IN_METASTORE).append(" ").append(result.getTablesNotInMs()).append("\n").append(TABLES_MISSING_ON_FILESYSTEM).append(" ").append(result.getTablesNotOnFs()).append("\n").append(PARTITIONS_NOT_IN_METASTORE).append(" ").append(result.getPartitionsNotInMs()).append("\n").append(PARTITIONS_MISSING_FROM_FILESYSTEM).append(" ").append(result.getPartitionsNotOnFs()).append("\n").append(EXPIRED_PARTITIONS).append(" ").append(result.getExpiredPartitions()).append("\n");
        LOG.info(sb.toString());
    }

    private boolean writeResultToFile(MsckInfo msckInfo, CheckResult result, List<String> repairOutput, long partitionExpirySeconds) {
        boolean success = true;
        try {
            Path resFile = new Path(msckInfo.getResFile());
            FileSystem fs = resFile.getFileSystem(this.getConf());
            try (BufferedWriter resultOut = new BufferedWriter(new OutputStreamWriter((OutputStream)fs.create(resFile)));){
                boolean firstWritten = false;
                firstWritten |= this.writeMsckResult(result.getTablesNotInMs(), TABLES_NOT_IN_METASTORE, resultOut, firstWritten);
                firstWritten |= this.writeMsckResult(result.getTablesNotOnFs(), TABLES_MISSING_ON_FILESYSTEM, resultOut, firstWritten);
                firstWritten |= this.writeMsckResult(result.getPartitionsNotInMs(), PARTITIONS_NOT_IN_METASTORE, resultOut, firstWritten);
                firstWritten |= this.writeMsckResult(result.getPartitionsNotOnFs(), PARTITIONS_MISSING_FROM_FILESYSTEM, resultOut, firstWritten);
                firstWritten |= this.writeMsckResult(result.getExpiredPartitions(), String.format(EXPIRED_PARTITIONS_RETENTION, partitionExpirySeconds), resultOut, firstWritten);
                for (String rout : repairOutput) {
                    if (firstWritten) {
                        resultOut.write(10);
                    } else {
                        firstWritten = true;
                    }
                    resultOut.write(rout);
                }
            }
        }
        catch (IOException e) {
            LOG.error("Failed to save metacheck output: ", (Throwable)e);
            success = false;
        }
        return success;
    }

    private void validateAndAddMaxTxnIdAndWriteId(Set<CheckResult.PartitionResult> partsNotInMs, String dbName, String tableName, long txnId) throws TException {
        long maxWriteIdOnFilesystem = partsNotInMs.stream().map(CheckResult.PartitionResult::getMaxWriteId).max(Long::compareTo).orElse(0L);
        long maxVisibilityTxnId = partsNotInMs.stream().map(CheckResult.PartitionResult::getMaxTxnId).max(Long::compareTo).orElse(0L);
        this.validateAndAddMaxTxnIdAndWriteId(maxWriteIdOnFilesystem, maxVisibilityTxnId, dbName, tableName, txnId);
    }

    private void validateAndAddMaxTxnIdAndWriteId(long maxWriteIdOnFilesystem, long maxVisibilityTxnId, String dbName, String tableName, long txnId) throws TException {
        long maxAllocatedWriteId = this.getMsc().getMaxAllocatedWriteId(dbName, tableName);
        if (maxAllocatedWriteId > 0L && maxWriteIdOnFilesystem > maxAllocatedWriteId) {
            throw new MetaException(MessageFormat.format("The highest writeId [{0}] in the table ''{1}'' is greater than the maximum writeId allocated in the metastore [{2}]", maxWriteIdOnFilesystem, tableName, maxAllocatedWriteId));
        }
        if (maxAllocatedWriteId == 0L && maxWriteIdOnFilesystem > 0L) {
            LOG.debug("Seeding table {} with writeId {}", (Object)tableName, (Object)maxWriteIdOnFilesystem);
            this.getMsc().seedWriteId(dbName, tableName, maxWriteIdOnFilesystem);
        }
        if (maxVisibilityTxnId > 0L && maxVisibilityTxnId > txnId) {
            LOG.debug("Seeding global txns sequence with  {}", (Object)(maxVisibilityTxnId + 1L));
            this.getMsc().seedTxnId(maxVisibilityTxnId + 1L);
        }
    }

    private LockRequest createLockRequest(String dbName, String tableName) throws TException {
        String username = this.getUserName();
        long txnId = this.getMsc().openTxn(username);
        String agentInfo = Thread.currentThread().getName();
        LockRequestBuilder requestBuilder = new LockRequestBuilder(agentInfo);
        requestBuilder.setUser(username);
        requestBuilder.setTransactionId(txnId);
        LockComponentBuilder lockCompBuilder = new LockComponentBuilder().setDbName(dbName).setTableName(tableName).setIsTransactional(true).setExclusive().setOperationType(DataOperationType.NO_TXN);
        requestBuilder.addLockComponent(lockCompBuilder.build());
        LOG.info("Created lock(X) request with info - user: {} txnId: {} agentInfo: {} dbName: {} tableName: {}", new Object[]{username, txnId, agentInfo, dbName, tableName});
        return requestBuilder.build();
    }

    private String getUserName() {
        UserGroupInformation loggedInUser = null;
        try {
            loggedInUser = UserGroupInformation.getLoginUser();
        }
        catch (IOException e) {
            LOG.warn("Unable to get logged in user via UGI. err: {}", (Object)e.getMessage());
        }
        String username = loggedInUser == null ? System.getProperty("user.name") : loggedInUser.getShortUserName();
        return username;
    }

    public IMetaStoreClient getMsc() {
        return this.msc;
    }

    @VisibleForTesting
    public void createPartitionsInBatches(final IMetaStoreClient metastoreClient, final List<String> repairOutput, Set<CheckResult.PartitionResult> partsNotInMs, final Table table, int batchSize, int decayingFactor, int maxRetries) throws Exception {
        final String addMsgFormat = "Repair: Added partition to metastore " + table.getTableName() + ":%s";
        final HashSet<CheckResult.PartitionResult> batchWork = new HashSet<CheckResult.PartitionResult>(partsNotInMs);
        new RetryUtilities.ExponentiallyDecayingBatchWork<Void>(batchSize, decayingFactor, maxRetries){

            @Override
            public Void execute(int size) throws MetastoreException {
                try {
                    while (!batchWork.isEmpty()) {
                        ArrayList<Partition> partsToAdd = new ArrayList<Partition>();
                        int currentBatchSize = size;
                        ArrayList<CheckResult.PartitionResult> lastBatch = new ArrayList<CheckResult.PartitionResult>(currentBatchSize);
                        ArrayList<String> addMsgs = new ArrayList<String>(currentBatchSize);
                        for (CheckResult.PartitionResult part : batchWork) {
                            if (currentBatchSize == 0) break;
                            Path tablePath = MetaStoreServerUtils.getPath(table);
                            if (tablePath == null) continue;
                            LinkedHashMap partSpec = Warehouse.makeSpecFromName((String)part.getPartitionName());
                            Path location = part.getLocation(tablePath, (Map)partSpec);
                            Partition partition = MetaStoreServerUtils.createMetaPartitionObject(table, partSpec, location);
                            partition.setWriteId(table.getWriteId());
                            partsToAdd.add(partition);
                            lastBatch.add(part);
                            String msg = String.format(addMsgFormat, part.getPartitionName());
                            addMsgs.add(msg);
                            LOG.debug(msg);
                            --currentBatchSize;
                        }
                        metastoreClient.add_partitions(partsToAdd, true, false);
                        batchWork.removeAll(lastBatch);
                        repairOutput.addAll(addMsgs);
                    }
                    return null;
                }
                catch (TException e) {
                    throw new MetastoreException((Throwable)e);
                }
            }
        }.run();
    }

    private static String makePartExpr(Map<String, String> spec) throws MetaException {
        StringBuilder suffixBuf = new StringBuilder("(");
        int i = 0;
        for (Map.Entry<String, String> e : spec.entrySet()) {
            if (e.getValue() == null || e.getValue().length() == 0) {
                throw new MetaException("Partition spec is incorrect. " + spec);
            }
            if (i > 0) {
                suffixBuf.append(" AND ");
            }
            suffixBuf.append(Warehouse.escapePathName((String)e.getKey()));
            suffixBuf.append('=');
            suffixBuf.append("'").append(Warehouse.escapePathName((String)e.getValue())).append("'");
            ++i;
        }
        suffixBuf.append(")");
        return suffixBuf.toString();
    }

    @VisibleForTesting
    public void dropPartitionsInBatches(final IMetaStoreClient metastoreClient, final List<String> repairOutput, Set<CheckResult.PartitionResult> partsNotInFs, Set<CheckResult.PartitionResult> expiredPartitions, final Table table, int batchSize, int decayingFactor, int maxRetries) throws Exception {
        final String dropMsgFormat = "Repair: Dropped partition from metastore " + Warehouse.getCatalogQualifiedTableName((Table)table) + ":%s";
        final HashSet<CheckResult.PartitionResult> batchWork = new HashSet<CheckResult.PartitionResult>(partsNotInFs);
        if (expiredPartitions != null && !expiredPartitions.isEmpty()) {
            batchWork.addAll(expiredPartitions);
        }
        final PartitionDropOptions dropOptions = new PartitionDropOptions().deleteData(this.deleteData).ifExists(true).returnResults(false);
        new RetryUtilities.ExponentiallyDecayingBatchWork<Void>(batchSize, decayingFactor, maxRetries){

            @Override
            public Void execute(int size) throws MetastoreException {
                try {
                    while (!batchWork.isEmpty()) {
                        int currentBatchSize = size;
                        ArrayList<CheckResult.PartitionResult> lastBatch = new ArrayList<CheckResult.PartitionResult>(currentBatchSize);
                        ArrayList<String> dropMsgs = new ArrayList<String>(currentBatchSize);
                        ArrayList<String> dropParts = new ArrayList<String>(currentBatchSize);
                        for (CheckResult.PartitionResult part : batchWork) {
                            if (currentBatchSize == 0) break;
                            dropParts.add(part.getPartitionName());
                            lastBatch.add(part);
                            dropMsgs.add(String.format(dropMsgFormat, part.getPartitionName()));
                            --currentBatchSize;
                        }
                        List<Pair<Integer, byte[]>> partExprs = this.getPartitionExpr(dropParts);
                        metastoreClient.dropPartitions(table.getCatName(), table.getDbName(), table.getTableName(), partExprs, dropOptions);
                        batchWork.removeAll(lastBatch);
                        repairOutput.addAll(dropMsgs);
                    }
                    return null;
                }
                catch (TException e) {
                    throw new MetastoreException((Throwable)e);
                }
            }

            private List<Pair<Integer, byte[]>> getPartitionExpr(List<String> parts) throws MetaException {
                StringBuilder exprBuilder = new StringBuilder();
                for (int i = 0; i < parts.size(); ++i) {
                    String partName = parts.get(i);
                    LinkedHashMap partSpec = Warehouse.makeSpecFromName((String)partName);
                    String partExpr = Msck.makePartExpr(partSpec);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Generated partExpr: {} for partName: {}", (Object)partExpr, (Object)partName);
                    }
                    if (i > 0) {
                        exprBuilder.append(" OR ");
                    }
                    exprBuilder.append(partExpr);
                }
                return Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)parts.size(), (Object)exprBuilder.toString().getBytes(StandardCharsets.UTF_8))});
            }
        }.run();
    }

    private boolean writeMsckResult(Set<?> result, String msg, Writer out, boolean wrote) throws IOException {
        if (!result.isEmpty()) {
            if (wrote) {
                out.write(10);
            }
            out.write(msg);
            for (Object entry : result) {
                out.write(9);
                out.write(entry.toString());
            }
            return true;
        }
        return false;
    }
}

