/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.encryption;

import java.util.Map;
import org.apache.iceberg.common.DynConstructors;
import org.apache.iceberg.encryption.BaseEncryptedOutputFile;
import org.apache.iceberg.encryption.EncryptedOutputFile;
import org.apache.iceberg.encryption.EncryptionKeyMetadata;
import org.apache.iceberg.encryption.EncryptionManager;
import org.apache.iceberg.encryption.KeyManagementClient;
import org.apache.iceberg.encryption.PlaintextEncryptionManager;
import org.apache.iceberg.encryption.StandardEncryptionManager;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.util.PropertyUtil;

public class EncryptionUtil {
    private EncryptionUtil() {
    }

    public static KeyManagementClient createKmsClient(Map<String, String> catalogProperties) {
        KeyManagementClient kmsClient;
        DynConstructors.Ctor ctor;
        String kmsType = catalogProperties.get("encryption.kms-type");
        String kmsImpl = catalogProperties.get("encryption.kms-impl");
        Preconditions.checkArgument(kmsType == null || kmsImpl == null, "Cannot set both KMS type (%s) and KMS impl (%s)", (Object)kmsType, (Object)kmsImpl);
        Preconditions.checkArgument(kmsType == null, "Unsupported KMS type: %s", (Object)kmsType);
        try {
            ctor = DynConstructors.builder(KeyManagementClient.class).impl(kmsImpl, new Class[0]).buildChecked();
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(String.format("Cannot initialize KeyManagementClient, missing no-arg constructor for class %s", kmsImpl), e);
        }
        try {
            kmsClient = (KeyManagementClient)ctor.newInstance(new Object[0]);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(String.format("Cannot initialize kms client, %s does not implement KeyManagementClient interface", kmsImpl), e);
        }
        kmsClient.initialize(catalogProperties);
        return kmsClient;
    }

    public static EncryptionManager createEncryptionManager(Map<String, String> tableProperties, KeyManagementClient kmsClient) {
        Preconditions.checkArgument(kmsClient != null, "Invalid KMS client: null");
        String tableKeyId = tableProperties.get("encryption.key-id");
        if (null == tableKeyId) {
            return PlaintextEncryptionManager.instance();
        }
        int dataKeyLength = PropertyUtil.propertyAsInt(tableProperties, "encryption.data-key-length", 16);
        Preconditions.checkState(dataKeyLength == 16 || dataKeyLength == 24 || dataKeyLength == 32, "Invalid data key length: %s (must be 16, 24, or 32)", dataKeyLength);
        return new StandardEncryptionManager(tableKeyId, dataKeyLength, kmsClient);
    }

    public static EncryptedOutputFile plainAsEncryptedOutput(OutputFile encryptingOutputFile) {
        return new BaseEncryptedOutputFile(encryptingOutputFile, EncryptionKeyMetadata.empty());
    }
}

