/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.iceberg.org.apache.orc.storage.common;

import java.util.Arrays;
import java.util.BitSet;
import org.apache.hive.iceberg.org.apache.orc.storage.common.ValidWriteIdList;
import org.apache.hive.iceberg.org.apache.orc.storage.common.util.SuppressFBWarnings;

public class ValidReaderWriteIdList
implements ValidWriteIdList {
    private String tableName;
    protected long[] exceptions;
    protected BitSet abortedBits;
    private long minOpenWriteId = Long.MAX_VALUE;
    protected long highWatermark;

    public ValidReaderWriteIdList() {
        this(null, new long[0], new BitSet(), Long.MAX_VALUE, Long.MAX_VALUE);
    }

    public ValidReaderWriteIdList(String tableName, long[] exceptions, BitSet abortedBits, long highWatermark) {
        this(tableName, exceptions, abortedBits, highWatermark, Long.MAX_VALUE);
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="Ref external obj for efficiency")
    public ValidReaderWriteIdList(String tableName, long[] exceptions, BitSet abortedBits, long highWatermark, long minOpenWriteId) {
        this.tableName = tableName;
        if (exceptions.length > 0) {
            this.minOpenWriteId = minOpenWriteId;
        }
        this.exceptions = exceptions;
        this.abortedBits = abortedBits;
        this.highWatermark = highWatermark;
    }

    public ValidReaderWriteIdList(String value) {
        this.readFromString(value);
    }

    @Override
    public boolean isWriteIdValid(long writeId) {
        if (writeId > this.highWatermark) {
            return false;
        }
        return Arrays.binarySearch(this.exceptions, writeId) < 0;
    }

    @Override
    public boolean isValidBase(long writeId) {
        return writeId < this.minOpenWriteId && writeId <= this.highWatermark;
    }

    @Override
    public ValidWriteIdList.RangeResponse isWriteIdRangeValid(long minWriteId, long maxWriteId) {
        if (minWriteId > this.highWatermark) {
            return ValidWriteIdList.RangeResponse.NONE;
        }
        if (this.exceptions.length > 0 && this.exceptions[0] > maxWriteId) {
            return ValidWriteIdList.RangeResponse.ALL;
        }
        long count = Math.max(0L, maxWriteId - this.highWatermark);
        for (long txn : this.exceptions) {
            if (minWriteId > txn || txn > maxWriteId) continue;
            ++count;
        }
        if (count == 0L) {
            return ValidWriteIdList.RangeResponse.ALL;
        }
        if (count == maxWriteId - minWriteId + 1L) {
            return ValidWriteIdList.RangeResponse.NONE;
        }
        return ValidWriteIdList.RangeResponse.SOME;
    }

    public String toString() {
        return this.writeToString();
    }

    @Override
    public String writeToString() {
        StringBuilder buf = new StringBuilder();
        if (this.tableName == null) {
            buf.append("null");
        } else {
            buf.append(this.tableName);
        }
        buf.append(':');
        buf.append(this.highWatermark);
        buf.append(':');
        buf.append(this.minOpenWriteId);
        if (this.exceptions.length == 0) {
            buf.append(':');
            buf.append(':');
        } else {
            StringBuilder open = new StringBuilder();
            StringBuilder abort = new StringBuilder();
            for (int i = 0; i < this.exceptions.length; ++i) {
                if (this.abortedBits.get(i)) {
                    if (abort.length() > 0) {
                        abort.append(',');
                    }
                    abort.append(this.exceptions[i]);
                    continue;
                }
                if (open.length() > 0) {
                    open.append(',');
                }
                open.append(this.exceptions[i]);
            }
            buf.append(':');
            buf.append((CharSequence)open);
            buf.append(':');
            buf.append((CharSequence)abort);
        }
        return buf.toString();
    }

    @Override
    public void readFromString(String src) {
        if (src == null || src.length() == 0) {
            this.highWatermark = Long.MAX_VALUE;
            this.exceptions = new long[0];
            this.abortedBits = new BitSet();
        } else {
            String[] values = src.split(":");
            this.tableName = values[0];
            if (this.tableName.equalsIgnoreCase("null")) {
                this.tableName = null;
            }
            this.highWatermark = Long.parseLong(values[1]);
            this.minOpenWriteId = Long.parseLong(values[2]);
            String[] openWriteIds = new String[]{};
            String[] abortedWriteIds = new String[]{};
            if (values.length < 4) {
                openWriteIds = new String[]{};
                abortedWriteIds = new String[]{};
            } else if (values.length == 4) {
                if (!values[3].isEmpty()) {
                    openWriteIds = values[3].split(",");
                }
            } else {
                if (!values[3].isEmpty()) {
                    openWriteIds = values[3].split(",");
                }
                if (!values[4].isEmpty()) {
                    abortedWriteIds = values[4].split(",");
                }
            }
            this.exceptions = new long[openWriteIds.length + abortedWriteIds.length];
            int i = 0;
            for (String open : openWriteIds) {
                this.exceptions[i++] = Long.parseLong(open);
            }
            for (String abort : abortedWriteIds) {
                this.exceptions[i++] = Long.parseLong(abort);
            }
            Arrays.sort(this.exceptions);
            this.abortedBits = new BitSet(this.exceptions.length);
            for (String abort : abortedWriteIds) {
                int index = Arrays.binarySearch(this.exceptions, Long.parseLong(abort));
                this.abortedBits.set(index);
            }
        }
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public long getHighWatermark() {
        return this.highWatermark;
    }

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expose internal rep for efficiency")
    public long[] getInvalidWriteIds() {
        return this.exceptions;
    }

    @Override
    public Long getMinOpenWriteId() {
        return this.minOpenWriteId == Long.MAX_VALUE ? null : Long.valueOf(this.minOpenWriteId);
    }

    @Override
    public boolean isWriteIdAborted(long writeId) {
        int index = Arrays.binarySearch(this.exceptions, writeId);
        return index >= 0 && this.abortedBits.get(index);
    }

    @Override
    public ValidWriteIdList.RangeResponse isWriteIdRangeAborted(long minWriteId, long maxWriteId) {
        long abortedTxnId;
        if (this.highWatermark < minWriteId) {
            return ValidWriteIdList.RangeResponse.NONE;
        }
        int count = 0;
        int i = this.abortedBits.nextSetBit(0);
        while (i >= 0 && (abortedTxnId = this.exceptions[i]) <= maxWriteId) {
            if (abortedTxnId >= minWriteId && abortedTxnId <= maxWriteId) {
                ++count;
            }
            i = this.abortedBits.nextSetBit(i + 1);
        }
        if (count == 0) {
            return ValidWriteIdList.RangeResponse.NONE;
        }
        if ((long)count == maxWriteId - minWriteId + 1L) {
            return ValidWriteIdList.RangeResponse.ALL;
        }
        return ValidWriteIdList.RangeResponse.SOME;
    }

    public ValidReaderWriteIdList updateHighWatermark(long value) {
        return new ValidReaderWriteIdList(this.tableName, this.exceptions, this.abortedBits, value, this.minOpenWriteId);
    }
}

