/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.util.List;
import java.util.Optional;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ColStatistics;
import org.apache.hadoop.hive.ql.stats.estimator.PessimisticStatCombiner;
import org.apache.hadoop.hive.ql.stats.estimator.StatEstimator;
import org.apache.hadoop.hive.ql.stats.estimator.StatEstimatorProvider;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFUtils;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BooleanObjectInspector;

@Description(name="when", value="CASE WHEN a THEN b [WHEN c THEN d]* [ELSE e] END - When a = true, returns b; when c = true, return d; else return e", extended="Example:\n SELECT\n CASE\n   WHEN deptno=1 THEN Engineering\n   WHEN deptno=2 THEN Finance\n   ELSE admin\n END,\n CASE\n   WHEN zone=7 THEN Americas\n   ELSE Asia-Pac\n END\n FROM emp_details")
public class GenericUDFWhen
extends GenericUDF
implements StatEstimatorProvider {
    private transient ObjectInspector[] argumentOIs;
    private transient GenericUDFUtils.ReturnObjectInspectorResolver returnOIResolver;

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentTypeException {
        this.argumentOIs = arguments;
        this.returnOIResolver = new GenericUDFUtils.ReturnObjectInspectorResolver(true);
        int i = 0;
        while (i + 1 < arguments.length) {
            if (!arguments[i].getTypeName().equals("boolean")) {
                throw new UDFArgumentTypeException(i, "\"boolean\" is expected after WHEN, but \"" + arguments[i].getTypeName() + "\" is found");
            }
            if (!this.returnOIResolver.update(arguments[i + 1])) {
                throw new UDFArgumentTypeException(i + 1, "The expressions after THEN should have the same type: \"" + this.returnOIResolver.get().getTypeName() + "\" is expected but \"" + arguments[i + 1].getTypeName() + "\" is found");
            }
            i += 2;
        }
        if (arguments.length % 2 == 1 && !this.returnOIResolver.update(arguments[(i = arguments.length - 2) + 1])) {
            throw new UDFArgumentTypeException(i + 1, "The expression after ELSE should have the same type as those after THEN: \"" + this.returnOIResolver.get().getTypeName() + "\" is expected but \"" + arguments[i + 1].getTypeName() + "\" is found");
        }
        return this.returnOIResolver.get();
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        int i = 0;
        while (i + 1 < arguments.length) {
            Object caseKey = arguments[i].get();
            if (caseKey != null && ((BooleanObjectInspector)this.argumentOIs[i]).get(caseKey)) {
                Object caseValue = arguments[i + 1].get();
                return this.returnOIResolver.convertIfNecessary(caseValue, this.argumentOIs[i + 1]);
            }
            i += 2;
        }
        if (arguments.length % 2 == 1) {
            i = arguments.length - 2;
            Object elseValue = arguments[i + 1].get();
            return this.returnOIResolver.convertIfNecessary(elseValue, this.argumentOIs[i + 1]);
        }
        return null;
    }

    @Override
    public String getDisplayString(String[] children) {
        assert (children.length >= 2);
        StringBuilder sb = new StringBuilder();
        sb.append("CASE");
        int i = 0;
        while (i + 1 < children.length) {
            sb.append(" WHEN (");
            sb.append(children[i]);
            sb.append(") THEN (");
            sb.append(children[i + 1]);
            sb.append(")");
            i += 2;
        }
        if (children.length % 2 == 1) {
            sb.append(" ELSE (");
            sb.append(children[children.length - 1]);
            sb.append(")");
        }
        sb.append(" END");
        return sb.toString();
    }

    @Override
    public StatEstimator getStatEstimator() {
        return new WhenStatEstimator();
    }

    static class WhenStatEstimator
    implements StatEstimator {
        WhenStatEstimator() {
        }

        @Override
        public Optional<ColStatistics> estimate(List<ColStatistics> argStats) {
            PessimisticStatCombiner combiner = new PessimisticStatCombiner();
            for (int i = 1; i < argStats.size(); i += 2) {
                combiner.add(argStats.get(i));
            }
            if (argStats.size() % 2 == 1) {
                combiner.add(argStats.get(argStats.size() - 1));
            }
            return combiner.getResult();
        }
    }
}

