/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.esri;

import com.esri.core.geometry.ogc.OGCGeometry;
import com.fasterxml.jackson.core.JsonFactory;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.esri.GeometryUtils;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;

@Description(name="ST_GeomFromJSON", value="_FUNC_(json) - construct an ST_Geometry from Esri JSON", extended="Example:\n  SELECT _FUNC_('{\"x\":0.0,\"y\":0.0}') FROM src LIMIT 1;  -- constructs ST_Point\n")
public class ST_GeomFromJson
extends GenericUDF {
    static final JsonFactory jsonFactory = new JsonFactory();
    ObjectInspector jsonOI;

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        GenericUDF.DeferredObject jsonDeferredObject = arguments[0];
        String json = null;
        if (this.jsonOI.getCategory() != ObjectInspector.Category.STRUCT) {
            PrimitiveObjectInspector primOI = (PrimitiveObjectInspector)this.jsonOI;
            json = (String)primOI.getPrimitiveJavaObject(jsonDeferredObject.get());
        }
        try {
            OGCGeometry ogcGeom = OGCGeometry.fromJson(json);
            return GeometryUtils.geometryToEsriShapeBytesWritable(ogcGeom);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public String getDisplayString(String[] args) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName());
        String delim = "(";
        for (String arg : args) {
            sb.append(delim).append(arg);
            delim = ", ";
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length != 1) {
            throw new UDFArgumentLengthException("ST_GeomFromJson takes only one argument");
        }
        ObjectInspector argJsonOI = arguments[0];
        if (argJsonOI.getCategory() == ObjectInspector.Category.PRIMITIVE) {
            PrimitiveObjectInspector poi = (PrimitiveObjectInspector)argJsonOI;
            if (poi.getPrimitiveCategory() != PrimitiveObjectInspector.PrimitiveCategory.STRING) {
                throw new UDFArgumentTypeException(0, "ST_GeomFromJson argument category must be either a string primitive or struct");
            }
        } else if (argJsonOI.getCategory() == ObjectInspector.Category.STRUCT) {
            throw new UDFArgumentTypeException(0, "ST_GeomFromJson argument category must be either a string primitive or struct");
        }
        this.jsonOI = argJsonOI;
        return GeometryUtils.geometryTransportObjectInspector;
    }
}

