/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.txn.compactor;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import java.util.LongSummaryStatistics;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.ServerUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponse;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponseElement;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.hadoop.hive.metastore.txn.entities.CompactionInfo;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.txn.compactor.CompactorUtil;
import org.apache.hadoop.hive.ql.txn.compactor.MetaStoreCompactorThread;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Initiator
extends MetaStoreCompactorThread {
    private static final String CLASS_NAME = Initiator.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger((String)CLASS_NAME);
    private ExecutorService compactionExecutor;
    private boolean metricsEnabled;
    private boolean shouldUseMutex = true;

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 24[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    protected boolean isCacheEnabled() {
        return MetastoreConf.getBoolVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_INITIATOR_TABLECACHE_ON);
    }

    private Database resolveDatabase(CompactionInfo ci) throws MetaException, NoSuchObjectException {
        return CompactorUtil.resolveDatabase(this.conf, ci.dbname);
    }

    @VisibleForTesting
    protected String resolveUserToRunAs(Map<String, String> cache, Table t, Partition p) throws IOException, InterruptedException {
        String fullTableName = TxnUtils.getFullTableName((String)t.getDbName(), (String)t.getTableName());
        StorageDescriptor sd = CompactorUtil.resolveStorageDescriptor(t, p);
        String user = cache.get(fullTableName);
        if (user == null) {
            user = TxnUtils.findUserToRunAs((String)sd.getLocation(), (Table)t, (Configuration)this.conf);
            cache.put(fullTableName, user);
        }
        return user;
    }

    @Override
    public void init(AtomicBoolean stop) throws Exception {
        super.init(stop);
        this.checkInterval = this.conf.getTimeVar(HiveConf.ConfVars.HIVE_COMPACTOR_CHECK_INTERVAL, TimeUnit.MILLISECONDS);
        this.compactionExecutor = CompactorUtil.createExecutorWithThreadFactory(this.conf.getIntVar(HiveConf.ConfVars.HIVE_COMPACTOR_REQUEST_QUEUE), "Initiator-executor-thread-%d");
        this.metricsEnabled = MetastoreConf.getBoolVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METRICS_ENABLED) && MetastoreConf.getBoolVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METASTORE_ACIDMETRICS_EXT_ON);
    }

    private void recoverFailedCompactions(boolean remoteOnly) throws MetaException {
        if (!remoteOnly) {
            this.txnHandler.revokeFromLocalWorkers(ServerUtils.hostname());
        }
        this.txnHandler.revokeTimedoutWorkers(HiveConf.getTimeVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_COMPACTOR_WORKER_TIMEOUT, (TimeUnit)TimeUnit.MILLISECONDS));
    }

    private boolean foundCurrentOrFailedCompactions(ShowCompactResponse compactions, CompactionInfo ci) throws MetaException {
        boolean needsRetry;
        if (compactions.getCompacts() == null) {
            return false;
        }
        List filteredElements = compactions.getCompacts().stream().filter(e -> e.getDbname().equals(ci.dbname) && e.getTablename().equals(ci.tableName) && (e.getPartitionname() == null && ci.partName == null || Objects.equals(e.getPartitionname(), ci.partName))).collect(Collectors.toList());
        if (filteredElements.stream().anyMatch(e -> "working".equals(e.getState()) || "initiated".equals(e.getState()))) {
            LOG.info("Found currently initiated or working compaction for " + ci.getFullPartitionName() + " so we will not initiate another compaction");
            return true;
        }
        int failedThreshold = MetastoreConf.getIntVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_INITIATOR_FAILED_THRESHOLD);
        LongSummaryStatistics failedStats = filteredElements.stream().filter(e -> "succeeded".equals(e.getState()) || "failed".equals(e.getState())).sorted(Comparator.comparingLong(ShowCompactResponseElement::getId).reversed()).limit(failedThreshold).filter(e -> "failed".equals(e.getState())).collect(Collectors.summarizingLong(ShowCompactResponseElement::getEnqueueTime));
        long retryTime = MetastoreConf.getTimeVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_INITIATOR_FAILED_RETRY_TIME, (TimeUnit)TimeUnit.MILLISECONDS);
        boolean bl = needsRetry = retryTime > 0L && failedStats.getMax() + retryTime < System.currentTimeMillis();
        if (failedStats.getCount() == (long)failedThreshold && !needsRetry) {
            LOG.warn("Will not initiate compaction for " + ci.getFullPartitionName() + " since last " + MetastoreConf.ConfVars.COMPACTOR_INITIATOR_FAILED_THRESHOLD + " attempts to compact it failed.");
            ci.errorMessage = "Compaction is not initiated since last " + MetastoreConf.ConfVars.COMPACTOR_INITIATOR_FAILED_THRESHOLD + " consecutive compaction attempts failed)";
            this.txnHandler.markFailed(ci);
            return true;
        }
        return false;
    }

    private static boolean isDynPartIngest(Table t, CompactionInfo ci) {
        if (t.getPartitionKeys() != null && t.getPartitionKeys().size() > 0 && ci.partName == null && !ci.hasOldAbort) {
            LOG.info("Skipping entry for " + ci.getFullTableName() + " as it is from dynamic partitioning");
            return true;
        }
        return false;
    }

    private boolean isEligibleForCompaction(CompactionInfo ci, ShowCompactResponse currentCompactions, Set<String> skipDBs, Set<String> skipTables) {
        try {
            if (skipDBs.contains(ci.dbname)) {
                LOG.info("Skipping {}::{}, skipDBs::size:{}", new Object[]{ci.dbname, ci.tableName, skipDBs.size()});
                return false;
            }
            if (this.replIsCompactionDisabledForDatabase(ci.dbname)) {
                skipDBs.add(ci.dbname);
                LOG.info("Skipping {} as compaction is disabled due to repl; skipDBs::size:{}", (Object)ci.dbname, (Object)skipDBs.size());
                return false;
            }
            if (skipTables.contains(ci.getFullTableName())) {
                return false;
            }
            LOG.info("Checking to see if we should compact " + ci.getFullPartitionName());
            if (this.foundCurrentOrFailedCompactions(currentCompactions, ci)) {
                return false;
            }
            Table t = this.metadataCache.computeIfAbsent(ci.getFullTableName(), () -> this.resolveTable(ci));
            if (t == null) {
                LOG.info("Can't find table " + ci.getFullTableName() + ", assuming it's a temp table or has been dropped and moving on.");
                return false;
            }
            if (this.replIsCompactionDisabledForTable(t)) {
                skipTables.add(ci.getFullTableName());
                return false;
            }
            Map dbParams = this.metadataCache.computeIfAbsent(ci.dbname, () -> this.resolveDatabase(ci)).getParameters();
            if (MetaStoreUtils.isNoAutoCompactSet((Map)dbParams, (Map)t.getParameters())) {
                if (Boolean.parseBoolean(MetaStoreUtils.getNoAutoCompact((Map)dbParams))) {
                    skipDBs.add(ci.dbname);
                    LOG.info("DB " + ci.dbname + " marked no_auto_compaction=true so we will not compact it.");
                } else {
                    skipTables.add(ci.getFullTableName());
                    LOG.info("Table " + this.tableName(t) + " marked no_auto_compaction=true so we will not compact it.");
                }
                return false;
            }
            if (AcidUtils.isInsertOnlyTable(t.getParameters()) && !HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_COMPACTOR_COMPACT_MM)) {
                skipTables.add(ci.getFullTableName());
                LOG.info("Table " + this.tableName(t) + " is insert only and " + HiveConf.ConfVars.HIVE_COMPACTOR_COMPACT_MM.varname + "=false so we will not compact it.");
                return false;
            }
            if (Initiator.isDynPartIngest(t, ci)) {
                return false;
            }
        }
        catch (Throwable e) {
            LOG.error("Caught exception while checking compaction eligibility.", e);
            try {
                ci.errorMessage = e.getMessage();
                this.txnHandler.markFailed(ci);
            }
            catch (MetaException ex) {
                LOG.error("Caught exception while marking compaction as failed.", e);
            }
            return false;
        }
        return true;
    }

    public void enforceMutex(boolean enableMutex) {
        this.shouldUseMutex = enableMutex;
    }

    private static /* synthetic */ Void lambda$run$4(String tableName, String partition, Throwable exc) {
        LOG.error("Error while running scheduling the compaction on the table {} / partition {}.", new Object[]{tableName, partition, exc});
        return null;
    }

    private /* synthetic */ void lambda$run$3(CompactionInfo ci, Table t, Partition p, String runAs) throws Exception {
        CompactorUtil.scheduleCompactionIfRequired(ci, t, p, runAs, this.metricsEnabled, this.hostName, this.txnHandler, this.conf);
    }

    private /* synthetic */ Table lambda$run$2(CompactionInfo ci) throws Exception {
        return this.resolveTable(ci);
    }

    private /* synthetic */ Set lambda$run$1(int abortedThreshold, long abortedTimeThreshold, long prevStart, ShowCompactResponse currentCompactions, Set skipDBs, Set skipTables) throws Exception {
        return this.txnHandler.findPotentialCompactions(abortedThreshold, abortedTimeThreshold, prevStart).parallelStream().filter(ci -> this.isEligibleForCompaction((CompactionInfo)ci, currentCompactions, skipDBs, skipTables)).collect(Collectors.toSet());
    }

    private static class InitiatorCycleUpdater
    implements Runnable {
        private final String metric;
        private final long startedAt;
        private final long warningThreshold;
        private final long errorThreshold;
        private boolean errorReported;
        private boolean warningReported;

        InitiatorCycleUpdater(String metric, long startedAt, long warningThreshold, long errorThreshold) {
            this.metric = metric;
            this.startedAt = startedAt;
            this.warningThreshold = warningThreshold;
            this.errorThreshold = errorThreshold;
        }

        @Override
        public void run() {
            long elapsed = MetaStoreCompactorThread.updateCycleDurationMetric(this.metric, this.startedAt);
            if (elapsed >= this.errorThreshold) {
                if (!this.errorReported) {
                    LOG.error("Long running Initiator has been detected, duration {}", (Object)elapsed);
                    this.errorReported = true;
                }
            } else if (elapsed >= this.warningThreshold && !this.warningReported && !this.errorReported) {
                this.warningReported = true;
                LOG.warn("Long running Initiator has been detected, duration {}", (Object)elapsed);
            }
        }
    }
}

