/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.session;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hive.ql.session.SessionState;

class ResourceMaps {
    private final Map<SessionState.ResourceType, Set<String>> resource_map = new HashMap<SessionState.ResourceType, Set<String>>();
    private final Map<SessionState.ResourceType, Map<String, Set<String>>> resource_path_map = new HashMap<SessionState.ResourceType, Map<String, Set<String>>>();
    private final Map<SessionState.ResourceType, Map<String, Set<String>>> reverse_resource_path_map = new HashMap<SessionState.ResourceType, Map<String, Set<String>>>();
    private final Map<SessionState.ResourceType, Map<String, String>> local_hdfs_resource_map = new HashMap<SessionState.ResourceType, Map<String, String>>();

    public Map<SessionState.ResourceType, Set<String>> getResourceMap() {
        return this.resource_map;
    }

    public Map<SessionState.ResourceType, Map<String, String>> getAllLocalHdfsLocationMap() {
        return this.local_hdfs_resource_map;
    }

    public Set<String> getResourceSet(SessionState.ResourceType t) {
        Set<String> result = this.resource_map.get((Object)t);
        if (result == null) {
            result = new HashSet<String>();
            this.resource_map.put(t, result);
        }
        return result;
    }

    public Map<String, Set<String>> getResourcePathMap(SessionState.ResourceType t) {
        Map<String, Set<String>> result = this.resource_path_map.get((Object)t);
        if (result == null) {
            result = new HashMap<String, Set<String>>();
            this.resource_path_map.put(t, result);
        }
        return result;
    }

    public Map<String, Set<String>> getReverseResourcePathMap(SessionState.ResourceType t) {
        Map<String, Set<String>> result = this.reverse_resource_path_map.get((Object)t);
        if (result == null) {
            result = new HashMap<String, Set<String>>();
            this.reverse_resource_path_map.put(t, result);
        }
        return result;
    }

    public Map<String, String> getLocalHdfsLocationMap(SessionState.ResourceType type) {
        Map<String, String> result = this.local_hdfs_resource_map.get((Object)type);
        if (result == null) {
            result = new HashMap<String, String>();
            this.local_hdfs_resource_map.put(type, result);
        }
        return result;
    }
}

