/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.security.authorization;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.UnaryOperator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.ql.Context;

public class HiveCustomStorageHandlerUtils {
    public static final String WRITE_OPERATION_CONFIG_PREFIX = "file.sink.write.operation.";
    public static final String WRITE_OPERATION_IS_SORTED = "file.sink.write.operation.sorted.";
    public static final String MERGE_TASK_ENABLED = "file.sink.merge.task.enabled.";

    public static String getTablePropsForCustomStorageHandler(Map<String, String> tableProperties) {
        StringBuilder properties = new StringBuilder();
        for (Map.Entry<String, String> serdeMap : tableProperties.entrySet()) {
            if (serdeMap.getKey().equalsIgnoreCase("serialization.format") || serdeMap.getKey().equalsIgnoreCase("COLUMN_STATS_ACCURATE")) continue;
            properties.append(serdeMap.getValue().replaceAll("\\s", "").replaceAll("\"", ""));
            properties.append("/");
        }
        return properties.toString();
    }

    public static Map<String, String> getTableProperties(Table table) {
        HashMap<String, String> tblProps = new HashMap<String, String>(table.getParameters());
        Optional.ofNullable(table.getSd().getSerdeInfo().getParameters()).ifPresent(tblProps::putAll);
        return tblProps;
    }

    public static Context.Operation getWriteOperation(UnaryOperator<String> ops, String tableName) {
        String operation = (String)ops.apply(WRITE_OPERATION_CONFIG_PREFIX + tableName);
        return operation == null ? null : Context.Operation.valueOf(operation);
    }

    public static void setWriteOperation(Configuration conf, String tableName, Context.Operation operation) {
        if (conf == null || tableName == null) {
            return;
        }
        conf.set(WRITE_OPERATION_CONFIG_PREFIX + tableName, operation.name());
    }

    public static void setWriteOperationIsSorted(Configuration conf, String tableName, boolean isSorted) {
        if (conf == null || tableName == null) {
            return;
        }
        conf.set(WRITE_OPERATION_IS_SORTED + tableName, Boolean.toString(isSorted));
    }

    public static boolean getWriteOperationIsSorted(UnaryOperator<String> ops, String tableName) {
        String operation = (String)ops.apply(WRITE_OPERATION_IS_SORTED + tableName);
        return Boolean.parseBoolean(operation);
    }

    public static void setMergeTaskEnabled(Configuration conf, String tableName, boolean isMerge) {
        if (conf == null || tableName == null) {
            return;
        }
        conf.set(MERGE_TASK_ENABLED + tableName, Boolean.toString(isMerge));
    }

    public static boolean isMergeTaskEnabled(UnaryOperator<String> ops, String tableName) {
        String operation = (String)ops.apply(MERGE_TASK_ENABLED + tableName);
        return Boolean.parseBoolean(operation);
    }
}

