/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.processors;

import java.util.Arrays;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hive.conf.HiveVariableSource;
import org.apache.hadoop.hive.conf.VariableSubstitution;
import org.apache.hadoop.hive.ql.processors.CommandProcessor;
import org.apache.hadoop.hive.ql.processors.CommandProcessorException;
import org.apache.hadoop.hive.ql.processors.CommandProcessorResponse;
import org.apache.hadoop.hive.ql.processors.CommandUtil;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveOperationType;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteResourceProcessor
implements CommandProcessor {
    private static final Logger LOG = LoggerFactory.getLogger((String)DeleteResourceProcessor.class.getName());
    private static final SessionState.LogHelper console = new SessionState.LogHelper(LOG);

    @Override
    public CommandProcessorResponse run(String command) throws CommandProcessorException {
        SessionState.ResourceType t;
        SessionState ss = SessionState.get();
        command = new VariableSubstitution(new HiveVariableSource(){

            public Map<String, String> getHiveVariable() {
                return SessionState.get().getHiveVariables();
            }
        }).substitute(ss.getConf(), command);
        String[] tokens = command.split("\\s+");
        if (tokens.length < 1 || (t = SessionState.find_resource_type(tokens[0])) == null) {
            console.printError("Usage: delete [" + StringUtils.join((Object[])SessionState.ResourceType.values(), (String)"|") + "] <value> [<value>]*");
            throw new CommandProcessorException(1);
        }
        CommandProcessorResponse authErrResp = CommandUtil.authorizeCommand(ss, HiveOperationType.DELETE, Arrays.asList(tokens));
        if (authErrResp != null) {
            return authErrResp;
        }
        if (tokens.length >= 2) {
            ss.delete_resources(t, Arrays.asList(Arrays.copyOfRange(tokens, 1, tokens.length)));
        } else {
            ss.delete_resources(t);
        }
        return new CommandProcessorResponse();
    }

    @Override
    public void close() throws Exception {
    }
}

