/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.listbucketingpruner;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.optimizer.PrunerUtils;
import org.apache.hadoop.hive.ql.optimizer.Transform;
import org.apache.hadoop.hive.ql.optimizer.listbucketingpruner.LBOpPartitionWalkerCtx;
import org.apache.hadoop.hive.ql.optimizer.listbucketingpruner.LBOpWalkerCtx;
import org.apache.hadoop.hive.ql.optimizer.listbucketingpruner.LBPartitionProcFactory;
import org.apache.hadoop.hive.ql.optimizer.listbucketingpruner.LBProcFactory;
import org.apache.hadoop.hive.ql.optimizer.listbucketingpruner.ListBucketingPrunerUtils;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.PrunedPartitionList;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListBucketingPruner
extends Transform {
    static final Logger LOG = LoggerFactory.getLogger((String)ListBucketingPruner.class.getName());

    @Override
    public ParseContext transform(ParseContext pctx) throws SemanticException {
        Set<Partition> parts;
        LBOpPartitionWalkerCtx opPartWalkerCtx = new LBOpPartitionWalkerCtx(pctx);
        PrunerUtils.walkOperatorTree(pctx, opPartWalkerCtx, LBPartitionProcFactory.getFilterProc(), LBPartitionProcFactory.getDefaultProc());
        PrunedPartitionList partsList = opPartWalkerCtx.getPartitions();
        if (partsList != null && (parts = partsList.getPartitions()) != null && parts.size() > 0) {
            for (Partition part : parts) {
                if (!ListBucketingPrunerUtils.isListBucketingPart(part)) continue;
                LBOpWalkerCtx opWalkerCtx = new LBOpWalkerCtx(pctx.getOpToPartToSkewedPruner(), part);
                PrunerUtils.walkOperatorTree(pctx, opWalkerCtx, LBProcFactory.getFilterProc(), LBProcFactory.getDefaultProc());
            }
        }
        return pctx;
    }

    public static Path[] prune(ParseContext ctx, Partition part, ExprNodeDesc pruner) {
        Path[] finalPaths = null;
        try {
            finalPaths = ListBucketingPruner.execute(ctx, part, pruner);
        }
        catch (SemanticException e) {
            LOG.warn("Using full partition scan :" + Arrays.toString(part.getPath()) + ".", (Throwable)e);
            finalPaths = part.getPath();
        }
        return finalPaths;
    }

    private static Path[] execute(ParseContext ctx, Partition part, ExprNodeDesc pruner) throws SemanticException {
        Path[] finalPaths;
        ArrayList<Path> selectedPaths = new ArrayList<Path>();
        if (ListBucketingPrunerUtils.isUnknownState(pruner)) {
            LOG.warn("List bucketing pruner is either null or in unknown state  so that it uses full partition scan :" + Arrays.toString(part.getPath()));
            finalPaths = part.getPath();
        } else {
            List<List<String>> sVals = part.getSkewedColValues();
            assert (sVals != null && sVals.size() > 0) : part.getName() + " skewed metadata is corrupted. No skewed value information.";
            List<List<String>> indexCollection = DynamicMultiDimensionalCollection.generateCollection(sVals);
            assert (indexCollection != null) : "Collection is null.";
            List<List<String>> uniqSkewValues = DynamicMultiDimensionalCollection.uniqueSkewedValueList(sVals);
            List<Boolean> nonSkewedValueMatchResult = ListBucketingPruner.decideSkewedValueDirSelection(part, pruner, selectedPaths, indexCollection, uniqSkewValues);
            ListBucketingPruner.decideDefaultDirSelection(part, selectedPaths, nonSkewedValueMatchResult);
            finalPaths = ListBucketingPruner.generateFinalPath(part, selectedPaths);
        }
        return finalPaths;
    }

    private static List<Boolean> decideSkewedValueDirSelection(Partition part, ExprNodeDesc pruner, List<Path> selectedPaths, List<List<String>> collections, List<List<String>> uniqSkewedValues) throws SemanticException {
        List<String> skewedCols = part.getSkewedColNames();
        Map<List<String>, String> mappings = part.getSkewedColValueLocationMaps();
        assert (ListBucketingPrunerUtils.isListBucketingPart(part)) : part.getName() + " skewed metadata is corrupted. No skewed column and/or location mappings information.";
        List<List<String>> skewedValues = part.getSkewedColValues();
        ArrayList<Boolean> nonSkewedValueMatchResult = new ArrayList<Boolean>();
        for (List<String> cell : collections) {
            Boolean matchResult = ListBucketingPrunerUtils.evaluateExprOnCell(skewedCols, cell, pruner, uniqSkewedValues);
            if (skewedValues.contains(cell)) {
                if (matchResult != null && !matchResult.booleanValue() || mappings.get(cell) == null) continue;
                selectedPaths.add(new Path(mappings.get(cell)));
                continue;
            }
            nonSkewedValueMatchResult.add(matchResult);
        }
        return nonSkewedValueMatchResult;
    }

    private static void decideDefaultDirSelection(Partition part, List<Path> selectedPaths, List<Boolean> nonSkewedValueMatchResult) {
        boolean skipDefDir = true;
        for (Boolean v : nonSkewedValueMatchResult) {
            if (v != null && !v.booleanValue()) continue;
            skipDefDir = false;
            break;
        }
        if (!skipDefDir) {
            StringBuilder builder = new StringBuilder();
            builder.append(part.getLocation());
            builder.append("/");
            builder.append(FileUtils.makeDefaultListBucketingDirName(part.getSkewedColNames(), (String)"HIVE_DEFAULT_LIST_BUCKETING_DIR_NAME"));
            selectedPaths.add(new Path(builder.toString()));
        }
    }

    private static Path[] generateFinalPath(Partition part, List<Path> selectedPaths) {
        Path[] finalPaths;
        if (selectedPaths.size() == 0) {
            LOG.warn("Using full partition scan :" + Arrays.toString(part.getPath()) + ".");
            finalPaths = part.getPath();
        } else {
            finalPaths = selectedPaths.toArray(new Path[0]);
        }
        return finalPaths;
    }

    public static class DynamicMultiDimensionalCollection {
        public static List<List<String>> generateCollection(List<List<String>> values) throws SemanticException {
            List<List<String>> uniqSkewedElements = DynamicMultiDimensionalCollection.uniqueElementsList(values, "HIVE_DEFAULT_LIST_BUCKETING_KEY");
            return DynamicMultiDimensionalCollection.flat(uniqSkewedElements);
        }

        public static List<List<String>> uniqueElementsList(List<List<String>> values, String defaultDirName) {
            List<List<String>> result = DynamicMultiDimensionalCollection.uniqueSkewedValueList(values);
            for (List<String> list : result) {
                list.add(defaultDirName);
            }
            return result;
        }

        public static List<List<String>> uniqueSkewedValueList(List<List<String>> values) {
            if (values == null || values.size() == 0) {
                return null;
            }
            ArrayList<List<String>> result = new ArrayList<List<String>>();
            for (int i = 0; i < values.get(0).size(); ++i) {
                result.add(new ArrayList());
            }
            for (List<String> value : values) {
                for (int i = 0; i < value.size(); ++i) {
                    if (((List)result.get(i)).contains(value.get(i))) continue;
                    ((List)result.get(i)).add(value.get(i));
                }
            }
            return result;
        }

        public static List<List<String>> flat(List<List<String>> uniqSkewedElements) throws SemanticException {
            if (uniqSkewedElements == null) {
                return null;
            }
            ArrayList<List<String>> collection = new ArrayList<List<String>>();
            DynamicMultiDimensionalCollection.walker(collection, uniqSkewedElements, new ArrayList<String>(), 0);
            return collection;
        }

        private static void walker(List<List<String>> finalResult, List<List<String>> input, List<String> listSoFar, int level) throws SemanticException {
            if (level == input.size() - 1) {
                assert (input.get(level) != null) : "Unique skewed element list has null list in " + level + "th position.";
                for (String v : input.get(level)) {
                    ArrayList<String> oneCompleteIndex = new ArrayList<String>(listSoFar);
                    oneCompleteIndex.add(v);
                    finalResult.add(oneCompleteIndex);
                }
                return;
            }
            for (String v : input.get(level)) {
                ArrayList<String> clonedListSoFar = new ArrayList<String>(listSoFar);
                clonedListSoFar.add(v);
                int nextLevel = level + 1;
                DynamicMultiDimensionalCollection.walker(finalResult, input, clonedListSoFar, nextLevel);
            }
        }
    }
}

