/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet;

import com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.hive.ql.io.parquet.FilterPredicateLeafBuilder;
import org.apache.hadoop.hive.ql.io.sarg.PredicateLeaf;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.parquet.filter2.predicate.FilterApi;
import org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.parquet.filter2.predicate.Operators;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeafFilterFactory {
    private static final Logger LOG = LoggerFactory.getLogger(LeafFilterFactory.class);
    @VisibleForTesting
    public static final String FILTER_PREDICATE_CONVERSION_NOT_SUPPORTED = "The conversion to Parquet FilterPredicate is not supported for %s. Please try to set the following configurations at the session level\n set hive.optimize.index.filter=false;\n set hive.optimize.ppd=false;\n";

    public FilterPredicateLeafBuilder getLeafFilterBuilderByType(PredicateLeaf.Type type, Type parquetType) throws HiveException {
        switch (type) {
            case LONG: 
            case FLOAT: 
            case STRING: 
            case BOOLEAN: {
                return this.getLeafFilterBuilderByParquetType(parquetType);
            }
        }
        String msg = String.format(FILTER_PREDICATE_CONVERSION_NOT_SUPPORTED, type);
        LOG.debug(msg);
        throw new HiveException(msg);
    }

    private FilterPredicateLeafBuilder getLeafFilterBuilderByParquetType(Type parquetType) throws HiveException {
        switch (parquetType.asPrimitiveType().getPrimitiveTypeName()) {
            case INT32: {
                return new IntFilterPredicateLeafBuilder();
            }
            case INT64: {
                return new LongFilterPredicateLeafBuilder();
            }
            case FLOAT: {
                return new FloatFilterPredicateLeafBuilder();
            }
            case DOUBLE: {
                return new DoubleFilterPredicateLeafBuilder();
            }
            case BINARY: {
                return new BinaryFilterPredicateLeafBuilder();
            }
            case BOOLEAN: {
                return new BooleanFilterPredicateLeafBuilder();
            }
        }
        String msg = String.format(FILTER_PREDICATE_CONVERSION_NOT_SUPPORTED, parquetType.asPrimitiveType().getPrimitiveTypeName());
        LOG.debug(msg);
        throw new HiveException(msg);
    }

    class IntFilterPredicateLeafBuilder
    extends FilterPredicateLeafBuilder {
        IntFilterPredicateLeafBuilder() {
        }

        @Override
        public FilterPredicate buildPredict(PredicateLeaf.Operator op, Object literal, String columnName, TypeInfo columnType) {
            switch (op) {
                case LESS_THAN: {
                    return FilterApi.lt((Operators.Column)FilterApi.intColumn((String)columnName), (Comparable)Integer.valueOf(((Number)literal).intValue()));
                }
                case IS_NULL: 
                case EQUALS: 
                case NULL_SAFE_EQUALS: {
                    return FilterApi.eq((Operators.Column)FilterApi.intColumn((String)columnName), literal == null ? null : Integer.valueOf(((Number)literal).intValue()));
                }
                case LESS_THAN_EQUALS: {
                    return FilterApi.ltEq((Operators.Column)FilterApi.intColumn((String)columnName), (Comparable)Integer.valueOf(((Number)literal).intValue()));
                }
            }
            throw new RuntimeException("Unknown PredicateLeaf Operator type: " + op);
        }
    }

    class LongFilterPredicateLeafBuilder
    extends FilterPredicateLeafBuilder {
        LongFilterPredicateLeafBuilder() {
        }

        @Override
        public FilterPredicate buildPredict(PredicateLeaf.Operator op, Object constant, String columnName, TypeInfo columnType) {
            switch (op) {
                case LESS_THAN: {
                    return FilterApi.lt((Operators.Column)FilterApi.longColumn((String)columnName), (Comparable)Long.valueOf(((Number)constant).longValue()));
                }
                case IS_NULL: 
                case EQUALS: 
                case NULL_SAFE_EQUALS: {
                    return FilterApi.eq((Operators.Column)FilterApi.longColumn((String)columnName), constant == null ? null : Long.valueOf(((Number)constant).longValue()));
                }
                case LESS_THAN_EQUALS: {
                    return FilterApi.ltEq((Operators.Column)FilterApi.longColumn((String)columnName), (Comparable)Long.valueOf(((Number)constant).longValue()));
                }
            }
            throw new RuntimeException("Unknown PredicateLeaf Operator type: " + op);
        }
    }

    class FloatFilterPredicateLeafBuilder
    extends FilterPredicateLeafBuilder {
        FloatFilterPredicateLeafBuilder() {
        }

        @Override
        public FilterPredicate buildPredict(PredicateLeaf.Operator op, Object constant, String columnName, TypeInfo columnType) {
            switch (op) {
                case LESS_THAN: {
                    return FilterApi.lt((Operators.Column)FilterApi.floatColumn((String)columnName), (Comparable)Float.valueOf(((Number)constant).floatValue()));
                }
                case IS_NULL: 
                case EQUALS: 
                case NULL_SAFE_EQUALS: {
                    return FilterApi.eq((Operators.Column)FilterApi.floatColumn((String)columnName), constant == null ? null : Float.valueOf(((Number)constant).floatValue()));
                }
                case LESS_THAN_EQUALS: {
                    return FilterApi.ltEq((Operators.Column)FilterApi.floatColumn((String)columnName), (Comparable)Float.valueOf(((Number)constant).floatValue()));
                }
            }
            throw new RuntimeException("Unknown PredicateLeaf Operator type: " + op);
        }
    }

    class DoubleFilterPredicateLeafBuilder
    extends FilterPredicateLeafBuilder {
        DoubleFilterPredicateLeafBuilder() {
        }

        @Override
        public FilterPredicate buildPredict(PredicateLeaf.Operator op, Object constant, String columnName, TypeInfo columnType) {
            switch (op) {
                case LESS_THAN: {
                    return FilterApi.lt((Operators.Column)FilterApi.doubleColumn((String)columnName), (Comparable)Double.valueOf(((Number)constant).doubleValue()));
                }
                case IS_NULL: 
                case EQUALS: 
                case NULL_SAFE_EQUALS: {
                    return FilterApi.eq((Operators.Column)FilterApi.doubleColumn((String)columnName), constant == null ? null : Double.valueOf(((Number)constant).doubleValue()));
                }
                case LESS_THAN_EQUALS: {
                    return FilterApi.ltEq((Operators.Column)FilterApi.doubleColumn((String)columnName), (Comparable)Double.valueOf(((Number)constant).doubleValue()));
                }
            }
            throw new RuntimeException("Unknown PredicateLeaf Operator type: " + op);
        }
    }

    class BinaryFilterPredicateLeafBuilder
    extends FilterPredicateLeafBuilder {
        BinaryFilterPredicateLeafBuilder() {
        }

        @Override
        public FilterPredicate buildPredict(PredicateLeaf.Operator op, Object constant, String columnName, TypeInfo columnType) throws Exception {
            String value = null;
            if (constant != null) {
                value = (String)constant;
                if (columnType != null && columnType.toString().startsWith("char")) {
                    value = this.removeTrailingSpaces(value);
                }
            }
            switch (op) {
                case LESS_THAN: {
                    return FilterApi.lt((Operators.Column)FilterApi.binaryColumn((String)columnName), (Comparable)Binary.fromString((String)value));
                }
                case IS_NULL: 
                case EQUALS: 
                case NULL_SAFE_EQUALS: {
                    return FilterApi.eq((Operators.Column)FilterApi.binaryColumn((String)columnName), (Comparable)(constant == null ? null : Binary.fromString((String)value)));
                }
                case LESS_THAN_EQUALS: {
                    return FilterApi.ltEq((Operators.Column)FilterApi.binaryColumn((String)columnName), (Comparable)Binary.fromString((String)value));
                }
            }
            throw new RuntimeException("Unknown PredicateLeaf Operator type: " + op);
        }

        private String removeTrailingSpaces(String value) {
            if (value == null) {
                return null;
            }
            String regex = "\\s+$";
            return value.replaceAll(regex, "");
        }
    }

    class BooleanFilterPredicateLeafBuilder
    extends FilterPredicateLeafBuilder {
        BooleanFilterPredicateLeafBuilder() {
        }

        @Override
        public FilterPredicate buildPredict(PredicateLeaf.Operator op, Object constant, String columnName, TypeInfo columnType) throws Exception {
            switch (op) {
                case IS_NULL: 
                case EQUALS: 
                case NULL_SAFE_EQUALS: {
                    return FilterApi.eq((Operators.Column)FilterApi.booleanColumn((String)columnName), constant == null ? null : Boolean.valueOf((Boolean)constant));
                }
            }
            throw new RuntimeException("Unknown PredicateLeaf Operator type: " + op);
        }
    }
}

