/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.util.Arrays;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public class IsNotNull
extends VectorExpression {
    private static final long serialVersionUID = 1L;

    public IsNotNull(int colNum, int outputColumnNum) {
        super(colNum, outputColumnNum);
    }

    public IsNotNull() {
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        ColumnVector inputColVector = batch.cols[this.inputColumnNum[0]];
        int[] sel = batch.selected;
        boolean[] inputIsNull = inputColVector.isNull;
        int n = batch.size;
        LongColumnVector outputColVector = (LongColumnVector)batch.cols[this.outputColumnNum];
        long[] outputVector = outputColVector.vector;
        boolean[] outputIsNull = outputColVector.isNull;
        if (n <= 0) {
            return;
        }
        outputColVector.isRepeating = false;
        if (inputColVector.noNulls) {
            outputColVector.isRepeating = true;
            outputIsNull[0] = false;
            outputVector[0] = 1L;
        } else if (inputColVector.isRepeating) {
            outputColVector.isRepeating = true;
            outputIsNull[0] = false;
            outputVector[0] = inputIsNull[0] ? 0L : 1L;
        } else if (batch.selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                outputIsNull[i] = false;
                outputVector[i] = inputIsNull[i] ? 0L : 1L;
            }
        } else {
            Arrays.fill(outputIsNull, 0, n, false);
            for (int i = 0; i != n; ++i) {
                outputVector[i] = inputIsNull[i] ? 0L : 1L;
            }
        }
    }

    @Override
    public String vectorExpressionParameters() {
        return this.getColumnParamString(0, this.inputColumnNum[0]);
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(1).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.ALL_FAMILY).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN).build();
    }
}

