/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.common.metrics.common.Metrics;
import org.apache.hadoop.hive.common.metrics.common.MetricsFactory;
import org.apache.hadoop.hive.common.metrics.common.MetricsVariable;
import org.apache.hadoop.hive.common.metrics.metrics2.CodahaleMetrics;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.impl.MsInfo;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableCounterInt;
import org.apache.hadoop.metrics2.lib.MutableGaugeInt;
import org.apache.hadoop.metrics2.lib.MutableMetric;

public class WmPoolMetrics
implements MetricsSource {
    private final String poolName;
    private final String sourceName;
    private MetricsSystem ms;
    private final MetricsRegistry registry;
    private List<String> codahaleGaugeNames;
    private Map<String, MutableMetric> allMetrics;
    @Metric(value={"Number of guaranteed cluster executors given to queries"})
    MutableGaugeInt numExecutors;
    @Metric(value={"Number of guaranteed cluster executors allocated"})
    MutableGaugeInt numExecutorsMax;
    @Metric(value={"Number of parallel queries allowed to run"})
    MutableGaugeInt numParallelQueries;
    @Metric(value={"Number of queries running"})
    MutableCounterInt numRunningQueries;
    @Metric(value={"Number of queries queued"})
    MutableCounterInt numQueuedQueries;

    public WmPoolMetrics(String poolName, MetricsSystem ms) {
        this.poolName = poolName;
        this.sourceName = "WmPoolMetrics." + poolName;
        this.ms = ms;
        this.registry = new MetricsRegistry(this.sourceName);
    }

    public void initAfterRegister() {
        if (this.allMetrics != null) {
            return;
        }
        this.allMetrics = new HashMap<String, MutableMetric>();
        block2: for (Field field : this.getClass().getDeclaredFields()) {
            for (Annotation annotation : field.getAnnotations()) {
                if (!(annotation instanceof Metric)) continue;
                try {
                    field.setAccessible(true);
                    this.allMetrics.put(field.getName(), (MutableMetric)field.get(this));
                }
                catch (IllegalAccessException ex) {}
                continue block2;
            }
        }
        Metrics chMetrics = MetricsFactory.getInstance();
        if (!(chMetrics instanceof CodahaleMetrics)) {
            return;
        }
        ArrayList<String> codahaleNames = new ArrayList<String>();
        for (Map.Entry<String, MutableMetric> e : this.allMetrics.entrySet()) {
            MutableMetric metric = e.getValue();
            Object var = null;
            if (metric instanceof MutableCounterInt) {
                var = new CodahaleCounterWrapper((MutableCounterInt)metric);
            } else if (metric instanceof MutableGaugeInt) {
                var = new CodahaleGaugeWrapper((MutableGaugeInt)metric);
            }
            if (var == null) continue;
            String name = "WM_" + this.poolName + "_" + e.getKey();
            codahaleNames.add(name);
            chMetrics.addGauge(name, (MetricsVariable)var);
        }
        this.codahaleGaugeNames = codahaleNames;
    }

    public void setParallelQueries(int size) {
        this.numParallelQueries.set(size);
    }

    public void setExecutors(int allocation) {
        this.numExecutors.set(allocation);
    }

    public void setMaxExecutors(int allocation) {
        this.numExecutorsMax.set(allocation);
    }

    public void addQueuedQuery() {
        this.numQueuedQueries.incr();
    }

    public void addRunningQuery() {
        this.numRunningQueries.incr();
    }

    public void removeQueuedQueries(int num) {
        this.numQueuedQueries.incr(-num);
    }

    public void removeRunningQueries(int num) {
        this.numRunningQueries.incr(-num);
    }

    public void moveQueuedToRunning() {
        this.numQueuedQueries.incr(-1);
        this.numRunningQueries.incr();
    }

    public void getMetrics(MetricsCollector collector, boolean all) {
        MetricsRecordBuilder rb = collector.addRecord("WmPoolMetrics." + this.poolName).setContext("HS2").tag((MetricsInfo)MsInfo.SessionId, this.poolName);
        if (this.allMetrics == null) {
            this.initAfterRegister();
        }
        for (MutableMetric metric : this.allMetrics.values()) {
            metric.snapshot(rb, all);
        }
    }

    public static WmPoolMetrics create(String poolName, MetricsSystem ms) {
        WmPoolMetrics metrics = new WmPoolMetrics(poolName, ms);
        metrics = (WmPoolMetrics)ms.register(metrics.sourceName, "WM " + poolName + " pool metrics", (Object)metrics);
        metrics.initAfterRegister();
        return metrics;
    }

    public void destroy() {
        this.ms.unregisterSource(this.sourceName);
        this.ms = null;
        if (this.codahaleGaugeNames != null) {
            Metrics metrics = MetricsFactory.getInstance();
            for (String chgName : this.codahaleGaugeNames) {
                metrics.removeGauge(chgName);
            }
            this.codahaleGaugeNames = null;
        }
    }

    private static class CodahaleCounterWrapper
    implements MetricsVariable<Integer> {
        private final MutableCounterInt mm;

        public CodahaleCounterWrapper(MutableCounterInt mm) {
            this.mm = mm;
        }

        public Integer getValue() {
            return this.mm.value();
        }
    }

    private static class CodahaleGaugeWrapper
    implements MetricsVariable<Integer> {
        private final MutableGaugeInt mm;

        public CodahaleGaugeWrapper(MutableGaugeInt mm) {
            this.mm = mm;
        }

        public Integer getValue() {
            return this.mm.value();
        }
    }
}

