/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.partition.set;

import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLSemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.table.AbstractAlterTableAnalyzer;
import org.apache.hadoop.hive.ql.ddl.table.AlterTableType;
import org.apache.hadoop.hive.ql.ddl.table.partition.set.AlterTableSetPartitionSpecDesc;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.PartitionTransform;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.TransformSpec;
import org.apache.hadoop.hive.ql.session.SessionStateUtil;

@DDLSemanticAnalyzerFactory.DDLType(types={889})
public class AlterTableSetPartitionSpecAnalyzer
extends AbstractAlterTableAnalyzer {
    public AlterTableSetPartitionSpecAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    protected void analyzeCommand(TableName tableName, Map<String, String> partitionSpec, ASTNode command) throws SemanticException {
        Table table = this.getTable(tableName);
        this.validateAlterTableType(table, AlterTableType.SETPARTITIONSPEC, false);
        this.inputs.add(new ReadEntity(table));
        List<TransformSpec> partitionTransformSpec = PartitionTransform.getPartitionTransformSpec(command);
        SessionStateUtil.addResourceOrThrow((Configuration)this.conf, "partition_transform_spec", partitionTransformSpec);
        AlterTableSetPartitionSpecDesc desc = new AlterTableSetPartitionSpecDesc(tableName, partitionSpec);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), desc)));
    }
}

