/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.lock.show;

import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLSemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.table.lock.show.ShowLocksDesc;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;

@DDLSemanticAnalyzerFactory.DDLType(types={1206})
public class ShowDbLocksAnalyzer
extends BaseSemanticAnalyzer {
    public ShowDbLocksAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    public void analyzeInternal(ASTNode root) throws SemanticException {
        boolean isExtended;
        this.ctx.setResFile(this.ctx.getLocalTmpPath());
        String dbName = ShowDbLocksAnalyzer.stripQuotes(root.getChild(0).getText());
        boolean bl = isExtended = root.getChildCount() > 1;
        assert (this.txnManager != null) : "Transaction manager should be set before calling analyze";
        ShowLocksDesc desc = new ShowLocksDesc(this.ctx.getResFile(), dbName, isExtended, this.txnManager.useNewShowLocksFormat());
        Task<DDLWork> task = TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), desc));
        this.rootTasks.add(task);
        task.setFetchSource(true);
        this.setFetchTask(this.createFetchTask(desc.getSchema()));
        this.ctx.setNeedLockMgr(true);
    }
}

