/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.cache;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.datanucleus.cache.CacheUniqueKey;
import org.datanucleus.cache.Level1Cache;
import org.datanucleus.state.DNStateManager;
import org.datanucleus.util.ConcurrentReferenceHashMap;

public class WeakRefCache
implements Level1Cache {
    public static final String NAME = "weak";
    private Map<Object, DNStateManager> weakCache = new ConcurrentReferenceHashMap<Object, DNStateManager>(1, ConcurrentReferenceHashMap.ReferenceType.STRONG, ConcurrentReferenceHashMap.ReferenceType.WEAK);
    private Map<CacheUniqueKey, DNStateManager> weakCacheUnique = new ConcurrentReferenceHashMap<CacheUniqueKey, DNStateManager>(1, ConcurrentReferenceHashMap.ReferenceType.STRONG, ConcurrentReferenceHashMap.ReferenceType.WEAK);

    @Override
    public DNStateManager put(Object id, DNStateManager sm) {
        return this.weakCache.put(id, sm);
    }

    @Override
    public DNStateManager get(Object id) {
        return this.weakCache.get(id);
    }

    @Override
    public boolean containsKey(Object id) {
        return this.weakCache.containsKey(id);
    }

    @Override
    public DNStateManager remove(Object id) {
        DNStateManager sm = this.weakCache.remove(id);
        if (this.weakCacheUnique.containsValue(sm)) {
            Iterator<Map.Entry<CacheUniqueKey, DNStateManager>> entrySetIter = this.weakCacheUnique.entrySet().iterator();
            while (entrySetIter.hasNext()) {
                Map.Entry<CacheUniqueKey, DNStateManager> entry = entrySetIter.next();
                if (entry.getValue() != sm) continue;
                entrySetIter.remove();
            }
        }
        return sm;
    }

    @Override
    public void clear() {
        this.weakCache.clear();
    }

    @Override
    public boolean containsValue(Object value) {
        return this.weakCache.containsValue(value);
    }

    @Override
    public Set entrySet() {
        return this.weakCache.entrySet();
    }

    @Override
    public boolean isEmpty() {
        return this.weakCache.isEmpty();
    }

    @Override
    public Set keySet() {
        return this.weakCache.keySet();
    }

    @Override
    public void putAll(Map t) {
        this.weakCache.putAll(t);
    }

    @Override
    public int size() {
        return this.weakCache.size();
    }

    @Override
    public Collection values() {
        return this.weakCache.values();
    }

    @Override
    public DNStateManager getUnique(CacheUniqueKey key) {
        return this.weakCacheUnique.get(key);
    }

    @Override
    public Object putUnique(CacheUniqueKey key, DNStateManager sm) {
        return this.weakCacheUnique.put(key, sm);
    }
}

