/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.security;

import com.google.common.base.Preconditions;
import io.jsonwebtoken.security.Keys;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.security.JwtSecretProvider;

public class DefaultJwtSharedSecretProvider
implements JwtSecretProvider {
    public static final String LLAP_EXTERNAL_CLIENT_CLOUD_JWT_SHARED_SECRET_ENV_VAR = "LLAP_EXTERNAL_CLIENT_CLOUD_JWT_SHARED_SECRET_ENV_VAR";
    private Key jwtEncryptionKey;

    @Override
    public Key getEncryptionSecret() {
        return this.jwtEncryptionKey;
    }

    @Override
    public Key getDecryptionSecret() {
        return this.jwtEncryptionKey;
    }

    @Override
    public void init(Configuration conf) {
        char[] sharedSecret;
        byte[] sharedSecretBytes = null;
        try {
            sharedSecret = conf.getPassword(HiveConf.ConfVars.LLAP_EXTERNAL_CLIENT_CLOUD_JWT_SHARED_SECRET.varname);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to get password [hive.llap.external.client.cloud.jwt.shared.secret] - " + e.getMessage(), e);
        }
        if (sharedSecret != null) {
            ByteBuffer bb = StandardCharsets.UTF_8.encode(CharBuffer.wrap(sharedSecret));
            sharedSecretBytes = new byte[bb.remaining()];
            bb.get(sharedSecretBytes);
        } else {
            String sharedSecredFromEnv = System.getenv(LLAP_EXTERNAL_CLIENT_CLOUD_JWT_SHARED_SECRET_ENV_VAR);
            if (StringUtils.isNotBlank((CharSequence)sharedSecredFromEnv)) {
                sharedSecretBytes = sharedSecredFromEnv.getBytes();
            }
        }
        Preconditions.checkState((sharedSecretBytes != null ? 1 : 0) != 0, (Object)("With: " + HiveConf.ConfVars.LLAP_EXTERNAL_CLIENT_CLOUD_DEPLOYMENT_SETUP_ENABLED.varname + " = true, \nTo use: org.apache.hadoop.hive.llap.security.DefaultJwtSharedSecretProvider, \n1. a non-null value of 'hive.llap.external.client.cloud.jwt.shared.secret' must be provided OR \n2. alternatively environment variable LLAP_EXTERNAL_CLIENT_CLOUD_JWT_SHARED_SECRET_ENV_VAR can also be set. \nLength of the secret provided in 1) or 2) should be > 32 bytes."));
        this.jwtEncryptionKey = Keys.hmacShaKeyFor((byte[])sharedSecretBytes);
    }
}

