/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.templeton;

import java.io.ByteArrayOutputStream;

public class MaxByteArrayOutputStream
extends ByteArrayOutputStream {
    private int maxBytes;
    private int nBytes;

    public MaxByteArrayOutputStream(int maxBytes) {
        this.maxBytes = maxBytes;
        this.nBytes = 0;
    }

    @Override
    public synchronized void write(int b) {
        if (this.nBytes < this.maxBytes) {
            ++this.nBytes;
            super.write(b);
        }
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) {
        int storable = Math.min(this.maxBytes - this.nBytes, len);
        if (storable > 0) {
            this.nBytes += storable;
            super.write(b, off, storable);
        }
    }
}

