/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mapping;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.iceberg.mapping.MappedField;
import org.apache.iceberg.relocated.com.google.common.base.Joiner;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;

public class MappedFields
implements Serializable {
    private final List<MappedField> fields;
    private transient Map<String, Integer> nameToId;
    private transient Map<Integer, MappedField> idToField;

    public static MappedFields of(MappedField ... fields) {
        return new MappedFields(ImmutableList.copyOf(fields));
    }

    public static MappedFields of(List<MappedField> fields) {
        return new MappedFields(fields);
    }

    private MappedFields(List<MappedField> fields) {
        this.fields = ImmutableList.copyOf(fields);
        this.lazyNameToId();
        this.lazyIdToField();
    }

    public MappedField field(int id) {
        return this.lazyIdToField().get(id);
    }

    public Integer id(String name) {
        return this.lazyNameToId().get(name);
    }

    public int size() {
        return this.fields.size();
    }

    private static Map<String, Integer> indexIds(List<MappedField> fields) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        fields.forEach(field -> field.names().forEach(name -> {
            Integer id = field.id();
            if (id != null) {
                builder.put(name, id);
            }
        }));
        return builder.build();
    }

    private static Map<Integer, MappedField> indexFields(List<MappedField> fields) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        fields.forEach(field -> {
            Integer id = field.id();
            if (id != null) {
                builder.put(id, field);
            }
        });
        return builder.build();
    }

    public List<MappedField> fields() {
        return this.fields;
    }

    private Map<String, Integer> lazyNameToId() {
        if (this.nameToId == null) {
            this.nameToId = MappedFields.indexIds(this.fields);
        }
        return this.nameToId;
    }

    private Map<Integer, MappedField> lazyIdToField() {
        if (this.idToField == null) {
            this.idToField = MappedFields.indexFields(this.fields);
        }
        return this.idToField;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MappedFields)) {
            return false;
        }
        return this.fields.equals(((MappedFields)other).fields);
    }

    public int hashCode() {
        return Objects.hashCode(this.fields);
    }

    public String toString() {
        return "[ " + Joiner.on(", ").join(this.fields) + " ]";
    }
}

