/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest;

import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import javax.servlet.http.HttpServlet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.ServletSecurity;
import org.apache.hadoop.hive.metastore.ServletServerBuilder;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.iceberg.catalog.Catalog;
import org.apache.iceberg.hive.HiveCatalog;
import org.apache.iceberg.rest.HMSCachingCatalog;
import org.apache.iceberg.rest.HMSCatalogAdapter;
import org.apache.iceberg.rest.HMSCatalogServlet;

public class HMSCatalogFactory {
    private static final String SERVLET_ID_KEY = "metastore.in.test.iceberg.catalog.servlet.id";
    private final Configuration configuration;
    private final int port;
    private final String path;

    private HMSCatalogFactory(Configuration conf) {
        this.port = MetastoreConf.getIntVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CATALOG_SERVLET_PORT);
        this.path = MetastoreConf.getVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.ICEBERG_CATALOG_SERVLET_PATH);
        this.configuration = conf;
    }

    public int getPort() {
        return this.port;
    }

    public String getPath() {
        return this.path;
    }

    private Catalog createCatalog() {
        String configExtWarehouse;
        String configWarehouse;
        TreeMap<String, String> properties = new TreeMap<String, String>();
        MetastoreConf.setVar((Configuration)this.configuration, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.THRIFT_URIS, (String)"");
        String configUri = MetastoreConf.getVar((Configuration)this.configuration, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.THRIFT_URIS);
        if (configUri != null) {
            properties.put("uri", configUri);
        }
        if ((configWarehouse = MetastoreConf.getVar((Configuration)this.configuration, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.WAREHOUSE)) != null) {
            properties.put("warehouse", configWarehouse);
        }
        if ((configExtWarehouse = MetastoreConf.getVar((Configuration)this.configuration, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.WAREHOUSE_EXTERNAL)) != null) {
            properties.put("external-warehouse", configExtWarehouse);
        }
        if (this.configuration.get(SERVLET_ID_KEY) != null) {
            properties.put("client-pool-cache-keys", String.format("conf:%s", SERVLET_ID_KEY));
        }
        HiveCatalog hiveCatalog = new HiveCatalog();
        hiveCatalog.setConf(this.configuration);
        String catalogName = MetastoreConf.getVar((Configuration)this.configuration, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CATALOG_DEFAULT);
        hiveCatalog.initialize(catalogName, properties);
        long expiry = MetastoreConf.getLongVar((Configuration)this.configuration, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.ICEBERG_CATALOG_CACHE_EXPIRY);
        return expiry > 0L ? new HMSCachingCatalog(hiveCatalog, expiry) : hiveCatalog;
    }

    private HttpServlet createServlet(Catalog catalog) {
        String authType = MetastoreConf.getVar((Configuration)this.configuration, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CATALOG_SERVLET_AUTH);
        List<String> scopes = Collections.singletonList("catalog");
        ServletSecurity security = new ServletSecurity(ServletSecurity.AuthType.fromString((String)authType), this.configuration, req -> scopes);
        return security.proxy((HttpServlet)new HMSCatalogServlet(new HMSCatalogAdapter(catalog)));
    }

    private HttpServlet createServlet() {
        if (this.port >= 0 && this.path != null && !this.path.isEmpty()) {
            return this.createServlet(this.createCatalog());
        }
        return null;
    }

    public static ServletServerBuilder.Descriptor createServlet(Configuration configuration) {
        HMSCatalogFactory hms = new HMSCatalogFactory(configuration);
        HttpServlet servlet = hms.createServlet();
        if (servlet != null) {
            return new ServletServerBuilder.Descriptor(hms.getPort(), hms.getPath(), servlet);
        }
        return null;
    }
}

