/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.iceberg.BaseTable;
import org.apache.iceberg.BaseTransaction;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.Transaction;
import org.apache.iceberg.Transactions;
import org.apache.iceberg.catalog.Catalog;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.SupportsNamespaces;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.catalog.ViewCatalog;
import org.apache.iceberg.exceptions.AlreadyExistsException;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.exceptions.CommitStateUnknownException;
import org.apache.iceberg.exceptions.ForbiddenException;
import org.apache.iceberg.exceptions.NamespaceNotEmptyException;
import org.apache.iceberg.exceptions.NoSuchIcebergTableException;
import org.apache.iceberg.exceptions.NoSuchIcebergViewException;
import org.apache.iceberg.exceptions.NoSuchNamespaceException;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.iceberg.exceptions.NoSuchViewException;
import org.apache.iceberg.exceptions.NotAuthorizedException;
import org.apache.iceberg.exceptions.RESTException;
import org.apache.iceberg.exceptions.UnprocessableEntityException;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.relocated.com.google.common.base.Splitter;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.rest.CatalogHandlers;
import org.apache.iceberg.rest.Endpoint;
import org.apache.iceberg.rest.HTTPRequest;
import org.apache.iceberg.rest.RESTClient;
import org.apache.iceberg.rest.RESTRequest;
import org.apache.iceberg.rest.RESTResponse;
import org.apache.iceberg.rest.RESTUtil;
import org.apache.iceberg.rest.requests.CommitTransactionRequest;
import org.apache.iceberg.rest.requests.CreateNamespaceRequest;
import org.apache.iceberg.rest.requests.CreateTableRequest;
import org.apache.iceberg.rest.requests.CreateViewRequest;
import org.apache.iceberg.rest.requests.RegisterTableRequest;
import org.apache.iceberg.rest.requests.RenameTableRequest;
import org.apache.iceberg.rest.requests.ReportMetricsRequest;
import org.apache.iceberg.rest.requests.UpdateNamespacePropertiesRequest;
import org.apache.iceberg.rest.requests.UpdateTableRequest;
import org.apache.iceberg.rest.responses.ConfigResponse;
import org.apache.iceberg.rest.responses.CreateNamespaceResponse;
import org.apache.iceberg.rest.responses.ErrorResponse;
import org.apache.iceberg.rest.responses.GetNamespaceResponse;
import org.apache.iceberg.rest.responses.ListNamespacesResponse;
import org.apache.iceberg.rest.responses.ListTablesResponse;
import org.apache.iceberg.rest.responses.LoadTableResponse;
import org.apache.iceberg.rest.responses.LoadViewResponse;
import org.apache.iceberg.rest.responses.UpdateNamespacePropertiesResponse;
import org.apache.iceberg.util.Pair;
import org.apache.iceberg.util.PropertyUtil;

public class HMSCatalogAdapter
implements RESTClient {
    private static final Splitter SLASH = Splitter.on((char)'/');
    private static final Map<Class<? extends Exception>, Integer> EXCEPTION_ERROR_CODES = ImmutableMap.builder().put(IllegalArgumentException.class, (Object)400).put(ValidationException.class, (Object)400).put(NamespaceNotEmptyException.class, (Object)409).put(NotAuthorizedException.class, (Object)401).put(ForbiddenException.class, (Object)403).put(NoSuchNamespaceException.class, (Object)404).put(NoSuchTableException.class, (Object)404).put(NoSuchViewException.class, (Object)404).put(NoSuchIcebergTableException.class, (Object)404).put(NoSuchIcebergViewException.class, (Object)404).put(UnsupportedOperationException.class, (Object)406).put(AlreadyExistsException.class, (Object)409).put(CommitFailedException.class, (Object)409).put(UnprocessableEntityException.class, (Object)422).put(CommitStateUnknownException.class, (Object)500).buildOrThrow();
    private final Catalog catalog;
    private final SupportsNamespaces asNamespaceCatalog;
    private final ViewCatalog asViewCatalog;

    public HMSCatalogAdapter(Catalog catalog) {
        Preconditions.checkArgument((boolean)(catalog instanceof SupportsNamespaces));
        Preconditions.checkArgument((boolean)(catalog instanceof ViewCatalog));
        this.catalog = catalog;
        this.asNamespaceCatalog = (SupportsNamespaces)catalog;
        this.asViewCatalog = (ViewCatalog)catalog;
    }

    private ConfigResponse config() {
        List<Endpoint> endpoints = Arrays.stream(Route.values()).map(r -> Endpoint.create((String)r.method.name(), (String)r.resourcePath)).toList();
        return HMSCatalogAdapter.castResponse(ConfigResponse.class, ConfigResponse.builder().withEndpoints(endpoints).build());
    }

    private ListNamespacesResponse listNamespaces(Map<String, String> vars) {
        Namespace namespace = vars.containsKey("parent") ? Namespace.of((String[])((String[])RESTUtil.NAMESPACE_SPLITTER.splitToStream((CharSequence)vars.get("parent")).toArray(String[]::new))) : Namespace.empty();
        return HMSCatalogAdapter.castResponse(ListNamespacesResponse.class, CatalogHandlers.listNamespaces((SupportsNamespaces)this.asNamespaceCatalog, (Namespace)namespace));
    }

    private CreateNamespaceResponse createNamespace(Object body) {
        CreateNamespaceRequest request = HMSCatalogAdapter.castRequest(CreateNamespaceRequest.class, body);
        return HMSCatalogAdapter.castResponse(CreateNamespaceResponse.class, CatalogHandlers.createNamespace((SupportsNamespaces)this.asNamespaceCatalog, (CreateNamespaceRequest)request));
    }

    private RESTResponse namespaceExists(Map<String, String> vars) {
        Namespace namespace = HMSCatalogAdapter.namespaceFromPathVars(vars);
        CatalogHandlers.namespaceExists((SupportsNamespaces)this.asNamespaceCatalog, (Namespace)namespace);
        return null;
    }

    private GetNamespaceResponse loadNamespace(Map<String, String> vars) {
        Namespace namespace = HMSCatalogAdapter.namespaceFromPathVars(vars);
        return HMSCatalogAdapter.castResponse(GetNamespaceResponse.class, CatalogHandlers.loadNamespace((SupportsNamespaces)this.asNamespaceCatalog, (Namespace)namespace));
    }

    private RESTResponse dropNamespace(Map<String, String> vars) {
        CatalogHandlers.dropNamespace((SupportsNamespaces)this.asNamespaceCatalog, (Namespace)HMSCatalogAdapter.namespaceFromPathVars(vars));
        return null;
    }

    private UpdateNamespacePropertiesResponse updateNamespace(Map<String, String> vars, Object body) {
        Namespace namespace = HMSCatalogAdapter.namespaceFromPathVars(vars);
        UpdateNamespacePropertiesRequest request = HMSCatalogAdapter.castRequest(UpdateNamespacePropertiesRequest.class, body);
        return HMSCatalogAdapter.castResponse(UpdateNamespacePropertiesResponse.class, CatalogHandlers.updateNamespaceProperties((SupportsNamespaces)this.asNamespaceCatalog, (Namespace)namespace, (UpdateNamespacePropertiesRequest)request));
    }

    private ListTablesResponse listTables(Map<String, String> vars) {
        Namespace namespace = HMSCatalogAdapter.namespaceFromPathVars(vars);
        return HMSCatalogAdapter.castResponse(ListTablesResponse.class, CatalogHandlers.listTables((Catalog)this.catalog, (Namespace)namespace));
    }

    private LoadTableResponse createTable(Map<String, String> vars, Object body) {
        Class<LoadTableResponse> responseType = LoadTableResponse.class;
        Namespace namespace = HMSCatalogAdapter.namespaceFromPathVars(vars);
        CreateTableRequest request = HMSCatalogAdapter.castRequest(CreateTableRequest.class, body);
        request.validate();
        if (request.stageCreate()) {
            return HMSCatalogAdapter.castResponse(responseType, CatalogHandlers.stageTableCreate((Catalog)this.catalog, (Namespace)namespace, (CreateTableRequest)request));
        }
        return HMSCatalogAdapter.castResponse(responseType, CatalogHandlers.createTable((Catalog)this.catalog, (Namespace)namespace, (CreateTableRequest)request));
    }

    private RESTResponse dropTable(Map<String, String> vars) {
        if (PropertyUtil.propertyAsBoolean(vars, (String)"purgeRequested", (boolean)false)) {
            CatalogHandlers.purgeTable((Catalog)this.catalog, (TableIdentifier)HMSCatalogAdapter.identFromPathVars(vars));
        } else {
            CatalogHandlers.dropTable((Catalog)this.catalog, (TableIdentifier)HMSCatalogAdapter.identFromPathVars(vars));
        }
        return null;
    }

    private RESTResponse tableExists(Map<String, String> vars) {
        TableIdentifier ident = HMSCatalogAdapter.identFromPathVars(vars);
        CatalogHandlers.tableExists((Catalog)this.catalog, (TableIdentifier)ident);
        return null;
    }

    private LoadTableResponse loadTable(Map<String, String> vars) {
        TableIdentifier ident = HMSCatalogAdapter.identFromPathVars(vars);
        return HMSCatalogAdapter.castResponse(LoadTableResponse.class, CatalogHandlers.loadTable((Catalog)this.catalog, (TableIdentifier)ident));
    }

    private LoadTableResponse registerTable(Map<String, String> vars, Object body) {
        Namespace namespace = HMSCatalogAdapter.namespaceFromPathVars(vars);
        RegisterTableRequest request = HMSCatalogAdapter.castRequest(RegisterTableRequest.class, body);
        return HMSCatalogAdapter.castResponse(LoadTableResponse.class, CatalogHandlers.registerTable((Catalog)this.catalog, (Namespace)namespace, (RegisterTableRequest)request));
    }

    private LoadTableResponse updateTable(Map<String, String> vars, Object body) {
        TableIdentifier ident = HMSCatalogAdapter.identFromPathVars(vars);
        UpdateTableRequest request = HMSCatalogAdapter.castRequest(UpdateTableRequest.class, body);
        return HMSCatalogAdapter.castResponse(LoadTableResponse.class, CatalogHandlers.updateTable((Catalog)this.catalog, (TableIdentifier)ident, (UpdateTableRequest)request));
    }

    private RESTResponse renameTable(Object body) {
        RenameTableRequest request = HMSCatalogAdapter.castRequest(RenameTableRequest.class, body);
        CatalogHandlers.renameTable((Catalog)this.catalog, (RenameTableRequest)request);
        return null;
    }

    private RESTResponse reportMetrics(Object body) {
        HMSCatalogAdapter.castRequest(ReportMetricsRequest.class, body);
        return null;
    }

    private RESTResponse commitTransaction(Object body) {
        CommitTransactionRequest request = HMSCatalogAdapter.castRequest(CommitTransactionRequest.class, body);
        HMSCatalogAdapter.commitTransaction(this.catalog, request);
        return null;
    }

    private ListTablesResponse listViews(Map<String, String> vars) {
        Namespace namespace = HMSCatalogAdapter.namespaceFromPathVars(vars);
        String pageToken = PropertyUtil.propertyAsString(vars, (String)"pageToken", null);
        String pageSize = PropertyUtil.propertyAsString(vars, (String)"pageSize", null);
        if (pageSize != null) {
            return HMSCatalogAdapter.castResponse(ListTablesResponse.class, CatalogHandlers.listViews((ViewCatalog)this.asViewCatalog, (Namespace)namespace, (String)pageToken, (String)pageSize));
        }
        return HMSCatalogAdapter.castResponse(ListTablesResponse.class, CatalogHandlers.listViews((ViewCatalog)this.asViewCatalog, (Namespace)namespace));
    }

    private LoadViewResponse createView(Map<String, String> vars, Object body) {
        Namespace namespace = HMSCatalogAdapter.namespaceFromPathVars(vars);
        CreateViewRequest request = HMSCatalogAdapter.castRequest(CreateViewRequest.class, body);
        return HMSCatalogAdapter.castResponse(LoadViewResponse.class, CatalogHandlers.createView((ViewCatalog)this.asViewCatalog, (Namespace)namespace, (CreateViewRequest)request));
    }

    private RESTResponse viewExists(Map<String, String> vars) {
        TableIdentifier ident = HMSCatalogAdapter.viewIdentFromPathVars(vars);
        CatalogHandlers.viewExists((ViewCatalog)this.asViewCatalog, (TableIdentifier)ident);
        return null;
    }

    private LoadViewResponse loadView(Map<String, String> vars) {
        TableIdentifier ident = HMSCatalogAdapter.viewIdentFromPathVars(vars);
        return HMSCatalogAdapter.castResponse(LoadViewResponse.class, CatalogHandlers.loadView((ViewCatalog)this.asViewCatalog, (TableIdentifier)ident));
    }

    private LoadViewResponse updateView(Map<String, String> vars, Object body) {
        TableIdentifier ident = HMSCatalogAdapter.viewIdentFromPathVars(vars);
        UpdateTableRequest request = HMSCatalogAdapter.castRequest(UpdateTableRequest.class, body);
        return HMSCatalogAdapter.castResponse(LoadViewResponse.class, CatalogHandlers.updateView((ViewCatalog)this.asViewCatalog, (TableIdentifier)ident, (UpdateTableRequest)request));
    }

    private RESTResponse renameView(Object body) {
        RenameTableRequest request = HMSCatalogAdapter.castRequest(RenameTableRequest.class, body);
        CatalogHandlers.renameView((ViewCatalog)this.asViewCatalog, (RenameTableRequest)request);
        return null;
    }

    private RESTResponse dropView(Map<String, String> vars) {
        CatalogHandlers.dropView((ViewCatalog)this.asViewCatalog, (TableIdentifier)HMSCatalogAdapter.viewIdentFromPathVars(vars));
        return null;
    }

    private static void commitTransaction(Catalog catalog, CommitTransactionRequest request) {
        ArrayList transactions = Lists.newArrayList();
        for (UpdateTableRequest tableChange : request.tableChanges()) {
            Table table = catalog.loadTable(tableChange.identifier());
            if (table instanceof BaseTable) {
                Transaction transaction = Transactions.newTransaction((String)tableChange.identifier().toString(), (TableOperations)((BaseTable)table).operations());
                transactions.add(transaction);
                BaseTransaction.TransactionTable txTable = (BaseTransaction.TransactionTable)transaction.table();
                CatalogHandlers.commit((TableOperations)txTable.operations(), (UpdateTableRequest)tableChange);
                continue;
            }
            throw new IllegalStateException("Cannot wrap catalog that does not produce BaseTable");
        }
        transactions.forEach(Transaction::commitTransaction);
    }

    private <T extends RESTResponse> T handleRequest(Route route, Map<String, String> vars, Object body) {
        switch (route.ordinal()) {
            case 0: {
                return (T)this.config();
            }
            case 1: {
                return (T)this.listNamespaces(vars);
            }
            case 2: {
                return (T)this.createNamespace(body);
            }
            case 3: {
                return (T)this.namespaceExists(vars);
            }
            case 4: {
                return (T)this.loadNamespace(vars);
            }
            case 5: {
                return (T)this.dropNamespace(vars);
            }
            case 6: {
                return (T)this.updateNamespace(vars, body);
            }
            case 7: {
                return (T)this.listTables(vars);
            }
            case 8: {
                return (T)this.createTable(vars, body);
            }
            case 13: {
                return (T)this.dropTable(vars);
            }
            case 9: {
                return (T)this.tableExists(vars);
            }
            case 10: {
                return (T)this.loadTable(vars);
            }
            case 11: {
                return (T)this.registerTable(vars, body);
            }
            case 12: {
                return (T)this.updateTable(vars, body);
            }
            case 14: {
                return (T)this.renameTable(body);
            }
            case 15: {
                return (T)this.reportMetrics(body);
            }
            case 16: {
                return (T)this.commitTransaction(body);
            }
            case 17: {
                return (T)this.listViews(vars);
            }
            case 20: {
                return (T)this.createView(vars, body);
            }
            case 18: {
                return (T)this.viewExists(vars);
            }
            case 19: {
                return (T)this.loadView(vars);
            }
            case 21: {
                return (T)this.updateView(vars, body);
            }
            case 22: {
                return (T)this.renameView(body);
            }
            case 23: {
                return (T)this.dropView(vars);
            }
        }
        return null;
    }

    <T extends RESTResponse> T execute(HTTPRequest.HTTPMethod method, String path, Map<String, String> queryParams, Object body, Consumer<ErrorResponse> errorHandler) {
        ErrorResponse.Builder errorBuilder = ErrorResponse.builder();
        Pair<Route, Map<String, String>> routeAndVars = Route.from(method, path);
        if (routeAndVars != null) {
            try {
                ImmutableMap.Builder vars = ImmutableMap.builder();
                if (queryParams != null) {
                    vars.putAll(queryParams);
                }
                vars.putAll((Map)routeAndVars.second());
                return this.handleRequest((Route)((Object)routeAndVars.first()), (Map<String, String>)vars.build(), body);
            }
            catch (RuntimeException e) {
                HMSCatalogAdapter.configureResponseFromException(e, errorBuilder);
            }
        } else {
            errorBuilder.responseCode(Integer.valueOf(400)).withType("BadRequestException").withMessage(String.format("No route for request: %s %s", method, path));
        }
        ErrorResponse error = errorBuilder.build();
        errorHandler.accept(error);
        throw new RESTException("Unhandled error: %s", new Object[]{error});
    }

    public <T extends RESTResponse> T delete(String path, Class<T> responseType, Map<String, String> headers, Consumer<ErrorResponse> errorHandler) {
        return this.execute(HTTPRequest.HTTPMethod.DELETE, path, null, null, errorHandler);
    }

    public <T extends RESTResponse> T delete(String path, Map<String, String> queryParams, Class<T> responseType, Map<String, String> headers, Consumer<ErrorResponse> errorHandler) {
        return this.execute(HTTPRequest.HTTPMethod.DELETE, path, queryParams, null, errorHandler);
    }

    public <T extends RESTResponse> T post(String path, RESTRequest body, Class<T> responseType, Map<String, String> headers, Consumer<ErrorResponse> errorHandler) {
        return this.execute(HTTPRequest.HTTPMethod.POST, path, null, body, errorHandler);
    }

    public <T extends RESTResponse> T get(String path, Map<String, String> queryParams, Class<T> responseType, Map<String, String> headers, Consumer<ErrorResponse> errorHandler) {
        return this.execute(HTTPRequest.HTTPMethod.GET, path, queryParams, null, errorHandler);
    }

    public void head(String path, Map<String, String> headers, Consumer<ErrorResponse> errorHandler) {
        this.execute(HTTPRequest.HTTPMethod.HEAD, path, null, headers, errorHandler);
    }

    public <T extends RESTResponse> T postForm(String path, Map<String, String> formData, Class<T> responseType, Map<String, String> headers, Consumer<ErrorResponse> errorHandler) {
        return this.execute(HTTPRequest.HTTPMethod.POST, path, null, formData, errorHandler);
    }

    public void close() {
    }

    public static <T> T castRequest(Class<T> requestType, Object request) {
        if (requestType.isInstance(request)) {
            return requestType.cast(request);
        }
        throw new BadRequestType(requestType, request);
    }

    public static <T extends RESTResponse> T castResponse(Class<T> responseType, Object response) {
        if (responseType.isInstance(response)) {
            return (T)((RESTResponse)responseType.cast(response));
        }
        throw new BadResponseType(responseType, response);
    }

    public static void configureResponseFromException(Exception exc, ErrorResponse.Builder errorBuilder) {
        errorBuilder.responseCode(EXCEPTION_ERROR_CODES.getOrDefault(exc.getClass(), 500)).withType(exc.getClass().getSimpleName()).withMessage(exc.getMessage()).withStackTrace((Throwable)exc);
    }

    private static Namespace namespaceFromPathVars(Map<String, String> pathVars) {
        return RESTUtil.decodeNamespace((String)pathVars.get("namespace"));
    }

    private static TableIdentifier identFromPathVars(Map<String, String> pathVars) {
        return TableIdentifier.of((Namespace)HMSCatalogAdapter.namespaceFromPathVars(pathVars), (String)RESTUtil.decodeString((String)pathVars.get("table")));
    }

    private static TableIdentifier viewIdentFromPathVars(Map<String, String> pathVars) {
        return TableIdentifier.of((Namespace)HMSCatalogAdapter.namespaceFromPathVars(pathVars), (String)RESTUtil.decodeString((String)pathVars.get("view")));
    }

    static enum Route {
        CONFIG(HTTPRequest.HTTPMethod.GET, "v1/config", null),
        LIST_NAMESPACES(HTTPRequest.HTTPMethod.GET, "/v1/{prefix}/namespaces", null),
        CREATE_NAMESPACE(HTTPRequest.HTTPMethod.POST, "/v1/{prefix}/namespaces", CreateNamespaceRequest.class),
        NAMESPACE_EXISTS(HTTPRequest.HTTPMethod.HEAD, "/v1/{prefix}/namespaces/{namespace}"),
        LOAD_NAMESPACE(HTTPRequest.HTTPMethod.GET, "/v1/{prefix}/namespaces/{namespace}", null),
        DROP_NAMESPACE(HTTPRequest.HTTPMethod.DELETE, "/v1/{prefix}/namespaces/{namespace}"),
        UPDATE_NAMESPACE(HTTPRequest.HTTPMethod.POST, "/v1/{prefix}/namespaces/{namespace}/properties", UpdateNamespacePropertiesRequest.class),
        LIST_TABLES(HTTPRequest.HTTPMethod.GET, "/v1/{prefix}/namespaces/{namespace}/tables", null),
        CREATE_TABLE(HTTPRequest.HTTPMethod.POST, "/v1/{prefix}/namespaces/{namespace}/tables", CreateTableRequest.class),
        TABLE_EXISTS(HTTPRequest.HTTPMethod.HEAD, "/v1/{prefix}/namespaces/{namespace}/tables/{table}"),
        LOAD_TABLE(HTTPRequest.HTTPMethod.GET, "/v1/{prefix}/namespaces/{namespace}/tables/{table}", null),
        REGISTER_TABLE(HTTPRequest.HTTPMethod.POST, "/v1/{prefix}/namespaces/{namespace}/register", RegisterTableRequest.class),
        UPDATE_TABLE(HTTPRequest.HTTPMethod.POST, "/v1/{prefix}/namespaces/{namespace}/tables/{table}", UpdateTableRequest.class),
        DROP_TABLE(HTTPRequest.HTTPMethod.DELETE, "/v1/{prefix}/namespaces/{namespace}/tables/{table}"),
        RENAME_TABLE(HTTPRequest.HTTPMethod.POST, "/v1/{prefix}/tables/rename", RenameTableRequest.class),
        REPORT_METRICS(HTTPRequest.HTTPMethod.POST, "/v1/{prefix}/namespaces/{namespace}/tables/{table}/metrics", ReportMetricsRequest.class),
        COMMIT_TRANSACTION(HTTPRequest.HTTPMethod.POST, "/v1/{prefix}/transactions/commit", CommitTransactionRequest.class),
        LIST_VIEWS(HTTPRequest.HTTPMethod.GET, "/v1/{prefix}/namespaces/{namespace}/views", null),
        VIEW_EXISTS(HTTPRequest.HTTPMethod.HEAD, "/v1/{prefix}/namespaces/{namespace}/views/{view}"),
        LOAD_VIEW(HTTPRequest.HTTPMethod.GET, "/v1/{prefix}/namespaces/{namespace}/views/{view}", null),
        CREATE_VIEW(HTTPRequest.HTTPMethod.POST, "/v1/{prefix}/namespaces/{namespace}/views", CreateViewRequest.class),
        UPDATE_VIEW(HTTPRequest.HTTPMethod.POST, "/v1/{prefix}/namespaces/{namespace}/views/{view}", UpdateTableRequest.class),
        RENAME_VIEW(HTTPRequest.HTTPMethod.POST, "/v1/{prefix}/views/rename", RenameTableRequest.class),
        DROP_VIEW(HTTPRequest.HTTPMethod.DELETE, "/v1/{prefix}/namespaces/{namespace}/views/{view}");

        private final HTTPRequest.HTTPMethod method;
        private final int requiredLength;
        private final Map<Integer, String> requirements;
        private final Map<Integer, String> variables;
        private final Class<? extends RESTRequest> requestClass;
        private final String resourcePath;

        private Route(HTTPRequest.HTTPMethod method, String pattern) {
            this(method, pattern, null);
        }

        private Route(HTTPRequest.HTTPMethod method, String pattern, Class<? extends RESTRequest> requestClass) {
            this.method = method;
            this.resourcePath = pattern;
            List parts = SLASH.splitToList((CharSequence)pattern.replaceFirst("/v1/", "v1/").replace("/{prefix}", ""));
            ImmutableMap.Builder requirementsBuilder = ImmutableMap.builder();
            ImmutableMap.Builder variablesBuilder = ImmutableMap.builder();
            for (int pos = 0; pos < parts.size(); ++pos) {
                String part = (String)parts.get(pos);
                if (part.startsWith("{") && part.endsWith("}")) {
                    variablesBuilder.put((Object)pos, (Object)part.substring(1, part.length() - 1));
                    continue;
                }
                requirementsBuilder.put((Object)pos, (Object)part);
            }
            this.requestClass = requestClass;
            this.requiredLength = parts.size();
            this.requirements = requirementsBuilder.build();
            this.variables = variablesBuilder.build();
        }

        private boolean matches(HTTPRequest.HTTPMethod requestMethod, List<String> requestPath) {
            return this.method == requestMethod && this.requiredLength == requestPath.size() && this.requirements.entrySet().stream().allMatch(requirement -> ((String)requirement.getValue()).equalsIgnoreCase((String)requestPath.get((Integer)requirement.getKey())));
        }

        private Map<String, String> variables(List<String> requestPath) {
            ImmutableMap.Builder vars = ImmutableMap.builder();
            this.variables.forEach((key, value) -> vars.put(value, (Object)((String)requestPath.get((int)key))));
            return vars.build();
        }

        public static Pair<Route, Map<String, String>> from(HTTPRequest.HTTPMethod method, String path) {
            List parts = SLASH.splitToList((CharSequence)path);
            for (Route candidate : Route.values()) {
                if (!candidate.matches(method, parts)) continue;
                return Pair.of((Object)((Object)candidate), candidate.variables(parts));
            }
            return null;
        }

        public Class<? extends RESTRequest> requestClass() {
            return this.requestClass;
        }
    }

    private static class BadRequestType
    extends RuntimeException {
        private BadRequestType(Class<?> requestType, Object request) {
            super(String.format("Invalid request object, not a %s: %s", requestType.getName(), request));
        }
    }

    private static class BadResponseType
    extends RuntimeException {
        private BadResponseType(Class<?> responseType, Object response) {
            super(String.format("Invalid response object, not a %s: %s", responseType.getName(), response));
        }
    }
}

