/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.kudu.org.apache.kudu.util;

import java.time.Instant;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;

@InterfaceAudience.Private
public class LogThrottler {
    private final Logger log;
    private long lastLoggedTimeSecs = -1L;

    public LogThrottler(Logger log) {
        this.log = log;
    }

    public void trace(long seconds, String msg) {
        if (this.shouldLog(seconds)) {
            this.log.trace(msg);
        }
    }

    public void trace(long seconds, String format, Object arg) {
        if (this.shouldLog(seconds)) {
            this.log.trace(format, arg);
        }
    }

    public void trace(long seconds, String format, Object arg1, Object arg2) {
        if (this.shouldLog(seconds)) {
            this.log.trace(format, arg1, arg2);
        }
    }

    public void trace(long seconds, String format, Object ... arguments) {
        if (this.shouldLog(seconds)) {
            this.log.trace(format, arguments);
        }
    }

    public void warn(long seconds, String msg) {
        if (this.shouldLog(seconds)) {
            this.log.warn(msg);
        }
    }

    public void warn(long seconds, String format, Object arg) {
        if (this.shouldLog(seconds)) {
            this.log.warn(format, arg);
        }
    }

    public void warn(long seconds, String format, Object arg1, Object arg2) {
        if (this.shouldLog(seconds)) {
            this.log.warn(format, arg1, arg2);
        }
    }

    public void warn(long seconds, String format, Object ... arguments) {
        if (this.shouldLog(seconds)) {
            this.log.warn(format, arguments);
        }
    }

    public void error(long seconds, String msg) {
        if (this.shouldLog(seconds)) {
            this.log.error(msg);
        }
    }

    public void error(long seconds, String format, Object arg) {
        if (this.shouldLog(seconds)) {
            this.log.error(format, arg);
        }
    }

    public void error(long seconds, String format, Object arg1, Object arg2) {
        if (this.shouldLog(seconds)) {
            this.log.error(format, arg1, arg2);
        }
    }

    public void error(long seconds, String format, Object ... arguments) {
        if (this.shouldLog(seconds)) {
            this.log.error(format, arguments);
        }
    }

    public void info(long seconds, String msg) {
        if (this.shouldLog(seconds)) {
            this.log.info(msg);
        }
    }

    public void info(long seconds, String format, Object arg) {
        if (this.shouldLog(seconds)) {
            this.log.info(format, arg);
        }
    }

    public void info(long seconds, String format, Object arg1, Object arg2) {
        if (this.shouldLog(seconds)) {
            this.log.info(format, arg1, arg2);
        }
    }

    public void info(long seconds, String format, Object ... arguments) {
        if (this.shouldLog(seconds)) {
            this.log.info(format, arguments);
        }
    }

    public void debug(long seconds, String msg) {
        if (this.shouldLog(seconds)) {
            this.log.debug(msg);
        }
    }

    public void debug(long seconds, String format, Object arg) {
        if (this.shouldLog(seconds)) {
            this.log.debug(format, arg);
        }
    }

    public void debug(long seconds, String format, Object arg1, Object arg2) {
        if (this.shouldLog(seconds)) {
            this.log.debug(format, arg1, arg2);
        }
    }

    public void debug(long seconds, String format, Object ... arguments) {
        if (this.shouldLog(seconds)) {
            this.log.debug(format, arguments);
        }
    }

    private synchronized boolean shouldLog(long throttlingIntervalSecs) {
        long nowSecs = Instant.now().getEpochSecond();
        if (this.lastLoggedTimeSecs == -1L || this.lastLoggedTimeSecs + throttlingIntervalSecs < nowSecs) {
            this.lastLoggedTimeSecs = nowSecs;
            return true;
        }
        return false;
    }
}

