/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.kudu;

import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import org.apache.hadoop.io.Writable;
import org.apache.hive.kudu.org.apache.kudu.ColumnSchema;
import org.apache.hive.kudu.org.apache.kudu.Schema;
import org.apache.hive.kudu.org.apache.kudu.client.PartialRow;
import org.apache.hive.kudu.org.apache.kudu.client.RowResult;

public class KuduWritable
implements Writable {
    private PartialRow partialRow;
    private RowResult rowResult;

    public KuduWritable(PartialRow row) {
        this.partialRow = row;
        this.rowResult = null;
    }

    public void setRow(RowResult rowResult) {
        this.rowResult = rowResult;
        this.partialRow = null;
    }

    public PartialRow getPartialRow() {
        Preconditions.checkNotNull((Object)this.partialRow);
        return this.partialRow;
    }

    public RowResult getRowResult() {
        Preconditions.checkNotNull((Object)this.rowResult);
        return this.rowResult;
    }

    public Object getValueObject(int colIndex) {
        if (this.partialRow != null) {
            return this.partialRow.getObject(colIndex);
        }
        return this.rowResult.getObject(colIndex);
    }

    public Object getValueObject(String colName) {
        if (this.partialRow != null) {
            return this.partialRow.getObject(colName);
        }
        return this.rowResult.getObject(colName);
    }

    public boolean isSet(int colIndex) {
        if (this.partialRow != null) {
            return this.partialRow.isSet(colIndex);
        }
        return true;
    }

    public boolean isSet(String colName) {
        if (this.partialRow != null) {
            return this.partialRow.isSet(colName);
        }
        return true;
    }

    public void populateRow(PartialRow row) {
        Schema schema = row.getSchema();
        for (int i = 0; i < schema.getColumnCount(); ++i) {
            ColumnSchema col = schema.getColumnByIndex(i);
            if (!this.isSet(col.getName())) continue;
            Object value = this.getValueObject(col.getName());
            row.addObject(i, value);
        }
    }

    public void readFields(DataInput in) {
        throw new UnsupportedOperationException();
    }

    public void write(DataOutput out) {
        throw new UnsupportedOperationException();
    }
}

