/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.tuple;

import java.util.Arrays;
import org.apache.datasketches.hive.tuple.ArrayOfDoublesSketchEvaluator;
import org.apache.datasketches.hive.tuple.ArrayOfDoublesUnionState;
import org.apache.datasketches.hive.tuple.ObjectInspectorValidator;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesSketches;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.udf.generic.AbstractGenericUDAFResolver;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFParameterInfo;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;

@Description(name="UnionArrayOfDoublesSketch", value="_FUNC_(sketch, nominal number of entries, number of values)", extended="Returns an ArrayOfDoublesSketch as a binary blob that can be operated on by other ArrayOfDoublesSketch related functions. The nominal number of entries is optional, must be a power of 2, does not have to match the input sketches, and controls the relative error expected from the sketch. A number of 16384 can be expected to yield errors of roughly +-1.5% in the estimation of uniques. The default number is defined in the sketches-core library, and at the time of this writing was 4096 (about 3% error). The number of values is optional and must match all input sketches (defaults to 1)")
public class UnionArrayOfDoublesSketchUDAF
extends AbstractGenericUDAFResolver {
    public GenericUDAFEvaluator getEvaluator(GenericUDAFParameterInfo info) throws SemanticException {
        ObjectInspector[] inspectors = info.getParameterObjectInspectors();
        if (inspectors.length < 1) {
            throw new UDFArgumentException("Expected at least 1 argument");
        }
        if (inspectors.length > 3) {
            throw new UDFArgumentTypeException(inspectors.length - 1, "Expected no more than 3 arguments");
        }
        ObjectInspectorValidator.validateGivenPrimitiveCategory(inspectors[0], 0, PrimitiveObjectInspector.PrimitiveCategory.BINARY);
        if (inspectors.length > 1) {
            ObjectInspectorValidator.validateIntegralParameter(inspectors[1], 1);
        }
        if (inspectors.length > 2) {
            ObjectInspectorValidator.validateIntegralParameter(inspectors[2], 2);
        }
        return new UnionArrayOfDoublesSketchEvaluator();
    }

    public static class UnionArrayOfDoublesSketchEvaluator
    extends ArrayOfDoublesSketchEvaluator {
        private static final int DEFAULT_NUM_VALUES = 1;
        private PrimitiveObjectInspector sketchInspector_;
        private PrimitiveObjectInspector numValuesInspector_;

        public ObjectInspector init(GenericUDAFEvaluator.Mode mode, ObjectInspector[] inspectors) throws HiveException {
            super.init(mode, inspectors);
            if (mode == GenericUDAFEvaluator.Mode.PARTIAL1 || mode == GenericUDAFEvaluator.Mode.COMPLETE) {
                this.sketchInspector_ = (PrimitiveObjectInspector)inspectors[0];
                if (inspectors.length > 1) {
                    this.nominalNumEntriesInspector_ = (PrimitiveObjectInspector)inspectors[1];
                }
                if (inspectors.length > 2) {
                    this.numValuesInspector_ = (PrimitiveObjectInspector)inspectors[2];
                }
            } else {
                this.intermediateInspector_ = (StructObjectInspector)inspectors[0];
            }
            if (mode == GenericUDAFEvaluator.Mode.PARTIAL1 || mode == GenericUDAFEvaluator.Mode.PARTIAL2) {
                return ObjectInspectorFactory.getStandardStructObjectInspector(Arrays.asList("nominalEntries", "numValues", "sketch"), Arrays.asList(PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.INT), PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.INT), PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.BINARY)));
            }
            return PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.BINARY);
        }

        public void iterate(GenericUDAFEvaluator.AggregationBuffer buf, Object[] data) throws HiveException {
            byte[] serializedSketch;
            if (data[0] == null) {
                return;
            }
            ArrayOfDoublesUnionState state = (ArrayOfDoublesUnionState)buf;
            if (!state.isInitialized()) {
                this.initializeState(state, data);
            }
            if ((serializedSketch = (byte[])this.sketchInspector_.getPrimitiveJavaObject(data[0])) == null) {
                return;
            }
            state.update(ArrayOfDoublesSketches.wrapSketch((Memory)Memory.wrap((byte[])serializedSketch)));
        }

        private void initializeState(ArrayOfDoublesUnionState state, Object[] data) {
            int nominalNumEntries = 4096;
            if (this.nominalNumEntriesInspector_ != null) {
                nominalNumEntries = PrimitiveObjectInspectorUtils.getInt((Object)data[1], (PrimitiveObjectInspector)this.nominalNumEntriesInspector_);
            }
            int numValues = 1;
            if (this.numValuesInspector_ != null) {
                numValues = PrimitiveObjectInspectorUtils.getInt((Object)data[2], (PrimitiveObjectInspector)this.numValuesInspector_);
            }
            state.init(nominalNumEntries, numValues);
        }

        public GenericUDAFEvaluator.AggregationBuffer getNewAggregationBuffer() throws HiveException {
            return new ArrayOfDoublesUnionState();
        }
    }
}

