/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.kll;

import java.util.List;
import org.apache.datasketches.hive.common.BytesWritableHelper;
import org.apache.datasketches.hive.kll.Util;
import org.apache.datasketches.kll.KllFloatsSketch;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.quantilescommon.QuantileSearchCriteria;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.io.BytesWritable;

@Description(name="GetQuantiles", value="_FUNC_(sketch, [inclusive,] fractions...)", extended="Returns quantile values from a given KllFloatsSketch based on a given list of fractions. The optional boolean parameter 'inclusive' determines if the interval is inclusive, which is inclusive of the left fraction and exclusive of the right fraction, or the alternative of exclusive of the left fraction and inclusive of the right fraction. Defaults to inclusive (of left fraction) when not specified. The fractions represent normalized ranks, and must be from 0 to 1 inclusive. For example, a fraction of 0.5 corresponds to 50th percentile, which is the median value of the distribution (the number separating the higher half of the probability distribution from the lower half).")
public class GetQuantilesUDF
extends UDF {
    public List<Float> evaluate(BytesWritable serializedSketch, Double ... fractions) {
        return this.evaluate(serializedSketch, true, fractions);
    }

    public List<Float> evaluate(BytesWritable serializedSketch, Boolean inclusive, Double ... fractions) {
        if (serializedSketch == null) {
            return null;
        }
        KllFloatsSketch sketch = KllFloatsSketch.heapify((Memory)BytesWritableHelper.wrapAsMemory(serializedSketch));
        if (sketch.isEmpty()) {
            return null;
        }
        return Util.primitivesToList(sketch.getQuantiles(Util.objectsToPrimitives(fractions), inclusive != false ? QuantileSearchCriteria.INCLUSIVE : QuantileSearchCriteria.EXCLUSIVE));
    }
}

