/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.scostore;

import java.util.Collections;
import java.util.Map;
import org.datanucleus.state.DNStateManager;
import org.datanucleus.store.types.scostore.CollectionStore;
import org.datanucleus.store.types.scostore.SetStore;
import org.datanucleus.store.types.scostore.Store;

public interface MapStore<K, V>
extends Store {
    public boolean keysAreEmbedded();

    public boolean keysAreSerialised();

    public boolean valuesAreEmbedded();

    public boolean valuesAreSerialised();

    public boolean containsValue(DNStateManager var1, Object var2);

    public boolean containsKey(DNStateManager var1, Object var2);

    public V get(DNStateManager var1, Object var2);

    public V put(DNStateManager var1, K var2, V var3);

    default public void put(DNStateManager sm, K key, V value, V previousValue, boolean present) {
        this.put(sm, key, value);
    }

    public void putAll(DNStateManager var1, Map<? extends K, ? extends V> var2);

    default public void putAll(DNStateManager<?> sm, Map<? extends K, ? extends V> m, Map<K, V> previousMap) {
        this.putAll(sm, m);
    }

    public V remove(DNStateManager var1, Object var2);

    public void remove(DNStateManager var1, Object var2, Object var3);

    public void clear(DNStateManager var1);

    default public void update(DNStateManager sm, Map<K, V> map) {
        this.clear(sm);
        this.putAll(sm, map, Collections.emptyMap());
    }

    public SetStore<K> keySetStore();

    public CollectionStore<V> valueCollectionStore();

    public SetStore<Map.Entry<K, V>> entrySetStore();

    public boolean updateEmbeddedKey(DNStateManager var1, Object var2, int var3, Object var4);

    public boolean updateEmbeddedValue(DNStateManager var1, Object var2, int var3, Object var4);
}

