/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.metadata;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.DatastoreIdentityMetaData;
import org.datanucleus.metadata.EmbeddedMetaData;
import org.datanucleus.metadata.FieldRole;
import org.datanucleus.metadata.FileMetaData;
import org.datanucleus.metadata.InterfaceMetaData;
import org.datanucleus.metadata.InvalidMemberMetaDataException;
import org.datanucleus.metadata.JdbcType;
import org.datanucleus.metadata.MetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.metadata.PersistenceFileMetaData;
import org.datanucleus.metadata.PersistenceUnitMetaData;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.metadata.ValueGenerationStrategy;
import org.datanucleus.metadata.xml.XmlMetaDataParser;
import org.datanucleus.plugin.PluginManager;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class MetaDataUtils {
    private static MetaDataUtils instance;

    public static synchronized MetaDataUtils getInstance() {
        if (instance == null) {
            instance = new MetaDataUtils();
        }
        return instance;
    }

    protected MetaDataUtils() {
    }

    public boolean arrayStorableAsByteArrayInSingleColumn(AbstractMemberMetaData fmd) {
        if (fmd == null || !fmd.hasArray()) {
            return false;
        }
        String arrayComponentType = fmd.getType().getComponentType().getName();
        return arrayComponentType.equals(ClassNameConstants.BOOLEAN) || arrayComponentType.equals(ClassNameConstants.BYTE) || arrayComponentType.equals(ClassNameConstants.CHAR) || arrayComponentType.equals(ClassNameConstants.DOUBLE) || arrayComponentType.equals(ClassNameConstants.FLOAT) || arrayComponentType.equals(ClassNameConstants.INT) || arrayComponentType.equals(ClassNameConstants.LONG) || arrayComponentType.equals(ClassNameConstants.SHORT) || arrayComponentType.equals(ClassNameConstants.JAVA_LANG_BOOLEAN) || arrayComponentType.equals(ClassNameConstants.JAVA_LANG_BYTE) || arrayComponentType.equals(ClassNameConstants.JAVA_LANG_CHARACTER) || arrayComponentType.equals(ClassNameConstants.JAVA_LANG_DOUBLE) || arrayComponentType.equals(ClassNameConstants.JAVA_LANG_FLOAT) || arrayComponentType.equals(ClassNameConstants.JAVA_LANG_INTEGER) || arrayComponentType.equals(ClassNameConstants.JAVA_LANG_LONG) || arrayComponentType.equals(ClassNameConstants.JAVA_LANG_SHORT) || arrayComponentType.equals(ClassNameConstants.JAVA_MATH_BIGDECIMAL) || arrayComponentType.equals(ClassNameConstants.JAVA_MATH_BIGINTEGER);
    }

    public boolean storesPersistable(AbstractMemberMetaData mmd, ExecutionContext ec) {
        if (mmd == null) {
            return false;
        }
        ClassLoaderResolver clr = ec.getClassLoaderResolver();
        MetaDataManager mmgr = ec.getMetaDataManager();
        if (mmd.hasCollection()) {
            if (mmd.getCollection().elementIsPersistent()) {
                return true;
            }
            String elementType = mmd.getCollection().getElementType();
            Class elementCls = clr.classForName(elementType);
            if (mmgr.getMetaDataForImplementationOfReference(elementCls, null, clr) != null) {
                return true;
            }
            if (elementCls != null && ClassUtils.isReferenceType(elementCls)) {
                try {
                    String[] impls = this.getImplementationNamesForReferenceField(mmd, FieldRole.ROLE_COLLECTION_ELEMENT, clr, mmgr);
                    if (impls != null) {
                        elementCls = clr.classForName(impls[0]);
                        if (ec.getApiAdapter().isPersistable(elementCls)) {
                            return true;
                        }
                    }
                }
                catch (NucleusUserException impls) {}
            }
        } else if (mmd.hasMap()) {
            if (mmd.getMap().keyIsPersistent()) {
                return true;
            }
            String keyType = mmd.getMap().getKeyType();
            Class keyCls = clr.classForName(keyType);
            if (mmgr.getMetaDataForImplementationOfReference(keyCls, null, clr) != null) {
                return true;
            }
            if (keyCls != null && ClassUtils.isReferenceType(keyCls)) {
                try {
                    String[] impls = this.getImplementationNamesForReferenceField(mmd, FieldRole.ROLE_MAP_KEY, clr, mmgr);
                    if (impls != null) {
                        keyCls = clr.classForName(impls[0]);
                        if (ec.getApiAdapter().isPersistable(keyCls)) {
                            return true;
                        }
                    }
                }
                catch (NucleusUserException impls) {
                    // empty catch block
                }
            }
            if (mmd.getMap().valueIsPersistent()) {
                return true;
            }
            String valueType = mmd.getMap().getValueType();
            Class valueCls = clr.classForName(valueType);
            if (mmgr.getMetaDataForImplementationOfReference(valueCls, null, clr) != null) {
                return true;
            }
            if (valueCls != null && ClassUtils.isReferenceType(valueCls)) {
                try {
                    String[] impls = this.getImplementationNamesForReferenceField(mmd, FieldRole.ROLE_MAP_VALUE, clr, mmgr);
                    if (impls != null) {
                        valueCls = clr.classForName(impls[0]);
                        if (ec.getApiAdapter().isPersistable(valueCls)) {
                            return true;
                        }
                    }
                }
                catch (NucleusUserException nucleusUserException) {}
            }
        } else if (mmd.hasArray()) {
            if (mmgr.getApiAdapter().isPersistable(mmd.getType().getComponentType())) {
                return true;
            }
            String elementType = mmd.getArray().getElementType();
            Class elementCls = clr.classForName(elementType);
            if (mmgr.getApiAdapter().isPersistable(elementCls)) {
                return true;
            }
            if (mmgr.getMetaDataForImplementationOfReference(elementCls, null, clr) != null) {
                return true;
            }
            if (elementCls != null && ClassUtils.isReferenceType(elementCls)) {
                try {
                    String[] impls = this.getImplementationNamesForReferenceField(mmd, FieldRole.ROLE_ARRAY_ELEMENT, clr, mmgr);
                    if (impls != null) {
                        elementCls = clr.classForName(impls[0]);
                        if (ec.getApiAdapter().isPersistable(elementCls)) {
                            return true;
                        }
                    }
                }
                catch (NucleusUserException nucleusUserException) {}
            }
        } else {
            if (ClassUtils.isReferenceType(mmd.getType()) && mmgr.getMetaDataForImplementationOfReference(mmd.getType(), null, clr) != null) {
                return true;
            }
            if (mmgr.getMetaDataForClass(mmd.getType(), clr) != null) {
                return true;
            }
        }
        return false;
    }

    public boolean storesFCO(AbstractMemberMetaData mmd, ExecutionContext ec) {
        if (mmd == null) {
            return false;
        }
        ClassLoaderResolver clr = ec.getClassLoaderResolver();
        MetaDataManager mgr = ec.getMetaDataManager();
        if (mmd.isSerialized() || mmd.isEmbedded()) {
            return false;
        }
        if (mmd.hasCollection() && !mmd.getCollection().isSerializedElement() && !mmd.getCollection().isEmbeddedElement()) {
            if (mmd.getCollection().elementIsPersistent()) {
                return true;
            }
            String elementType = mmd.getCollection().getElementType();
            Class elementCls = clr.classForName(elementType);
            if (elementCls != null && ClassUtils.isReferenceType(elementCls) && mgr.getMetaDataForImplementationOfReference(elementCls, null, clr) != null) {
                return true;
            }
        } else if (mmd.hasMap()) {
            if (mmd.getMap().keyIsPersistent() && !mmd.getMap().isEmbeddedKey() && !mmd.getMap().isSerializedKey()) {
                return true;
            }
            String keyType = mmd.getMap().getKeyType();
            Class keyCls = clr.classForName(keyType);
            if (keyCls != null && ClassUtils.isReferenceType(keyCls) && mgr.getMetaDataForImplementationOfReference(keyCls, null, clr) != null) {
                return true;
            }
            if (mmd.getMap().valueIsPersistent() && !mmd.getMap().isEmbeddedValue() && !mmd.getMap().isSerializedValue()) {
                return true;
            }
            String valueType = mmd.getMap().getValueType();
            Class valueCls = clr.classForName(valueType);
            if (valueCls != null && ClassUtils.isReferenceType(valueCls) && mgr.getMetaDataForImplementationOfReference(valueCls, null, clr) != null) {
                return true;
            }
        } else if (mmd.hasArray() && !mmd.getArray().isSerializedElement() && !mmd.getArray().isEmbeddedElement()) {
            if (mgr.getApiAdapter().isPersistable(mmd.getType().getComponentType())) {
                return true;
            }
        } else {
            if (ClassUtils.isReferenceType(mmd.getType()) && mgr.getMetaDataForImplementationOfReference(mmd.getType(), null, clr) != null) {
                return true;
            }
            if (mgr.getMetaDataForClass(mmd.getType(), clr) != null) {
                return true;
            }
        }
        return false;
    }

    public String[] getValuesForCommaSeparatedAttribute(String attr) {
        if (attr == null || attr.length() == 0) {
            return null;
        }
        String[] values = StringUtils.split(attr, ",");
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                values[i] = values[i].trim();
            }
        }
        return values;
    }

    public String[] getImplementationNamesForReferenceField(AbstractMemberMetaData fmd, FieldRole fieldRole, ClassLoaderResolver clr, MetaDataManager mmgr) {
        String[] implTypes = null;
        if (fieldRole == FieldRole.ROLE_FIELD) {
            Class implCls;
            implTypes = fmd.getFieldTypes();
            if (implTypes != null && implTypes.length == 1 && (implCls = clr.classForName(implTypes[0].trim())).isInterface()) {
                implTypes = mmgr.getClassesImplementingInterface(implTypes[0], clr);
            }
        } else if (FieldRole.ROLE_COLLECTION_ELEMENT == fieldRole) {
            implTypes = fmd.getCollection().getElementTypes();
        } else if (FieldRole.ROLE_ARRAY_ELEMENT == fieldRole) {
            implTypes = fmd.getArray().getElementTypes();
        } else if (FieldRole.ROLE_MAP_KEY == fieldRole) {
            implTypes = fmd.getMap().getKeyTypes();
        } else if (FieldRole.ROLE_MAP_VALUE == fieldRole) {
            implTypes = fmd.getMap().getValueTypes();
        }
        if (implTypes == null) {
            String type = null;
            if (fmd.hasCollection() && fieldRole == FieldRole.ROLE_COLLECTION_ELEMENT) {
                type = fmd.getCollection().getElementType();
            } else if (fmd.hasMap() && fieldRole == FieldRole.ROLE_MAP_KEY) {
                type = fmd.getMap().getKeyType();
            } else if (fmd.hasMap() && fieldRole == FieldRole.ROLE_MAP_VALUE) {
                type = fmd.getMap().getValueType();
            } else if (fmd.hasArray() && fieldRole == FieldRole.ROLE_ARRAY_ELEMENT) {
                type = fmd.getArray().getElementType();
                if (type == null) {
                    type = fmd.getType().getComponentType().getName();
                }
            } else {
                type = fmd.getTypeName();
            }
            if (!type.equals(ClassNameConstants.Object)) {
                implTypes = mmgr.getClassesImplementingInterface(type, clr);
            }
            if (implTypes == null) {
                throw new InvalidMemberMetaDataException("044161", fmd.getClassName(), fmd.getName(), type);
            }
        }
        return new LinkedHashSet<String>(Arrays.asList(implTypes)).toArray(new String[0]);
    }

    public static boolean getBooleanForString(String str, boolean dflt) {
        if (StringUtils.isWhitespace(str)) {
            return dflt;
        }
        return Boolean.parseBoolean(str);
    }

    public static String getValueForExtensionRecursively(MetaData metadata, String key) {
        if (metadata == null) {
            return null;
        }
        String value = metadata.getValueForExtension(key);
        if (value == null) {
            value = MetaDataUtils.getValueForExtensionRecursively(metadata.getParent(), key);
        }
        return value;
    }

    public static String[] getValuesForExtensionRecursively(MetaData metadata, String key) {
        if (metadata == null) {
            return null;
        }
        String[] values = metadata.getValuesForExtension(key);
        if (values == null) {
            values = MetaDataUtils.getValuesForExtensionRecursively(metadata.getParent(), key);
        }
        return values;
    }

    public static boolean isJdbcTypeNumeric(JdbcType jdbcType) {
        if (jdbcType == null) {
            return false;
        }
        switch (jdbcType) {
            case INTEGER: 
            case SMALLINT: 
            case TINYINT: 
            case NUMERIC: 
            case BIGINT: {
                return true;
            }
        }
        return false;
    }

    public static boolean isJdbcTypeFloatingPoint(JdbcType jdbcType) {
        if (jdbcType == null) {
            return false;
        }
        switch (jdbcType) {
            case DECIMAL: 
            case FLOAT: 
            case REAL: {
                return true;
            }
        }
        return false;
    }

    public static boolean isJdbcTypeString(JdbcType jdbcType) {
        if (jdbcType == null) {
            return false;
        }
        switch (jdbcType) {
            case CHAR: 
            case VARCHAR: 
            case CLOB: 
            case LONGVARCHAR: 
            case NCHAR: 
            case NVARCHAR: 
            case LONGNVARCHAR: {
                return true;
            }
        }
        return false;
    }

    public static JdbcType getJdbcTypeForEnum(AbstractMemberMetaData mmd, FieldRole role, ClassLoaderResolver clr) {
        JdbcType jdbcType = JdbcType.VARCHAR;
        if (mmd != null) {
            String methodName = null;
            Class enumType = null;
            ColumnMetaData[] colmds = null;
            if (role == FieldRole.ROLE_FIELD) {
                enumType = mmd.getType();
                if (mmd.hasExtension("enum-value-getter")) {
                    methodName = mmd.getValueForExtension("enum-value-getter");
                }
                colmds = mmd.getColumnMetaData();
            } else if (role == FieldRole.ROLE_COLLECTION_ELEMENT || role == FieldRole.ROLE_ARRAY_ELEMENT) {
                if (mmd.getElementMetaData() != null) {
                    enumType = clr.classForName(mmd.hasCollection() ? mmd.getCollection().getElementType() : mmd.getArray().getElementType());
                    if (mmd.getElementMetaData().hasExtension("enum-value-getter")) {
                        methodName = mmd.getElementMetaData().getValueForExtension("enum-value-getter");
                    }
                    colmds = mmd.getElementMetaData().getColumnMetaData();
                }
            } else if (role == FieldRole.ROLE_MAP_KEY) {
                if (mmd.getKeyMetaData() != null) {
                    enumType = clr.classForName(mmd.getMap().getKeyType());
                    if (mmd.getKeyMetaData().hasExtension("enum-value-getter")) {
                        methodName = mmd.getKeyMetaData().getValueForExtension("enum-value-getter");
                    }
                    colmds = mmd.getKeyMetaData().getColumnMetaData();
                }
            } else if (role == FieldRole.ROLE_MAP_VALUE && mmd.getValueMetaData() != null) {
                enumType = clr.classForName(mmd.getMap().getValueType());
                if (mmd.getValueMetaData().hasExtension("enum-value-getter")) {
                    methodName = mmd.getValueMetaData().getValueForExtension("enum-value-getter");
                }
                colmds = mmd.getValueMetaData().getColumnMetaData();
            }
            if (methodName == null) {
                if (colmds != null && colmds.length == 1 && colmds[0].getJdbcType() != null) {
                    jdbcType = colmds[0].getJdbcType();
                }
            } else {
                try {
                    Method getterMethod = ClassUtils.getMethodForClass(enumType, methodName, null);
                    Class<?> returnType = getterMethod.getReturnType();
                    if (returnType == Short.TYPE || returnType == Integer.TYPE || returnType == Long.TYPE || Number.class.isAssignableFrom(returnType)) {
                        return JdbcType.INTEGER;
                    }
                    return JdbcType.VARCHAR;
                }
                catch (Exception e) {
                    NucleusLogger.PERSISTENCE.warn("Specified enum value-getter for method " + methodName + " on field " + mmd.getFullFieldName() + " gave an error on extracting the value", e);
                }
            }
        }
        return jdbcType;
    }

    public static List<AbstractClassMetaData> getMetaDataForCandidates(Class cls, boolean subclasses, ExecutionContext ec) {
        ArrayList<AbstractClassMetaData> cmds;
        block5: {
            String[] subclassNames;
            ClassLoaderResolver clr;
            block4: {
                String[] impls;
                clr = ec.getClassLoaderResolver();
                cmds = new ArrayList<AbstractClassMetaData>();
                if (!cls.isInterface()) break block4;
                InterfaceMetaData icmd = ec.getMetaDataManager().getMetaDataForInterface(cls, clr);
                if (icmd == null) {
                    throw new NucleusUserException("Attempting to query an interface yet it is not declared 'persistent'. Define the interface in metadata as being persistent to perform this operation, and make sure any implementations use the same identity and identity member(s)");
                }
                for (String implName : impls = ec.getMetaDataManager().getClassesImplementingInterface(cls.getName(), clr)) {
                    String[] subclassNames2;
                    AbstractClassMetaData implCmd = ec.getMetaDataManager().getMetaDataForClass(implName, clr);
                    cmds.add(implCmd);
                    if (!subclasses || (subclassNames2 = ec.getMetaDataManager().getSubclassesForClass(implCmd.getFullClassName(), true)) == null || subclassNames2.length <= 0) continue;
                    for (String subclassName : subclassNames2) {
                        cmds.add(ec.getMetaDataManager().getMetaDataForClass(subclassName, clr));
                    }
                }
                break block5;
            }
            AbstractClassMetaData cmd = ec.getMetaDataManager().getMetaDataForClass(cls, clr);
            cmds.add(cmd);
            if (!subclasses || (subclassNames = ec.getMetaDataManager().getSubclassesForClass(cls.getName(), true)) == null || subclassNames.length <= 0) break block5;
            for (int j = 0; j < subclassNames.length; ++j) {
                AbstractClassMetaData subcmd = ec.getMetaDataManager().getMetaDataForClass(subclassNames[j], clr);
                cmds.add(subcmd);
            }
        }
        return cmds;
    }

    public static FileMetaData[] getFileMetaDataForInputFiles(MetaDataManager metaDataMgr, ClassLoaderResolver clr, String[] inputFiles) {
        FileMetaData[] filemds = null;
        String msg = null;
        try {
            int i;
            HashSet<String> metadataFiles = new HashSet<String>();
            HashSet<String> classNames = new HashSet<String>();
            for (int i2 = 0; i2 < inputFiles.length; ++i2) {
                if (inputFiles[i2].endsWith(".class")) {
                    URL classFileURL = null;
                    try {
                        classFileURL = new URL("file:" + inputFiles[i2]);
                    }
                    catch (Exception e) {
                        msg = Localiser.msg("014013", inputFiles[i2]);
                        NucleusLogger.METADATA.error(msg);
                        throw new NucleusUserException(msg);
                    }
                    String className = null;
                    try {
                        className = ClassUtils.getClassNameForFileURL(classFileURL);
                        classNames.add(className);
                    }
                    catch (Throwable e) {
                        className = ClassUtils.getClassNameForFileName(inputFiles[i2], clr);
                        if (className != null) {
                            classNames.add(className);
                            continue;
                        }
                        NucleusLogger.METADATA.info("File \"" + inputFiles[i2] + "\" could not be resolved to a class name, so ignoring. Specify it as a class explicitly using persistence.xml to overcome this", e);
                    }
                    continue;
                }
                metadataFiles.add(inputFiles[i2]);
            }
            FileMetaData[] filemds1 = metaDataMgr.loadMetaDataFiles(metadataFiles.toArray(new String[metadataFiles.size()]), null);
            FileMetaData[] filemds2 = metaDataMgr.loadClasses(classNames.toArray(new String[classNames.size()]), null);
            filemds = new FileMetaData[filemds1.length + filemds2.length];
            int pos = 0;
            for (i = 0; i < filemds1.length; ++i) {
                filemds[pos++] = filemds1[i];
            }
            for (i = 0; i < filemds2.length; ++i) {
                filemds[pos++] = filemds2[i];
            }
        }
        catch (Exception e) {
            msg = Localiser.msg("014014", e.getMessage());
            NucleusLogger.METADATA.error(msg, e);
            throw new NucleusUserException(msg, e);
        }
        return filemds;
    }

    public static PersistenceFileMetaData[] parsePersistenceFiles(PluginManager pluginMgr, String persistenceFilename, boolean validate, boolean namespaceAware, ClassLoaderResolver clr) {
        XmlMetaDataParser parser = new XmlMetaDataParser(null, pluginMgr, validate, namespaceAware);
        if (persistenceFilename != null) {
            try {
                URL fileURL = new URL(persistenceFilename);
                MetaData permd = parser.parseXmlMetaDataURL(fileURL, "persistence");
                return new PersistenceFileMetaData[]{(PersistenceFileMetaData)permd};
            }
            catch (MalformedURLException mue) {
                NucleusLogger.METADATA.error("Error reading user-specified persistence.xml file " + persistenceFilename, mue);
                return null;
            }
        }
        LinkedHashSet<MetaData> metadata = new LinkedHashSet<MetaData>();
        try {
            Enumeration<URL> files = clr.getResources("META-INF/persistence.xml", Thread.currentThread().getContextClassLoader());
            if (!files.hasMoreElements()) {
                return null;
            }
            while (files.hasMoreElements()) {
                URL fileURL = files.nextElement();
                MetaData permd = parser.parseXmlMetaDataURL(fileURL, "persistence");
                metadata.add(permd);
            }
        }
        catch (IOException ioe) {
            NucleusLogger.METADATA.warn(StringUtils.getStringFromStackTrace(ioe));
        }
        return metadata.toArray(new PersistenceFileMetaData[metadata.size()]);
    }

    public static PersistenceUnitMetaData getMetaDataForPersistenceUnit(PluginManager pluginMgr, String persistenceFilename, String unitName, boolean validate, boolean namespaceAware, ClassLoaderResolver clr) {
        PersistenceFileMetaData[] files = MetaDataUtils.parsePersistenceFiles(pluginMgr, persistenceFilename, validate, namespaceAware, clr);
        if (files == null) {
            throw new NucleusUserException(Localiser.msg("044046"));
        }
        for (PersistenceFileMetaData pfmd : files) {
            PersistenceUnitMetaData[] unitmds = pfmd.getPersistenceUnits();
            if (unitmds == null) continue;
            for (PersistenceUnitMetaData pumd : unitmds) {
                if (!pumd.getName().equals(unitName)) continue;
                return pumd;
            }
        }
        return null;
    }

    public static boolean persistColumnAsNumeric(ColumnMetaData colmd) {
        boolean useLong = false;
        if (colmd != null && MetaDataUtils.isJdbcTypeNumeric(colmd.getJdbcType())) {
            useLong = true;
        }
        return useLong;
    }

    public static boolean persistColumnAsString(ColumnMetaData colmd) {
        boolean useString = false;
        if (colmd != null && MetaDataUtils.isJdbcTypeString(colmd.getJdbcType())) {
            useString = true;
        }
        return useString;
    }

    public static Class getTypeOfDatastoreIdentity(DatastoreIdentityMetaData dimd) {
        if (dimd == null) {
            return Long.TYPE;
        }
        if (dimd.getValueStrategy() == ValueGenerationStrategy.UUIDHEX || dimd.getValueStrategy() == ValueGenerationStrategy.UUIDSTRING) {
            return String.class;
        }
        return Long.TYPE;
    }

    public static boolean isMemberEmbedded(AbstractMemberMetaData mmd, RelationType relationType, ClassLoaderResolver clr, MetaDataManager mmgr) {
        boolean embedded = false;
        if (mmd.isEmbedded()) {
            embedded = true;
        } else if (mmd.getEmbeddedMetaData() != null) {
            embedded = true;
        } else if (RelationType.isRelationMultiValued(relationType)) {
            if (mmd.hasCollection() && mmd.getElementMetaData() != null && mmd.getElementMetaData().getEmbeddedMetaData() != null) {
                embedded = true;
            } else if (mmd.hasArray() && mmd.getElementMetaData() != null && mmd.getElementMetaData().getEmbeddedMetaData() != null) {
                embedded = true;
            } else if (mmd.hasMap() && (mmd.getKeyMetaData() != null && mmd.getKeyMetaData().getEmbeddedMetaData() != null || mmd.getValueMetaData() != null && mmd.getValueMetaData().getEmbeddedMetaData() != null)) {
                embedded = true;
            }
        } else if (RelationType.isRelationSingleValued(relationType)) {
            AbstractClassMetaData mmdCmd = mmgr.getMetaDataForClass(mmd.getType(), clr);
            if (mmdCmd != null && mmdCmd.isEmbeddedOnly()) {
                embedded = true;
            }
        } else if (RelationType.isRelationMultiValued(relationType)) {
            // empty if block
        }
        return embedded;
    }

    public boolean isMemberEmbedded(MetaDataManager mmgr, ClassLoaderResolver clr, AbstractMemberMetaData mmd, RelationType relationType, AbstractMemberMetaData ownerMmd) {
        boolean embedded;
        block19: {
            List<AbstractMemberMetaData> embMmds;
            block20: {
                List<AbstractMemberMetaData> embMmds2;
                AbstractClassMetaData mmdCmd;
                embedded = false;
                if (relationType == RelationType.NONE) break block19;
                if (RelationType.isRelationSingleValued(relationType) && (mmdCmd = mmgr.getMetaDataForClass(mmd.getType(), clr)) != null && mmdCmd.isEmbeddedOnly()) {
                    return true;
                }
                if (mmd.isEmbedded() || mmd.getEmbeddedMetaData() != null) {
                    return true;
                }
                if (RelationType.isRelationMultiValued(relationType)) {
                    if (mmd.hasCollection() && mmd.getElementMetaData() != null) {
                        if (mmd.getElementMetaData().getEmbeddedMetaData() != null) {
                            return true;
                        }
                        if (mmd.getCollection().elementIsPersistent() && mmd.getCollection().isEmbeddedElement()) {
                            return true;
                        }
                    } else if (mmd.hasArray() && mmd.getElementMetaData() != null) {
                        if (mmd.getElementMetaData().getEmbeddedMetaData() != null) {
                            return true;
                        }
                        if (mmd.getArray().elementIsPersistent() && mmd.getArray().isEmbeddedElement()) {
                            return true;
                        }
                    } else if (mmd.hasMap()) {
                        if (mmd.getKeyMetaData() != null && mmd.getKeyMetaData().getEmbeddedMetaData() != null) {
                            return true;
                        }
                        if (mmd.getMap().keyIsPersistent() && mmd.getMap().isEmbeddedKey()) {
                            return true;
                        }
                        if (mmd.getValueMetaData() != null && mmd.getValueMetaData().getEmbeddedMetaData() != null) {
                            return true;
                        }
                        if (mmd.getMap().valueIsPersistent() && mmd.getMap().isEmbeddedValue()) {
                            return true;
                        }
                    }
                }
                if (!RelationType.isRelationSingleValued(relationType) || ownerMmd == null) break block19;
                if (!ownerMmd.hasCollection()) break block20;
                EmbeddedMetaData embmd = ownerMmd.getElementMetaData().getEmbeddedMetaData();
                if (embmd == null || (embMmds2 = embmd.getMemberMetaData()) == null) break block19;
                for (AbstractMemberMetaData embMmd : embMmds2) {
                    if (!embMmd.getName().equals(mmd.getName()) || !embMmd.isEmbedded() && embMmd.getEmbeddedMetaData() == null) continue;
                    return true;
                }
                break block19;
            }
            if (ownerMmd.getEmbeddedMetaData() != null && (embMmds = ownerMmd.getEmbeddedMetaData().getMemberMetaData()) != null) {
                for (AbstractMemberMetaData embMmd : embMmds) {
                    if (!embMmd.getName().equals(mmd.getName())) continue;
                    return embMmd.getEmbeddedMetaData() != null;
                }
            }
        }
        return embedded;
    }
}

