/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.security;

import com.google.protobuf.ByteString;
import com.google.protobuf.ServiceException;
import java.io.DataInput;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.SocketFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.LlapUtil;
import org.apache.hadoop.hive.llap.daemon.rpc.LlapDaemonProtocolProtos;
import org.apache.hadoop.hive.llap.impl.LlapManagementProtocolClientImpl;
import org.apache.hadoop.hive.llap.registry.LlapServiceInstance;
import org.apache.hadoop.hive.llap.registry.impl.LlapRegistryService;
import org.apache.hadoop.hive.llap.security.LlapTokenIdentifier;
import org.apache.hadoop.hive.registry.ServiceInstanceSet;
import org.apache.hadoop.io.DataInputByteBuffer;
import org.apache.hadoop.io.retry.RetryPolicies;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LlapTokenClient {
    private static final Logger LOG = LoggerFactory.getLogger(LlapTokenClient.class);
    private final LlapRegistryService registry;
    private final SocketFactory socketFactory;
    private final RetryPolicy retryPolicy;
    private final Configuration conf;
    private ServiceInstanceSet<LlapServiceInstance> activeInstances;
    private Collection<LlapServiceInstance> lastKnownInstances;
    private LlapManagementProtocolClientImpl client;
    private LlapServiceInstance clientInstance;
    private Token<LlapTokenIdentifier> currentToken;

    public LlapTokenClient(Configuration conf) {
        this.conf = conf;
        this.registry = new LlapRegistryService(false);
        this.registry.init(conf);
        this.socketFactory = NetUtils.getDefaultSocketFactory((Configuration)conf);
        this.retryPolicy = RetryPolicies.retryUpToMaximumTimeWithFixedSleep((long)16000L, (long)2000L, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    public Token<LlapTokenIdentifier> getDelegationToken(String appId) throws IOException {
        if (!UserGroupInformation.isSecurityEnabled()) {
            return null;
        }
        Iterator<LlapServiceInstance> llaps = null;
        if (this.clientInstance == null) {
            assert (this.client == null);
            llaps = this.getLlapServices(false).iterator();
            this.clientInstance = llaps.next();
        }
        ByteString tokenBytes = null;
        boolean hasRefreshed = false;
        while (true) {
            try {
                tokenBytes = this.getTokenBytes(appId);
            }
            catch (ServiceException | IOException ex) {
                LOG.error("Cannot get a token, trying a different instance", ex);
                this.client = null;
                this.clientInstance = null;
                this.currentToken = null;
                if (llaps == null || !llaps.hasNext()) {
                    if (hasRefreshed) {
                        throw new RuntimeException("Cannot find any LLAPs to get the token from");
                    }
                    llaps = this.getLlapServices(true).iterator();
                    hasRefreshed = true;
                }
                this.clientInstance = llaps.next();
                continue;
            }
            break;
        }
        Token<LlapTokenIdentifier> token = this.extractToken(tokenBytes);
        LOG.info("Obtained a LLAP delegation token from {}: {}", (Object)this.clientInstance, token);
        return token;
    }

    private Token<LlapTokenIdentifier> extractToken(ByteString tokenBytes) throws IOException {
        Token token = new Token();
        DataInputByteBuffer in = new DataInputByteBuffer();
        in.reset(new ByteBuffer[]{tokenBytes.asReadOnlyByteBuffer()});
        token.readFields((DataInput)in);
        return token;
    }

    private ByteString getTokenBytes(String appId) throws IOException, ServiceException {
        assert (this.clientInstance != null);
        if (this.currentToken != null) {
            try {
                return this.fetchTokenWithCurrentToken(appId);
            }
            catch (ServiceException | IOException e) {
                LOG.warn("Exception while getting delegation token, trying with kerberos login", e);
                return this.fetchTokenWithKerberosLogin(appId);
            }
        }
        LOG.info("currentToken is null, let's try to fetch one with kerberos login");
        return this.fetchTokenWithKerberosLogin(appId);
    }

    private ByteString fetchTokenWithCurrentToken(String appId) throws IOException, ServiceException {
        UserGroupInformation ugi = this.getUgiWithCurrentToken();
        return this.getTokenWithUgi(appId, ugi);
    }

    private ByteString fetchTokenWithKerberosLogin(String appId) throws IOException, ServiceException {
        UserGroupInformation ugi = this.getUgiFromKerberosLogin();
        return this.getTokenWithUgi(appId, ugi);
    }

    private UserGroupInformation getUgiWithCurrentToken() throws IOException {
        String currentUser = UserGroupInformation.getCurrentUser().getShortUserName();
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)currentUser);
        String address = new URL(this.clientInstance.getServicesAddress()).getHost();
        int port = this.clientInstance.getManagementPort();
        InetSocketAddress socketAddr = NetUtils.createSocketAddrForHost((String)address, (int)port);
        LOG.debug("Setup token with {}:{}, socketAddr: {}", new Object[]{address, port, socketAddr});
        SecurityUtil.setTokenService(this.currentToken, (InetSocketAddress)socketAddr);
        ugi.addToken(this.currentToken);
        return ugi;
    }

    private UserGroupInformation getUgiFromKerberosLogin() throws IOException {
        String llapPrincipal = HiveConf.getVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_KERBEROS_PRINCIPAL);
        String llapKeytab = HiveConf.getVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_KERBEROS_KEYTAB_FILE);
        LOG.info("Logging in using principal {} and keytab {}", (Object)llapPrincipal, (Object)llapKeytab);
        return LlapUtil.loginWithKerberos((String)llapPrincipal, (String)llapKeytab);
    }

    private ByteString getTokenWithUgi(String appId, UserGroupInformation ugi) throws ServiceException {
        if (this.client == null) {
            this.client = new LlapManagementProtocolClientImpl(this.conf, this.clientInstance.getHost(), this.clientInstance.getManagementPort(), this.retryPolicy, this.socketFactory);
        }
        this.client.withUgi(ugi);
        LlapDaemonProtocolProtos.GetTokenRequestProto.Builder req = LlapDaemonProtocolProtos.GetTokenRequestProto.newBuilder();
        if (!StringUtils.isBlank((CharSequence)appId)) {
            req.setAppId(appId);
        }
        return this.client.getDelegationToken(null, req.build()).getToken();
    }

    private synchronized List<LlapServiceInstance> getLlapServices(boolean doForceRefresh) throws IOException {
        Collection<LlapServiceInstance> daemons;
        if (!doForceRefresh && this.lastKnownInstances != null) {
            return new ArrayList<LlapServiceInstance>(this.lastKnownInstances);
        }
        if (this.activeInstances == null) {
            this.registry.start();
            this.activeInstances = this.registry.getInstances();
        }
        if ((daemons = this.activeInstances.getAll()) == null || daemons.isEmpty()) {
            throw new RuntimeException("No LLAPs found");
        }
        this.lastKnownInstances = daemons;
        return new ArrayList<LlapServiceInstance>(this.lastKnownInstances);
    }

    public LlapTokenClient withCurrentToken(Token<LlapTokenIdentifier> token) {
        this.currentToken = token;
        return this;
    }
}

