/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jaxb.runtime.v2;

import jakarta.xml.bind.JAXBException;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.jaxb.core.v2.ClassFactory;
import org.glassfish.jaxb.runtime.v2.JAXBContextFactory;

final class MUtils {
    private static final Logger LOGGER = Logger.getLogger("org.glassfish.jaxb.runtime");

    MUtils() {
    }

    static void open(Class[] classes) throws JAXBException {
        Module coreModule = ClassFactory.class.getModule();
        Module rtModule = JAXBContextFactory.class.getModule();
        if (rtModule == coreModule) {
            return;
        }
        for (Class<?> clazz : classes) {
            Class<?> jaxbClass = clazz.isArray() ? clazz.getComponentType() : clazz;
            Module classModule = jaxbClass.getModule();
            if (!classModule.isNamed() || "java.base".equals(classModule.getName())) continue;
            String packageName = jaxbClass.getPackageName();
            if (classModule.isOpen(packageName, rtModule)) {
                classModule.addOpens(packageName, coreModule);
                if (!LOGGER.isLoggable(Level.FINE)) continue;
                LOGGER.log(Level.FINE, "Openning package {0} in {1} to {2}.", new String[]{packageName, classModule.getName(), coreModule.getName()});
                continue;
            }
            throw new JAXBException(MessageFormat.format("Package {0} with class {1} defined in a module {2} must be open to at least {3} module.", packageName, jaxbClass.getName(), classModule.getName(), rtModule.getName()));
        }
    }
}

