/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.servlet;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Writer;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hive.http.HttpServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HS2LeadershipStatus
extends HttpServlet {
    private static final Logger LOG = LoggerFactory.getLogger(HS2LeadershipStatus.class);

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ServletContext context = this.getServletContext();
        if (!HttpServer.isInstrumentationAccessAllowed(context, request, response)) {
            LOG.warn("Unauthorized to perform GET action. remoteUser: {}", (Object)request.getRemoteUser());
            return;
        }
        this.setResponseHeaders(response);
        ServletContext ctx = this.getServletContext();
        AtomicBoolean isLeader = (AtomicBoolean)ctx.getAttribute("hs2.isLeader");
        LOG.info("Returning isLeader: {}", (Object)isLeader);
        ObjectMapper mapper = new ObjectMapper();
        mapper.writerWithDefaultPrettyPrinter().writeValue((Writer)response.getWriter(), (Object)isLeader);
        response.setStatus(200);
        response.flushBuffer();
    }

    protected void setResponseHeaders(HttpServletResponse response) {
        response.setContentType("application/json; charset=utf8");
        response.setHeader("Access-Control-Allow-Methods", "GET,DELETE");
        response.setHeader("Access-Control-Allow-Origin", "*");
    }
}

