/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.session;

import java.io.IOException;
import org.apache.hadoop.hive.metastore.security.DelegationTokenIdentifier;
import org.apache.hadoop.hive.metastore.security.DelegationTokenSelector;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;

public class SessionUtils {
    public static String getTokenStrForm(String tokenSignature) throws IOException {
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        DelegationTokenSelector tokenSelector = new DelegationTokenSelector();
        Token token = tokenSelector.selectToken(tokenSignature == null ? new Text() : new Text(tokenSignature), ugi.getTokens());
        return token != null ? token.encodeToUrlString() : null;
    }

    public static void setTokenStr(UserGroupInformation ugi, String tokenStr, String tokenService) throws IOException {
        Token<DelegationTokenIdentifier> delegationToken = SessionUtils.createToken(tokenStr, tokenService);
        ugi.addToken(delegationToken);
    }

    public static String addServiceToToken(String tokenStr, String tokenService) throws IOException {
        Token<DelegationTokenIdentifier> delegationToken = SessionUtils.createToken(tokenStr, tokenService);
        return delegationToken.encodeToUrlString();
    }

    private static Token<DelegationTokenIdentifier> createToken(String tokenStr, String tokenService) throws IOException {
        Token<DelegationTokenIdentifier> delegationToken = new Token<DelegationTokenIdentifier>();
        delegationToken.decodeFromUrlString(tokenStr);
        delegationToken.setService(new Text(tokenService));
        return delegationToken;
    }
}

