/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hplsql;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class File {
    Path path;
    FileSystem fs;
    FSDataInputStream in;
    FSDataOutputStream out;

    public FileSystem createFs() throws IOException {
        this.fs = FileSystem.get(new Configuration());
        return this.fs;
    }

    public FSDataOutputStream create(boolean overwrite) {
        try {
            if (this.fs == null) {
                this.fs = this.createFs();
            }
            this.out = this.fs.create(this.path, overwrite);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.out;
    }

    public FSDataOutputStream create(String dir, String file, boolean overwrite) {
        this.path = new Path(dir, file);
        return this.create(overwrite);
    }

    public FSDataOutputStream create(String file, boolean overwrite) {
        this.path = new Path(file);
        return this.create(overwrite);
    }

    public void open(String dir, String file) {
        this.path = new Path(dir, file);
        try {
            if (this.fs == null) {
                this.fs = this.createFs();
            }
            this.in = this.fs.open(this.path);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    boolean exists(String name) throws IOException {
        if (this.fs == null) {
            this.fs = this.createFs();
        }
        return this.fs.exists(new Path(name));
    }

    public char readChar() throws IOException {
        return this.in.readChar();
    }

    public void writeString(String str) {
        try {
            this.out.writeChars(str);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void close() {
        try {
            if (this.in != null) {
                this.in.close();
            }
            if (this.out != null) {
                this.out.close();
            }
            this.in = null;
            this.out = null;
            this.path = null;
            this.fs = null;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Path resolvePath(Path path) throws IOException {
        return this.fs.getFileStatus(path).getPath();
    }

    public String toString() {
        if (this.path != null) {
            return "FILE <" + this.path.toString() + ">";
        }
        return "FILE <null>";
    }
}

