/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authentication.util;

import java.util.Collections;
import java.util.List;
import javax.security.auth.login.Configuration;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.security.authentication.util.JaasConfiguration;
import org.apache.hive.org.apache.curator.RetryPolicy;
import org.apache.hive.org.apache.curator.framework.CuratorFramework;
import org.apache.hive.org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.hive.org.apache.curator.framework.api.ACLProvider;
import org.apache.hive.org.apache.curator.framework.imps.DefaultACLProvider;
import org.apache.hive.org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.hive.org.apache.curator.utils.ConfigurableZookeeperFactory;
import org.apache.hive.org.apache.curator.utils.ZookeeperFactory;
import org.apache.hive.org.apache.zookeeper.client.ZKClientConfig;
import org.apache.hive.org.apache.zookeeper.common.ClientX509Util;
import org.apache.hive.org.apache.zookeeper.data.ACL;
import org.apache.hive.org.apache.zookeeper.data.Id;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZookeeperClient {
    private static final Logger LOG = LoggerFactory.getLogger(ZookeeperClient.class);
    private String connectionString;
    private String namespace;
    private String authenticationType = "none";
    private String keytab;
    private String principal;
    private String jaasLoginEntryName;
    private int sessionTimeout = Integer.getInteger("curator-default-session-timeout", 60000);
    private int connectionTimeout = Integer.getInteger("curator-default-connection-timeout", 15000);
    private RetryPolicy retryPolicy = new ExponentialBackoffRetry(1000, 3);
    private ZookeeperFactory zkFactory = new ConfigurableZookeeperFactory();
    private boolean isSSLEnabled;
    private String keystoreLocation;
    private String keystorePassword;
    private String truststoreLocation;
    private String truststorePassword;

    public static ZookeeperClient configure() {
        return new ZookeeperClient();
    }

    public ZookeeperClient withConnectionString(String conn) {
        this.connectionString = conn;
        return this;
    }

    public ZookeeperClient withNamespace(String ns) {
        this.namespace = ns;
        return this;
    }

    public ZookeeperClient withAuthType(String authType) {
        this.authenticationType = authType;
        return this;
    }

    public ZookeeperClient withKeytab(String keytabPath) {
        this.keytab = keytabPath;
        return this;
    }

    public ZookeeperClient withPrincipal(String princ) {
        this.principal = princ;
        return this;
    }

    public ZookeeperClient withJaasLoginEntryName(String entryName) {
        this.jaasLoginEntryName = entryName;
        return this;
    }

    public ZookeeperClient withSessionTimeout(int timeoutMS) {
        this.sessionTimeout = timeoutMS;
        return this;
    }

    public ZookeeperClient withConnectionTimeout(int timeoutMS) {
        this.connectionTimeout = timeoutMS;
        return this;
    }

    public ZookeeperClient withRetryPolicy(RetryPolicy policy) {
        this.retryPolicy = policy;
        return this;
    }

    public ZookeeperClient withZookeeperFactory(ZookeeperFactory factory) {
        this.zkFactory = factory;
        return this;
    }

    public ZookeeperClient enableSSL(boolean enable) {
        this.isSSLEnabled = enable;
        return this;
    }

    public ZookeeperClient withKeystore(String keystorePath) {
        this.keystoreLocation = keystorePath;
        return this;
    }

    public ZookeeperClient withKeystorePassword(String keystorePass) {
        this.keystorePassword = keystorePass;
        return this;
    }

    public ZookeeperClient withTruststore(String truststorePath) {
        this.truststoreLocation = truststorePath;
        return this;
    }

    public ZookeeperClient withTruststorePassword(String truststorePass) {
        this.truststorePassword = truststorePass;
        return this;
    }

    public CuratorFramework create() {
        this.checkNotNull(this.connectionString, "Zookeeper connection string cannot be null!");
        this.checkNotNull(this.retryPolicy, "Zookeeper connection retry policy cannot be null!");
        return this.createFrameworkFactoryBuilder().connectString(this.connectionString).zookeeperFactory(this.zkFactory).namespace(this.namespace).sessionTimeoutMs(this.sessionTimeout).connectionTimeoutMs(this.connectionTimeout).retryPolicy(this.retryPolicy).aclProvider(this.aclProvider()).zkClientConfig(this.zkClientConfig()).build();
    }

    @VisibleForTesting
    CuratorFrameworkFactory.Builder createFrameworkFactoryBuilder() {
        return CuratorFrameworkFactory.builder();
    }

    private ACLProvider aclProvider() {
        ACLProvider aclProvider;
        this.checkNotNull(this.authenticationType, "Zookeeper authType cannot be null!");
        this.checkArgument(this.authenticationType.equals("sasl") || this.authenticationType.equals("none"), "Zookeeper authType must be one of [none, sasl]!");
        if (this.authenticationType.equals("sasl")) {
            LOG.info("Connecting to ZooKeeper with SASL/Kerberos and using 'sasl' ACLs.");
            this.checkArgument(!this.isEmpty(this.keytab), "Zookeeper client's Kerberos Keytab must be specified!");
            this.checkArgument(!this.isEmpty(this.principal), "Zookeeper client's Kerberos Principal must be specified!");
            this.checkArgument(!this.isEmpty(this.jaasLoginEntryName), "JAAS Login Entry name must be specified!");
            JaasConfiguration jConf = new JaasConfiguration(this.jaasLoginEntryName, this.principal, this.keytab);
            Configuration.setConfiguration(jConf);
            System.setProperty("zookeeper.sasl.clientconfig", this.jaasLoginEntryName);
            System.setProperty("zookeeper.authProvider.1", "org.apache.hive.org.apache.zookeeper.server.auth.SASLAuthenticationProvider");
            aclProvider = new SASLOwnerACLProvider(this.principal.split("[/@]")[0]);
        } else {
            LOG.info("Connecting to ZooKeeper without authentication.");
            aclProvider = new DefaultACLProvider();
        }
        return aclProvider;
    }

    private ZKClientConfig zkClientConfig() {
        ZKClientConfig zkClientConfig = new ZKClientConfig();
        if (this.isSSLEnabled) {
            LOG.info("Zookeeper client will use SSL connection. (keystore = {}; truststore = {};)", (Object)this.keystoreLocation, (Object)this.truststoreLocation);
            this.checkArgument(!this.isEmpty(this.keystoreLocation), "The keystore location parameter is empty for the ZooKeeper client connection.");
            this.checkArgument(!this.isEmpty(this.truststoreLocation), "The truststore location parameter is empty for the ZooKeeper client connection.");
            try (ClientX509Util sslOpts = new ClientX509Util();){
                zkClientConfig.setProperty("zookeeper.client.secure", "true");
                zkClientConfig.setProperty("zookeeper.clientCnxnSocket", "org.apache.hive.org.apache.zookeeper.ClientCnxnSocketNetty");
                zkClientConfig.setProperty(sslOpts.getSslKeystoreLocationProperty(), this.keystoreLocation);
                zkClientConfig.setProperty(sslOpts.getSslKeystorePasswdProperty(), this.keystorePassword);
                zkClientConfig.setProperty(sslOpts.getSslTruststoreLocationProperty(), this.truststoreLocation);
                zkClientConfig.setProperty(sslOpts.getSslTruststorePasswdProperty(), this.truststorePassword);
            }
        } else {
            LOG.info("Zookeeper client will use Plain connection.");
        }
        return zkClientConfig;
    }

    private boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    private void checkNotNull(Object reference, String errorMessage) {
        if (reference == null) {
            throw new NullPointerException(errorMessage);
        }
    }

    private void checkArgument(boolean expression, String errorMessage) {
        if (!expression) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    @VisibleForTesting
    static final class SASLOwnerACLProvider
    implements ACLProvider {
        private final List<ACL> saslACL;

        private SASLOwnerACLProvider(String principal) {
            this.saslACL = Collections.singletonList(new ACL(31, new Id("sasl", principal)));
        }

        @Override
        public List<ACL> getDefaultAcl() {
            return this.saslACL;
        }

        @Override
        public List<ACL> getAclForPath(String path) {
            return this.saslACL;
        }
    }
}

