/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.registry.server.integration;

import org.apache.hadoop.registry.client.types.RegistryPathStatus;
import org.apache.hadoop.registry.client.types.ServiceRecord;
import org.apache.hadoop.registry.server.services.RegistryAdminService;
import org.apache.hadoop.util.Preconditions;
import org.apache.hive.org.apache.commons.lang3.StringUtils;

public class SelectByYarnPersistence
implements RegistryAdminService.NodeSelector {
    private final String id;
    private final String targetPolicy;

    public SelectByYarnPersistence(String id, String targetPolicy) {
        Preconditions.checkArgument(!StringUtils.isEmpty(id), "id");
        Preconditions.checkArgument(!StringUtils.isEmpty(targetPolicy), "targetPolicy");
        this.id = id;
        this.targetPolicy = targetPolicy;
    }

    @Override
    public boolean shouldSelect(String path, RegistryPathStatus registryPathStatus, ServiceRecord serviceRecord) {
        String policy = serviceRecord.get("yarn:persistence", "");
        return this.id.equals(serviceRecord.get("yarn:id", "")) && this.targetPolicy.equals(policy);
    }

    public String toString() {
        return String.format("Select by ID %s and policy %s: {}", this.id, this.targetPolicy);
    }
}

