/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.registry.server.dns;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.PathNotFoundException;
import org.apache.hadoop.registry.client.api.DNSOperationsFactory;
import org.apache.hadoop.registry.client.api.RegistryOperations;
import org.apache.hadoop.registry.client.binding.RegistryPathUtils;
import org.apache.hadoop.registry.client.binding.RegistryUtils;
import org.apache.hadoop.registry.client.impl.zk.PathListener;
import org.apache.hadoop.registry.client.impl.zk.RegistryOperationsService;
import org.apache.hadoop.registry.client.types.RegistryPathStatus;
import org.apache.hadoop.registry.client.types.ServiceRecord;
import org.apache.hadoop.registry.conf.RegistryConfiguration;
import org.apache.hadoop.registry.server.dns.RegistryDNS;
import org.apache.hadoop.service.CompositeService;
import org.apache.hadoop.service.launcher.HadoopUncaughtExceptionHandler;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.util.GenericOptionsParser;
import org.apache.hadoop.util.Preconditions;
import org.apache.hadoop.util.ShutdownHookManager;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegistryDNSServer
extends CompositeService {
    public static final int SHUTDOWN_HOOK_PRIORITY = 30;
    private RegistryDNS registryDNS;
    private RegistryOperationsService registryOperations;
    private static final Logger LOG = LoggerFactory.getLogger(RegistryDNS.class);
    private ConcurrentMap<String, ServiceRecord> pathToRecordMap;
    private final ManagementCommand register = new ManagementCommand(){

        @Override
        public void exec(String path, ServiceRecord record) throws IOException {
            if (record != null) {
                LOG.info("Registering DNS records for {}", (Object)path);
                RegistryDNSServer.this.registryDNS.register(path, record);
            }
        }
    };
    private ManagementCommand delete = new ManagementCommand(){

        @Override
        public void exec(String path, ServiceRecord record) throws IOException {
            if (record != null) {
                LOG.info("Deleting DNS records for {}", (Object)path);
                RegistryDNSServer.this.registryDNS.delete(path, record);
            }
        }
    };

    public RegistryDNSServer(String name, RegistryDNS registryDNS) {
        super(name);
        this.registryDNS = registryDNS;
    }

    protected void serviceInit(Configuration conf) throws Exception {
        this.pathToRecordMap = new ConcurrentHashMap<String, ServiceRecord>();
        this.registryOperations = new RegistryOperationsService("RegistryDNSOperations");
        this.addService(this.registryOperations);
        if (this.registryDNS == null) {
            this.registryDNS = (RegistryDNS)DNSOperationsFactory.createInstance(conf);
        }
        this.addService(this.registryDNS);
        super.serviceInit(conf);
    }

    protected void serviceStart() throws Exception {
        super.serviceStart();
        this.manageRegistryDNS();
    }

    private void manageRegistryDNS() {
        try {
            this.registryOperations.instantiateCacheForRegistry();
            this.registryOperations.registerPathListener(new PathListener(){
                private String registryRoot;
                {
                    this.registryRoot = RegistryDNSServer.this.getConfig().get("hadoop.registry.zk.root", "/registry");
                }

                @Override
                public void nodeAdded(String path) throws IOException {
                    String relativePath = this.getPathRelativeToRegistryRoot(path);
                    String child = RegistryPathUtils.lastPathEntry(path);
                    HashMap<String, RegistryPathStatus> map = new HashMap<String, RegistryPathStatus>();
                    map.put(child, RegistryDNSServer.this.registryOperations.stat(relativePath));
                    Map<String, ServiceRecord> records = RegistryUtils.extractServiceRecords((RegistryOperations)RegistryDNSServer.this.registryOperations, this.getAdjustedParentPath(path), map);
                    RegistryDNSServer.this.processServiceRecords(records, RegistryDNSServer.this.register);
                    RegistryDNSServer.this.pathToRecordMap.putAll(records);
                }

                private String getAdjustedParentPath(String path) {
                    Preconditions.checkNotNull(path);
                    String adjustedPath = null;
                    adjustedPath = this.getPathRelativeToRegistryRoot(path);
                    try {
                        return RegistryPathUtils.parentOf(adjustedPath);
                    }
                    catch (PathNotFoundException e) {
                        return path;
                    }
                }

                private String getPathRelativeToRegistryRoot(String path) {
                    String adjustedPath = path.equals(this.registryRoot) ? "/" : path.substring(this.registryRoot.length());
                    return adjustedPath;
                }

                @Override
                public void nodeRemoved(String path) throws IOException {
                    ServiceRecord record = (ServiceRecord)RegistryDNSServer.this.pathToRecordMap.remove(path.substring(this.registryRoot.length()));
                    RegistryDNSServer.this.processServiceRecord(path, record, RegistryDNSServer.this.delete);
                }
            });
            this.registryOperations.startCache();
        }
        catch (Exception e) {
            LOG.warn("Unable to monitor the registry.  DNS support disabled.", e);
        }
    }

    private void processServiceRecords(Map<String, ServiceRecord> records, ManagementCommand command) throws IOException {
        for (Map.Entry<String, ServiceRecord> entry : records.entrySet()) {
            this.processServiceRecord(entry.getKey(), entry.getValue(), command);
        }
    }

    private void processServiceRecord(String path, ServiceRecord record, ManagementCommand command) throws IOException {
        command.exec(path, record);
    }

    static RegistryDNSServer launchDNSServer(Configuration conf, RegistryDNS rdns) {
        RegistryDNSServer dnsServer = null;
        Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new HadoopUncaughtExceptionHandler());
        try {
            dnsServer = new RegistryDNSServer("RegistryDNSServer", rdns);
            ShutdownHookManager.get().addShutdownHook((Runnable)new CompositeService.CompositeServiceShutdownHook((CompositeService)dnsServer), 30);
            dnsServer.init(conf);
            dnsServer.start();
        }
        catch (Throwable t2) {
            LOG.error("Error starting Registry DNS Server", t2);
            ExitUtil.terminate(-1, "Error starting Registry DNS Server");
        }
        return dnsServer;
    }

    public static void main(String[] args) throws IOException {
        StringUtils.startupShutdownMessage(RegistryDNSServer.class, args, LOG);
        RegistryConfiguration conf = new RegistryConfiguration();
        new GenericOptionsParser(conf, args);
        RegistryDNSServer.launchDNSServer(conf, null);
    }

    static interface ManagementCommand {
        public void exec(String var1, ServiceRecord var2) throws IOException;
    }
}

