/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.io;

import org.apache.hadoop.hive.common.type.HiveBaseChar;
import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.apache.hadoop.hive.serde2.io.HiveBaseCharWritable;
import org.apache.hadoop.io.WritableComparable;

public class HiveVarcharWritable
extends HiveBaseCharWritable
implements WritableComparable<HiveVarcharWritable> {
    public HiveVarcharWritable() {
    }

    public HiveVarcharWritable(HiveVarchar hc) {
        this.set(hc);
    }

    public HiveVarcharWritable(HiveVarcharWritable hcw) {
        this.set(hcw);
    }

    public HiveVarcharWritable(byte[] bytes, int maxLength) {
        this.set(bytes, maxLength);
    }

    public void set(byte[] bytes, int maxLength) {
        this.value.set(bytes);
        this.enforceMaxLength(maxLength);
    }

    public void set(HiveVarchar val) {
        this.set(val.getValue());
    }

    public void set(String val) {
        this.set(val, -1);
    }

    public void set(HiveVarcharWritable val) {
        this.value.set(val.value);
        this.charLength = val.charLength;
    }

    public void set(HiveVarcharWritable val, int maxLength) {
        this.set(val.getHiveVarchar(), maxLength);
    }

    public void set(HiveVarchar val, int len) {
        this.set(val.getValue(), len);
    }

    public void set(String val, int maxLength) {
        this.value.set(HiveBaseChar.enforceMaxLength(val, maxLength));
        this.charLength = maxLength;
    }

    public HiveVarchar getHiveVarchar() {
        return new HiveVarchar(this.value.toString(), -1);
    }

    public void enforceMaxLength(int maxLength) {
        if (this.getCharacterLength() > maxLength) {
            this.set(this.value.toString(), maxLength);
        }
    }

    @Override
    public int compareTo(HiveVarcharWritable rhs) {
        return this.value.compareTo(rhs.value);
    }

    public String toString() {
        return this.value.toString();
    }
}

