/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.type.Date;
import org.apache.hadoop.hive.common.type.HiveChar;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.serde2.AbstractEncodingAwareSerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeSpec;
import org.apache.hadoop.hive.serde2.SerDeUtils;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveJavaObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.CharTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.VarcharTypeInfo;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hive.com.google.common.base.Splitter;
import org.apache.hive.com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SerDeSpec(schemaProps={"columns", "columns.types", "serialization.encoding", "input.regex", "input.regex.case.insensitive"})
public class RegexSerDe
extends AbstractEncodingAwareSerDe {
    private static final Logger LOG = LoggerFactory.getLogger(RegexSerDe.class);
    public static final String INPUT_REGEX = "input.regex";
    public static final String INPUT_REGEX_CASE_SENSITIVE = "input.regex.case.insensitive";
    int numColumns;
    String inputRegex;
    Pattern inputPattern;
    StructObjectInspector rowOI;
    List<Object> row;
    Object[] outputFields;
    Text outputRowText;
    boolean alreadyLoggedNoMatch = false;
    boolean alreadyLoggedPartialMatch = false;
    long unmatchedRowsCount = 0L;
    long partialMatchedRowsCount = 0L;

    @Override
    public void initialize(Configuration configuration, Properties tableProperties, Properties partitionProperties) throws SerDeException {
        super.initialize(configuration, tableProperties, partitionProperties);
        this.numColumns = this.getColumnNames().size();
        this.inputRegex = this.properties.getProperty(INPUT_REGEX);
        boolean inputRegexIgnoreCase = "true".equalsIgnoreCase(this.properties.getProperty(INPUT_REGEX_CASE_SENSITIVE));
        if (null != this.properties.getProperty("output.format.string")) {
            LOG.warn("output.format.string has been deprecated");
        }
        if (this.inputRegex == null) {
            this.inputPattern = null;
            throw new SerDeException("This table does not have serde property \"input.regex\"!");
        }
        this.inputPattern = Pattern.compile(this.inputRegex, 32 + (inputRegexIgnoreCase ? 2 : 0));
        ArrayList<ObjectInspector> columnOIs = new ArrayList<ObjectInspector>(this.getColumnNames().size());
        for (int c = 0; c < this.numColumns; ++c) {
            TypeInfo typeInfo = this.getColumnTypes().get(c);
            if (!(typeInfo instanceof PrimitiveTypeInfo)) {
                throw new SerDeException(this.getClass().getName() + " doesn't allow column [" + c + "] named " + this.getColumnNames().get(c) + " with type " + String.valueOf(typeInfo));
            }
            PrimitiveTypeInfo pti = (PrimitiveTypeInfo)typeInfo;
            AbstractPrimitiveJavaObjectInspector oi = PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector(pti);
            columnOIs.add(oi);
        }
        this.rowOI = ObjectInspectorFactory.getStandardStructObjectInspector(this.getColumnNames(), columnOIs, Lists.newArrayList(Splitter.on('\u0000').split(this.properties.getProperty("columns.comments"))));
        this.row = new ArrayList<Object>(Collections.nCopies(this.numColumns, null));
        this.outputFields = new Object[this.numColumns];
        this.outputRowText = new Text();
    }

    @Override
    public ObjectInspector getObjectInspector() throws SerDeException {
        return this.rowOI;
    }

    @Override
    public Class<? extends Writable> getSerializedClass() {
        return Text.class;
    }

    @Override
    public Object doDeserialize(Writable blob) throws SerDeException {
        Text rowText = (Text)blob;
        Matcher m4 = this.inputPattern.matcher(rowText.toString());
        if (m4.groupCount() != this.numColumns) {
            throw new SerDeException("Number of matching groups doesn't match the number of columns");
        }
        if (!m4.matches()) {
            ++this.unmatchedRowsCount;
            if (!this.alreadyLoggedNoMatch) {
                LOG.warn(this.unmatchedRowsCount + " unmatched rows are found: " + String.valueOf(rowText));
                this.alreadyLoggedNoMatch = true;
            }
            return null;
        }
        for (int c = 0; c < this.numColumns; ++c) {
            try {
                String t2 = m4.group(c + 1);
                TypeInfo typeInfo = this.getColumnTypes().get(c);
                PrimitiveTypeInfo pti = (PrimitiveTypeInfo)typeInfo;
                switch (pti.getPrimitiveCategory()) {
                    case STRING: {
                        this.row.set(c, t2);
                        break;
                    }
                    case BYTE: {
                        Byte b = Byte.valueOf(t2);
                        this.row.set(c, b);
                        break;
                    }
                    case SHORT: {
                        Short s2 = Short.valueOf(t2);
                        this.row.set(c, s2);
                        break;
                    }
                    case INT: {
                        Integer i = Integer.valueOf(t2);
                        this.row.set(c, i);
                        break;
                    }
                    case LONG: {
                        Long l = Long.valueOf(t2);
                        this.row.set(c, l);
                        break;
                    }
                    case FLOAT: {
                        Float f = Float.valueOf(t2);
                        this.row.set(c, f);
                        break;
                    }
                    case DOUBLE: {
                        Double d = Double.valueOf(t2);
                        this.row.set(c, d);
                        break;
                    }
                    case BOOLEAN: {
                        Boolean bool = Boolean.valueOf(t2);
                        this.row.set(c, bool);
                        break;
                    }
                    case TIMESTAMP: {
                        Timestamp ts = Timestamp.valueOf(t2);
                        this.row.set(c, ts);
                        break;
                    }
                    case DATE: {
                        Date date = Date.valueOf(t2);
                        this.row.set(c, date);
                        break;
                    }
                    case DECIMAL: {
                        HiveDecimal bd = HiveDecimal.create(t2);
                        this.row.set(c, bd);
                        break;
                    }
                    case CHAR: {
                        HiveChar hc = new HiveChar(t2, ((CharTypeInfo)typeInfo).getLength());
                        this.row.set(c, hc);
                        break;
                    }
                    case VARCHAR: {
                        HiveVarchar hv = new HiveVarchar(t2, ((VarcharTypeInfo)typeInfo).getLength());
                        this.row.set(c, hv);
                        break;
                    }
                    default: {
                        throw new SerDeException("Unsupported type " + String.valueOf(typeInfo));
                    }
                }
                continue;
            }
            catch (RuntimeException e) {
                ++this.partialMatchedRowsCount;
                if (!this.alreadyLoggedPartialMatch) {
                    LOG.warn(this.partialMatchedRowsCount + " partially unmatched rows are found,  cannot find group " + c + ": " + String.valueOf(rowText));
                    this.alreadyLoggedPartialMatch = true;
                }
                this.row.set(c, null);
            }
        }
        return this.row;
    }

    @Override
    public Writable doSerialize(Object obj, ObjectInspector objInspector) throws SerDeException {
        throw new UnsupportedOperationException("Regex SerDe doesn't support the serialize() method");
    }

    @Override
    protected Writable transformFromUTF8(Writable blob) {
        Text text = (Text)blob;
        return SerDeUtils.transformTextFromUTF8(text, this.charset);
    }

    @Override
    protected Writable transformToUTF8(Writable blob) {
        Text text = (Text)blob;
        return SerDeUtils.transformTextToUTF8(text, this.charset);
    }
}

