/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.registry.impl;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.registry.impl.LlapRegistryService;
import org.apache.hadoop.hive.registry.impl.TezAmInstance;
import org.apache.hadoop.hive.registry.impl.ZkRegistryBase;
import org.apache.hadoop.registry.client.binding.RegistryTypeUtils;
import org.apache.hadoop.registry.client.types.Endpoint;
import org.apache.hadoop.registry.client.types.ServiceRecord;
import org.apache.hive.org.apache.commons.lang3.StringUtils;
import org.apache.hive.org.apache.curator.framework.recipes.cache.PathChildrenCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TezAmRegistryImpl
extends ZkRegistryBase<TezAmInstance> {
    private static final Logger LOG = LoggerFactory.getLogger(TezAmRegistryImpl.class);
    static final String IPC_TEZCLIENT = "tez-client";
    static final String IPC_PLUGIN = "llap-plugin";
    static final String AM_SESSION_ID = "am.session.id";
    static final String AM_PLUGIN_TOKEN = "am.plugin.token";
    static final String AM_PLUGIN_JOBID = "am.plugin.jobid";
    static final String AM_GUARANTEED_COUNT = "am.guaranteed.count";
    private static final String NAMESPACE_PREFIX = "tez-am-";
    private static final String SASL_LOGIN_CONTEXT_NAME = "TezAmZooKeeperClient";
    private final String registryName;
    private ServiceRecord srv;

    public static TezAmRegistryImpl create(Configuration conf, boolean useSecureZk) {
        String amRegistryName = HiveConf.getVar(conf, HiveConf.ConfVars.LLAP_TASK_SCHEDULER_AM_REGISTRY_NAME);
        return StringUtils.isBlank(amRegistryName) ? null : new TezAmRegistryImpl(amRegistryName, conf, useSecureZk);
    }

    private TezAmRegistryImpl(String instanceName, Configuration conf, boolean useSecureZk) {
        super(instanceName, conf, null, NAMESPACE_PREFIX, "user-", "worker-", "workers", useSecureZk ? SASL_LOGIN_CONTEXT_NAME : null, HiveConf.getVar(conf, HiveConf.ConfVars.LLAP_TASK_SCHEDULER_AM_REGISTRY_PRINCIPAL), HiveConf.getVar(conf, HiveConf.ConfVars.LLAP_TASK_SCHEDULER_AM_REGISTRY_KEYTAB_FILE), null);
        this.registryName = instanceName;
        LOG.info("AM Zookeeper Registry is enabled with registryid: " + instanceName);
    }

    public void initializeWithoutRegistering() throws IOException {
        this.initializeWithoutRegisteringInternal();
    }

    public void populateCache(boolean doInvokeListeners) throws IOException {
        PathChildrenCache pcc = this.ensureInstancesCache(0L);
        this.populateCache(pcc, doInvokeListeners);
    }

    public String register(int amPort, int pluginPort, String sessionId, String serializedToken, String jobIdForToken, int guaranteedCount) throws IOException {
        if (this.srv != null) {
            throw new UnsupportedOperationException("Already registered with " + String.valueOf(this.srv));
        }
        this.srv = new ServiceRecord();
        Endpoint rpcEndpoint = RegistryTypeUtils.ipcEndpoint(IPC_TEZCLIENT, new InetSocketAddress(hostname, amPort));
        this.srv.addInternalEndpoint(rpcEndpoint);
        Endpoint pluginEndpoint = null;
        if (pluginPort >= 0) {
            pluginEndpoint = RegistryTypeUtils.ipcEndpoint(IPC_PLUGIN, new InetSocketAddress(hostname, pluginPort));
            this.srv.addInternalEndpoint(pluginEndpoint);
        }
        this.srv.set(AM_SESSION_ID, sessionId);
        boolean hasToken = serializedToken != null;
        this.srv.set(AM_PLUGIN_TOKEN, hasToken ? serializedToken : "");
        this.srv.set(AM_PLUGIN_JOBID, jobIdForToken != null ? jobIdForToken : "");
        this.srv.set(AM_GUARANTEED_COUNT, Integer.toString(guaranteedCount));
        String uniqueId = this.registerServiceRecord(this.srv);
        LOG.info("Registered this AM: rpc: {}, plugin: {}, sessionId: {}, token: {}, znodePath: {}", rpcEndpoint, pluginEndpoint, sessionId, hasToken, this.getRegistrationZnodePath());
        return uniqueId;
    }

    public void updateGuaranteed(int guaranteedCount) throws IOException {
        this.srv.set(AM_GUARANTEED_COUNT, Integer.toString(guaranteedCount));
        this.updateServiceRecord(this.srv, false, false);
    }

    public TezAmInstance getInstance(String name) {
        Collection instances = this.getAllInternal();
        for (TezAmInstance instance : instances) {
            if (!instance.getWorkerIdentity().equals(name)) continue;
            return instance;
        }
        return null;
    }

    @Override
    protected TezAmInstance createServiceInstance(ServiceRecord srv) throws IOException {
        return new TezAmInstance(srv);
    }

    @Override
    protected String getZkPathUser(Configuration conf) {
        return LlapRegistryService.currentUser();
    }

    public String getRegistryName() {
        return this.registryName;
    }
}

