/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.type.HiveChar;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.apache.hadoop.hive.llap.FieldDesc;
import org.apache.hadoop.hive.llap.Row;
import org.apache.hadoop.hive.llap.Schema;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.lazybinary.LazyBinarySerDe;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hive.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LlapRowRecordReader
implements RecordReader<NullWritable, Row> {
    private static final Logger LOG = LoggerFactory.getLogger(LlapRowRecordReader.class);
    protected final Configuration conf;
    protected final RecordReader reader;
    protected final Schema schema;
    protected final AbstractSerDe serde;
    protected final Writable data;

    public LlapRowRecordReader(Configuration conf, Schema schema, RecordReader<NullWritable, ? extends Writable> reader) throws IOException {
        this.conf = conf;
        this.schema = schema;
        this.reader = reader;
        this.data = (Writable)reader.createValue();
        try {
            this.serde = this.initSerDe(conf);
        }
        catch (SerDeException err) {
            throw new IOException(err);
        }
    }

    public void close() throws IOException {
        this.reader.close();
    }

    public NullWritable createKey() {
        return NullWritable.get();
    }

    public Row createValue() {
        return new Row(this.schema);
    }

    public long getPos() throws IOException {
        return 0L;
    }

    public float getProgress() throws IOException {
        return 0.0f;
    }

    public boolean next(NullWritable key, Row value) throws IOException {
        Preconditions.checkArgument(value != null);
        boolean hasNext = this.reader.next((Object)key, (Object)this.data);
        if (hasNext) {
            try {
                StructObjectInspector rowOI = (StructObjectInspector)this.serde.getObjectInspector();
                Object rowObj = this.serde.deserialize(this.data);
                LlapRowRecordReader.setRowFromStruct(value, rowObj, rowOI);
            }
            catch (SerDeException err) {
                LOG.debug("Error deserializing row from data: {}", (Object)this.data);
                throw new IOException("Error deserializing row data", err);
            }
        }
        return hasNext;
    }

    public Schema getSchema() {
        return this.schema;
    }

    static Object convertPrimitive(Object val, PrimitiveObjectInspector poi) {
        switch (poi.getPrimitiveCategory()) {
            case CHAR: {
                return ((HiveChar)poi.getPrimitiveJavaObject(val)).getPaddedValue();
            }
            case VARCHAR: {
                return ((HiveVarchar)poi.getPrimitiveJavaObject(val)).toString();
            }
            case DECIMAL: {
                return ((HiveDecimal)poi.getPrimitiveJavaObject(val)).bigDecimalValue();
            }
        }
        return poi.getPrimitiveJavaObject(val);
    }

    static Object convertValue(Object val, ObjectInspector oi) {
        if (val == null) {
            return null;
        }
        Cloneable convertedVal = null;
        ObjectInspector.Category oiCategory = oi.getCategory();
        switch (oiCategory) {
            case PRIMITIVE: {
                convertedVal = LlapRowRecordReader.convertPrimitive(val, (PrimitiveObjectInspector)oi);
                break;
            }
            case LIST: {
                ListObjectInspector loi = (ListObjectInspector)oi;
                int listSize = loi.getListLength(val);
                if (listSize < 0) {
                    return null;
                }
                ArrayList<Object> convertedList = new ArrayList<Object>(listSize);
                ObjectInspector listElementOI = loi.getListElementObjectInspector();
                for (int idx = 0; idx < listSize; ++idx) {
                    convertedList.add(LlapRowRecordReader.convertValue(loi.getListElement(val, idx), listElementOI));
                }
                convertedVal = convertedList;
                break;
            }
            case MAP: {
                MapObjectInspector moi = (MapObjectInspector)oi;
                int mapSize = moi.getMapSize(val);
                if (mapSize < 0) {
                    return null;
                }
                LinkedHashMap<Object, Object> convertedMap = new LinkedHashMap<Object, Object>(mapSize);
                ObjectInspector mapKeyOI = moi.getMapKeyObjectInspector();
                ObjectInspector mapValOI = moi.getMapValueObjectInspector();
                Map<?, ?> mapCol = moi.getMap(val);
                for (Object mapKey : mapCol.keySet()) {
                    Object convertedMapKey = LlapRowRecordReader.convertValue(mapKey, mapKeyOI);
                    Object object = LlapRowRecordReader.convertValue(mapCol.get(mapKey), mapValOI);
                    convertedMap.put(convertedMapKey, object);
                }
                convertedVal = convertedMap;
                break;
            }
            case STRUCT: {
                StructObjectInspector soi = (StructObjectInspector)oi;
                ArrayList<Object> convertedRow = new ArrayList<Object>();
                for (StructField structField : soi.getAllStructFieldRefs()) {
                    Object convertedFieldValue = LlapRowRecordReader.convertValue(soi.getStructFieldData(val, structField), structField.getFieldObjectInspector());
                    convertedRow.add(convertedFieldValue);
                }
                convertedVal = convertedRow;
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot convert type " + String.valueOf((Object)oiCategory));
            }
        }
        return convertedVal;
    }

    protected static void setRowFromStruct(Row row, Object structVal, StructObjectInspector soi) {
        Schema structSchema = row.getSchema();
        List<? extends StructField> structFields = soi.getAllStructFieldRefs();
        for (int idx = 0; idx < structFields.size(); ++idx) {
            StructField structField = structFields.get(idx);
            Object convertedFieldValue = LlapRowRecordReader.convertValue(soi.getStructFieldData(structVal, structField), structField.getFieldObjectInspector());
            row.setValue(idx, convertedFieldValue);
        }
    }

    protected AbstractSerDe createSerDe() throws SerDeException {
        return new LazyBinarySerDe();
    }

    protected AbstractSerDe initSerDe(Configuration conf) throws SerDeException {
        Properties props = new Properties();
        StringBuilder columnsBuffer = new StringBuilder();
        StringBuilder typesBuffer = new StringBuilder();
        boolean isFirst = true;
        for (FieldDesc colDesc : this.schema.getColumns()) {
            if (!isFirst) {
                columnsBuffer.append(',');
                typesBuffer.append(',');
            }
            columnsBuffer.append(colDesc.getName());
            typesBuffer.append(colDesc.getTypeInfo().toString());
            isFirst = false;
        }
        String columns = columnsBuffer.toString();
        String types = typesBuffer.toString();
        props.put("columns", columns);
        props.put("columns.types", types);
        props.put("escape.delim", "\\");
        AbstractSerDe createdSerDe = this.createSerDe();
        createdSerDe.initialize(conf, props, null);
        return createdSerDe;
    }
}

