/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.rfile;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.impl.BaseIteratorEnvironment;
import org.apache.accumulo.core.client.impl.ScannerOptions;
import org.apache.accumulo.core.client.rfile.RFileScannerBuilder;
import org.apache.accumulo.core.client.rfile.RFileSource;
import org.apache.accumulo.core.client.sample.SamplerConfiguration;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.ConfigurationCopy;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Column;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.file.blockfile.cache.BlockCache;
import org.apache.accumulo.core.file.blockfile.cache.CacheEntry;
import org.apache.accumulo.core.file.blockfile.cache.LruBlockCache;
import org.apache.accumulo.core.file.blockfile.impl.CachableBlockFile;
import org.apache.accumulo.core.file.rfile.RFile;
import org.apache.accumulo.core.iterators.IteratorAdapter;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.iterators.system.MultiIterator;
import org.apache.accumulo.core.sample.impl.SamplerConfigurationImpl;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.util.LocalityGroupUtil;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.io.Text;

class RFileScanner
extends ScannerOptions
implements Scanner {
    private static final byte[] EMPTY_BYTES = new byte[0];
    private static final Range EMPTY_RANGE = new Range();
    private Range range;
    private BlockCache dataCache = null;
    private BlockCache indexCache = null;
    private Opts opts;
    private int batchSize = 1000;
    private long readaheadThreshold = 3L;
    private static final long CACHE_BLOCK_SIZE = AccumuloConfiguration.getDefaultConfiguration().getMemoryInBytes(Property.TSERV_DEFAULT_BLOCKSIZE);
    private static final EnumSet<LruBlockCache.Options> CACHE_OPTS;

    RFileScanner(Opts opts) {
        if (!opts.auths.equals(Authorizations.EMPTY) && !opts.useSystemIterators) {
            throw new IllegalArgumentException("Set authorizations and specified not to use system iterators");
        }
        this.opts = opts;
        this.indexCache = opts.indexCacheSize > 0L ? new LruBlockCache(opts.indexCacheSize, CACHE_BLOCK_SIZE, CACHE_OPTS) : new NoopCache();
        this.dataCache = opts.dataCacheSize > 0L ? new LruBlockCache(opts.dataCacheSize, CACHE_BLOCK_SIZE, CACHE_OPTS) : new NoopCache();
    }

    @Override
    public synchronized void fetchColumnFamily(Text col) {
        Preconditions.checkArgument((boolean)this.opts.useSystemIterators, (Object)"Can only fetch columns when using system iterators");
        super.fetchColumnFamily(col);
    }

    @Override
    public synchronized void fetchColumn(Text colFam, Text colQual) {
        Preconditions.checkArgument((boolean)this.opts.useSystemIterators, (Object)"Can only fetch columns when using system iterators");
        super.fetchColumn(colFam, colQual);
    }

    @Override
    public void fetchColumn(IteratorSetting.Column column) {
        Preconditions.checkArgument((boolean)this.opts.useSystemIterators, (Object)"Can only fetch columns when using system iterators");
        super.fetchColumn(column);
    }

    @Override
    public void setClassLoaderContext(String classLoaderContext) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void setTimeOut(int timeOut) {
        if (timeOut == Integer.MAX_VALUE) {
            this.setTimeout(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        } else {
            this.setTimeout(timeOut, TimeUnit.SECONDS);
        }
    }

    @Override
    @Deprecated
    public int getTimeOut() {
        long timeout = this.getTimeout(TimeUnit.SECONDS);
        if (timeout >= Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)timeout;
    }

    @Override
    public void setRange(Range range) {
        this.range = range;
    }

    @Override
    public Range getRange() {
        return this.range;
    }

    @Override
    public void setBatchSize(int size) {
        this.batchSize = size;
    }

    @Override
    public int getBatchSize() {
        return this.batchSize;
    }

    @Override
    public void enableIsolation() {
    }

    @Override
    public void disableIsolation() {
    }

    @Override
    public synchronized void setReadaheadThreshold(long batches) {
        Preconditions.checkArgument((batches > 0L ? 1 : 0) != 0);
        this.readaheadThreshold = batches;
    }

    @Override
    public synchronized long getReadaheadThreshold() {
        return this.readaheadThreshold;
    }

    @Override
    public Authorizations getAuthorizations() {
        return this.opts.auths;
    }

    @Override
    public void addScanIterator(IteratorSetting cfg) {
        super.addScanIterator(cfg);
    }

    @Override
    public void removeScanIterator(String iteratorName) {
        super.removeScanIterator(iteratorName);
    }

    @Override
    public void updateScanIteratorOption(String iteratorName, String key, String value) {
        super.updateScanIteratorOption(iteratorName, key, value);
    }

    @Override
    public Iterator<Map.Entry<Key, Value>> iterator() {
        try {
            int i;
            RFileSource[] sources = this.opts.in.getSources();
            ArrayList<SortedKeyValueIterator<Key, Value>> readers = new ArrayList<SortedKeyValueIterator<Key, Value>>(sources.length);
            for (i = 0; i < sources.length; ++i) {
                FSDataInputStream inputStream = (FSDataInputStream)sources[i].getInputStream();
                readers.add(new RFile.Reader(new CachableBlockFile.Reader("source-" + i, inputStream, sources[i].getLength(), this.opts.in.getConf(), this.dataCache, this.indexCache, AccumuloConfiguration.getDefaultConfiguration())));
            }
            if (this.getSamplerConfiguration() != null) {
                for (i = 0; i < readers.size(); ++i) {
                    readers.set(i, ((RFile.Reader)readers.get(i)).getSample(new SamplerConfigurationImpl(this.getSamplerConfiguration())));
                }
            }
            SortedKeyValueIterator<Key, Value> iterator = this.opts.bounds != null ? new MultiIterator(readers, this.opts.bounds) : new MultiIterator(readers, false);
            Set<ByteSequence> families = Collections.emptySet();
            if (this.opts.useSystemIterators) {
                SortedSet<Column> cols = this.getFetchedColumns();
                families = LocalityGroupUtil.families(cols);
                iterator = IteratorUtil.setupSystemScanIterators(iterator, cols, this.getAuthorizations(), EMPTY_BYTES);
            }
            try {
                if (this.opts.tableConfig != null && this.opts.tableConfig.size() > 0) {
                    ConfigurationCopy conf = new ConfigurationCopy(this.opts.tableConfig);
                    iterator = IteratorUtil.loadIterators(IteratorUtil.IteratorScope.scan, iterator, null, conf, this.serverSideIteratorList, this.serverSideIteratorOptions, new IterEnv());
                } else {
                    iterator = IteratorUtil.loadIterators(iterator, this.serverSideIteratorList, this.serverSideIteratorOptions, new IterEnv(), false, null);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            iterator.seek(this.getRange() == null ? EMPTY_RANGE : this.getRange(), families, families.size() != 0);
            return new IteratorAdapter(iterator);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        if (this.dataCache instanceof LruBlockCache) {
            ((LruBlockCache)this.dataCache).shutdown();
        }
        if (this.indexCache instanceof LruBlockCache) {
            ((LruBlockCache)this.indexCache).shutdown();
        }
        try {
            for (RFileSource source : this.opts.in.getSources()) {
                source.getInputStream().close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        EnumSet<LruBlockCache.Options> cacheOpts = EnumSet.allOf(LruBlockCache.Options.class);
        cacheOpts.remove((Object)LruBlockCache.Options.ENABLE_LOCKS);
        CACHE_OPTS = cacheOpts;
    }

    private class IterEnv
    extends BaseIteratorEnvironment {
        private IterEnv() {
        }

        @Override
        public IteratorUtil.IteratorScope getIteratorScope() {
            return IteratorUtil.IteratorScope.scan;
        }

        @Override
        public boolean isFullMajorCompaction() {
            return false;
        }

        @Override
        public Authorizations getAuthorizations() {
            return ((RFileScanner)RFileScanner.this).opts.auths;
        }

        @Override
        public boolean isSamplingEnabled() {
            return RFileScanner.this.getSamplerConfiguration() != null;
        }

        @Override
        public SamplerConfiguration getSamplerConfiguration() {
            return RFileScanner.this.getSamplerConfiguration();
        }
    }

    private static class NoopCache
    implements BlockCache {
        private NoopCache() {
        }

        @Override
        public CacheEntry cacheBlock(String blockName, byte[] buf, boolean inMemory) {
            return null;
        }

        @Override
        public CacheEntry cacheBlock(String blockName, byte[] buf) {
            return null;
        }

        @Override
        public CacheEntry getBlock(String blockName) {
            return null;
        }

        @Override
        public CacheEntry getBlockNoStats(String blockName) {
            return null;
        }

        @Override
        public long getMaxSize() {
            return Integer.MAX_VALUE;
        }

        @Override
        public Lock getLoadLock(String blockName) {
            return null;
        }
    }

    static class Opts {
        RFileScannerBuilder.InputArgs in;
        Authorizations auths = Authorizations.EMPTY;
        long dataCacheSize;
        long indexCacheSize;
        boolean useSystemIterators = true;
        public HashMap<String, String> tableConfig;
        Range bounds;

        Opts() {
        }
    }
}

