/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.http;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcJarDownloadServlet
extends HttpServlet {
    private static final Logger LOG = LoggerFactory.getLogger(JdbcJarDownloadServlet.class);
    private static final String JDBC_JAR_DIR = System.getenv("HIVE_HOME") + "/jdbc/";
    private static final String JDBC_JAR_PATTERN = "hive-jdbc-*-standalone.jar";
    private static final String JAR_CONTENT_DISPOSITION = "attachment; filename=hive-jdbc-standalone.jar";
    private static final String JAR_CONTENT_TYPE = "application/java-archive";

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOG.info("Requesting jdbc standalone jar download");
        response.setHeader("Content-disposition", JAR_CONTENT_DISPOSITION);
        response.setContentType(JAR_CONTENT_TYPE);
        File dir = new File(JDBC_JAR_DIR);
        WildcardFileFilter fileFilter = new WildcardFileFilter(JDBC_JAR_PATTERN);
        File[] files = dir.listFiles((FileFilter)fileFilter);
        if (files == null || files.length != 1) {
            this.handleError(files);
            response.sendError(404);
            return;
        }
        File file = files[0];
        LOG.info("Jdbc standalone jar found: " + file.getAbsolutePath());
        try (FileInputStream in = new FileInputStream(file);
             ServletOutputStream out = response.getOutputStream();){
            int length;
            byte[] buffer = new byte[4096];
            while ((length = in.read(buffer)) > 0) {
                out.write(buffer, 0, length);
            }
        }
        catch (Exception e) {
            LOG.error("Exception during downloading standalone jdbc jar", (Throwable)e);
            response.sendError(404);
        }
        LOG.info("Jdbc standalone jar " + file.getAbsolutePath() + " was downloaded");
    }

    private void handleError(File[] files) {
        if (ArrayUtils.isEmpty((Object[])files)) {
            LOG.error("No jdbc standalone jar found in the directory " + JDBC_JAR_DIR);
        } else {
            StringBuilder fileNames = new StringBuilder();
            for (File file : files) {
                fileNames.append("\t" + file.getAbsolutePath() + "\n");
            }
            LOG.error("Multiple jdbc standalone jars exist in the directory " + JDBC_JAR_DIR + ":\n" + String.valueOf(fileNames));
        }
    }
}

