/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.atlas.model.annotation.AtlasJSON;

@AtlasJSON
public abstract class AtlasBaseModelObject
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonIgnore
    private static AtomicLong s_nextId = new AtomicLong(System.nanoTime());
    private String guid;

    protected void init() {
        this.setGuid("-" + Long.toString(s_nextId.incrementAndGet()));
    }

    protected AtlasBaseModelObject() {
        this.init();
    }

    public String getGuid() {
        return this.guid;
    }

    public void setGuid(String guid) {
        this.guid = guid;
    }

    public AtlasBaseModelObject(AtlasBaseModelObject other) {
        this.guid = other.guid;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("{");
        sb.append("guid=").append(this.guid);
        this.toString(sb);
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AtlasBaseModelObject)) {
            return false;
        }
        AtlasBaseModelObject that = (AtlasBaseModelObject)o;
        return Objects.equals(this.guid, that.guid);
    }

    public int hashCode() {
        return Objects.hash(this.guid);
    }

    protected abstract StringBuilder toString(StringBuilder var1);
}

