/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.pig;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hive.hcatalog.data.HCatRecord;
import org.apache.hive.hcatalog.data.schema.HCatSchema;
import org.apache.hive.hcatalog.mapreduce.InputJobInfo;
import org.apache.hive.hcatalog.mapreduce.PartInfo;
import org.apache.hive.hcatalog.pig.PigHCatUtil;
import org.apache.pig.LoadFunc;
import org.apache.pig.LoadMetadata;
import org.apache.pig.LoadPushDown;
import org.apache.pig.ResourceStatistics;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigSplit;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.util.UDFContext;

abstract class HCatBaseLoader
extends LoadFunc
implements LoadMetadata,
LoadPushDown {
    protected static final String PRUNE_PROJECTION_INFO = "prune.projection.info";
    private RecordReader<?, ?> reader;
    protected String signature;
    HCatSchema outputSchema = null;

    HCatBaseLoader() {
    }

    public Tuple getNext() throws IOException {
        try {
            HCatRecord hr = (HCatRecord)(this.reader.nextKeyValue() ? this.reader.getCurrentValue() : null);
            Tuple t = PigHCatUtil.transformToTuple(hr, this.outputSchema);
            return t;
        }
        catch (ExecException e) {
            int errCode = 6018;
            String errMsg = "Error while reading input";
            throw new ExecException(errMsg, errCode, 16, (Throwable)e);
        }
        catch (Exception eOther) {
            int errCode = 6018;
            String errMsg = "Error converting read value to tuple";
            throw new ExecException(errMsg, errCode, 16, (Throwable)eOther);
        }
    }

    public void prepareToRead(RecordReader reader, PigSplit arg1) throws IOException {
        this.reader = reader;
    }

    public ResourceStatistics getStatistics(String location, Job job) throws IOException {
        return null;
    }

    public List<LoadPushDown.OperatorSet> getFeatures() {
        return Arrays.asList(LoadPushDown.OperatorSet.PROJECTION);
    }

    public LoadPushDown.RequiredFieldResponse pushProjection(LoadPushDown.RequiredFieldList requiredFieldsInfo) throws FrontendException {
        this.storeInUDFContext(this.signature, PRUNE_PROJECTION_INFO, requiredFieldsInfo);
        return new LoadPushDown.RequiredFieldResponse(true);
    }

    public void setUDFContextSignature(String signature) {
        this.signature = signature;
    }

    protected void storeInUDFContext(String signature, String key, Object value) {
        UDFContext udfContext = UDFContext.getUDFContext();
        Properties props = udfContext.getUDFProperties(((Object)((Object)this)).getClass(), new String[]{signature});
        props.put(key, value);
    }

    protected static long getSizeInBytes(InputJobInfo inputJobInfo) throws IOException {
        Configuration conf = new Configuration();
        long sizeInBytes = 0L;
        for (PartInfo partInfo : inputJobInfo.getPartitions()) {
            try {
                Path p = new Path(partInfo.getLocation());
                if (p.getFileSystem(conf).isFile(p)) {
                    sizeInBytes += p.getFileSystem(conf).getFileStatus(p).getLen();
                    continue;
                }
                FileStatus[] fileStatuses = p.getFileSystem(conf).listStatus(p);
                if (fileStatuses == null) continue;
                for (FileStatus child : fileStatuses) {
                    sizeInBytes += child.getLen();
                }
            }
            catch (IOException iOException) {
            }
        }
        return sizeInBytes;
    }
}

