/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive.compaction;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.CompactionType;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.txn.entities.CompactionInfo;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.DriverUtils;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveUtils;
import org.apache.hadoop.hive.ql.metadata.VirtualColumn;
import org.apache.hadoop.hive.ql.parse.TransformSpec;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.txn.compactor.CompactorContext;
import org.apache.hadoop.hive.ql.txn.compactor.QueryCompactor;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hive.iceberg.org.apache.orc.storage.common.TableName;
import org.apache.iceberg.PartitionField;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Table;
import org.apache.iceberg.hive.HiveSchemaUtil;
import org.apache.iceberg.mr.hive.HiveIcebergFilterFactory;
import org.apache.iceberg.mr.hive.IcebergTableUtil;
import org.apache.iceberg.mr.hive.compaction.evaluator.CompactionEvaluator;
import org.apache.iceberg.types.Types;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IcebergQueryCompactor
extends QueryCompactor {
    private static final Logger LOG = LoggerFactory.getLogger((String)IcebergQueryCompactor.class.getName());

    public boolean run(CompactorContext context) throws IOException, HiveException, InterruptedException {
        String compactTableName = TableName.getDbTable(context.getTable().getDbName(), context.getTable().getTableName());
        Map tblProperties = context.getTable().getParameters();
        LOG.debug("Initiating compaction for the {} table", (Object)compactTableName);
        HiveConf conf = new HiveConf(context.getConf());
        CompactionInfo ci = context.getCompactionInfo();
        String compactionQuery = this.buildCompactionQuery(context, compactTableName, conf);
        SessionState sessionState = this.setupQueryCompactionSession(conf, ci, tblProperties);
        String compactionTarget = "table " + HiveUtils.unparseIdentifier((String)compactTableName) + (String)(ci.partName != null ? ", partition " + HiveUtils.unparseIdentifier((String)ci.partName) : "");
        try {
            DriverUtils.runOnDriver((HiveConf)conf, (SessionState)sessionState, (String)compactionQuery);
            LOG.info("Completed compaction for {}", (Object)compactionTarget);
            boolean bl = true;
            return bl;
        }
        catch (HiveException e) {
            LOG.error("Failed compacting {}", (Object)compactionTarget, (Object)e);
            throw e;
        }
        finally {
            sessionState.setCompaction(false);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String buildCompactionQuery(CompactorContext context, String compactTableName, HiveConf conf) throws HiveException {
        CompactionInfo ci = context.getCompactionInfo();
        org.apache.hadoop.hive.ql.metadata.Table table = Hive.get((HiveConf)conf).getTable(context.getTable().getDbName(), context.getTable().getTableName());
        Table icebergTable = IcebergTableUtil.getTable((Configuration)conf, table.getTTable());
        String orderBy = ci.orderByClause == null ? "" : ci.orderByClause;
        String fileSizePredicate = null;
        if (ci.type == CompactionType.MINOR) {
            long fileSizeInBytesThreshold = CompactionEvaluator.getFragmentSizeBytes(table.getParameters());
            fileSizePredicate = String.format("%1$s in (select file_path from %2$s.files where file_size_in_bytes < %3$d)", VirtualColumn.FILE_PATH.getName(), compactTableName, fileSizeInBytesThreshold);
            conf.setLong("compactor.threshold.file.size.threshold", fileSizeInBytesThreshold);
            conf.setBoolVar(HiveConf.ConfVars.HIVE_VECTORIZATION_ENABLED, false);
        }
        if (ci.partName == null) {
            if (!icebergTable.spec().isPartitioned()) {
                HiveConf.setVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.REWRITE_POLICY, (String)Context.RewritePolicy.FULL_TABLE.name());
                return String.format("insert overwrite table %s select * from %<s %2$s %3$s", compactTableName, fileSizePredicate == null ? "" : "where " + fileSizePredicate, orderBy);
            }
            if (icebergTable.specs().size() <= 1) throw new HiveException(ErrorMsg.COMPACTION_NO_PARTITION);
            HiveConf.setVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.REWRITE_POLICY, (String)Context.RewritePolicy.PARTITION.name());
            return String.format("insert overwrite table %1$s select * from %1$s where %2$s != %3$d and %4$s is not null %5$s %6$s", compactTableName, VirtualColumn.PARTITION_SPEC_ID.getName(), icebergTable.spec().specId(), VirtualColumn.FILE_PATH.getName(), fileSizePredicate == null ? "" : "and " + fileSizePredicate, orderBy);
        }
        HiveConf.setBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_CONVERT_JOIN, (boolean)false);
        conf.setBoolVar(HiveConf.ConfVars.HIVE_VECTORIZATION_ENABLED, false);
        HiveConf.setVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.REWRITE_POLICY, (String)Context.RewritePolicy.PARTITION.name());
        conf.set("compaction_partition_path", new Path(ci.partName).toString());
        try {
            PartitionSpec spec = IcebergTableUtil.getPartitionSpec(icebergTable, ci.partName);
            String partitionPredicate = this.buildPartitionPredicate(ci, spec);
            return String.format("INSERT OVERWRITE TABLE %1$s SELECT * FROM %1$s WHERE %2$s IN (SELECT FILE_PATH FROM %1$s.FILES WHERE %3$s AND SPEC_ID = %4$d) %5$s %6$s", compactTableName, VirtualColumn.FILE_PATH.getName(), partitionPredicate, spec.specId(), fileSizePredicate == null ? "" : "AND " + fileSizePredicate, orderBy);
        }
        catch (MetaException e) {
            throw new HiveException((Throwable)e);
        }
    }

    private String buildPartitionPredicate(CompactionInfo ci, PartitionSpec spec) throws MetaException {
        LinkedHashMap partSpecMap = Warehouse.makeSpecFromName((String)ci.partName);
        Map partitionFieldMap = spec.fields().stream().collect(Collectors.toMap(PartitionField::name, Function.identity()));
        Types.StructType partitionType = spec.partitionType();
        return partitionType.fields().stream().map(field -> {
            String value = (String)partSpecMap.get(field.name());
            String literal = "NULL";
            if (value != null && !value.equals("null")) {
                String type = HiveSchemaUtil.convertToTypeString(field.type());
                PartitionField partitionField = (PartitionField)partitionFieldMap.get(field.name());
                TransformSpec transformSpec = TransformSpec.fromString((String)partitionField.transform().toString(), (String)field.name());
                literal = TypeInfoUtils.convertStringToLiteralForSQL((String)HiveIcebergFilterFactory.convertPartitionLiteral(value, transformSpec).toString(), (PrimitiveObjectInspector.PrimitiveCategory)((PrimitiveTypeInfo)TypeInfoUtils.getTypeInfoFromTypeString((String)type)).getPrimitiveCategory());
            }
            return String.format("`partition`.%s %s %s", HiveUtils.unparseIdentifier((String)field.name()), Objects.equals(literal, "NULL") ? "IS" : "=", literal);
        }).collect(Collectors.joining(" AND "));
    }
}

