/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive;

import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.io.HiveOutputFormat;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.util.Progressable;
import org.apache.iceberg.Table;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.mr.hive.HiveTableUtil;
import org.apache.iceberg.mr.hive.TezUtil;
import org.apache.iceberg.mr.hive.writer.HiveIcebergWriter;
import org.apache.iceberg.mr.hive.writer.WriterBuilder;
import org.apache.iceberg.mr.mapred.Container;

public class HiveIcebergOutputFormat
implements OutputFormat<NullWritable, Container<Record>>,
HiveOutputFormat<NullWritable, Container<Record>> {
    public FileSinkOperator.RecordWriter getHiveRecordWriter(JobConf jc, Path finalOutPath, Class valueClass, boolean isCompressed, Properties tableAndSerDeProperties, Progressable progress) {
        return HiveIcebergOutputFormat.writer(jc);
    }

    public RecordWriter<NullWritable, Container<Record>> getRecordWriter(FileSystem ignored, JobConf job, String name, Progressable progress) {
        return HiveIcebergOutputFormat.writer(job);
    }

    public void checkOutputSpecs(FileSystem ignored, JobConf job) {
    }

    private static HiveIcebergWriter writer(JobConf jc) {
        TaskAttemptID taskAttemptID = TezUtil.taskAttemptWrapper(jc);
        Table table = HiveTableUtil.deserializeTable((Configuration)jc, jc.get("name"));
        HiveIcebergOutputFormat.setWriterLevelConfiguration(jc, table);
        return WriterBuilder.builderFor(table, arg_0 -> ((JobConf)jc).get(arg_0)).queryId(jc.get(HiveConf.ConfVars.HIVE_QUERY_ID.varname)).attemptID(taskAttemptID).build();
    }

    private static void setWriterLevelConfiguration(JobConf jc, Table table) {
        String writeFormat = table.properties().get("write.format.default");
        if (writeFormat == null || "PARQUET".equalsIgnoreCase(writeFormat)) {
            if (table.properties().get("write.parquet.row-group-size-bytes") == null && jc.get("parquet.block.size") != null) {
                table.properties().put("write.parquet.row-group-size-bytes", jc.get("parquet.block.size"));
            }
            if (table.properties().get("write.parquet.compression-codec") == null && jc.get("parquet.compression") != null) {
                table.properties().put("write.parquet.compression-codec", jc.get("parquet.compression"));
            }
        }
    }
}

