/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.contrib.mr;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.hadoop.hive.contrib.mr.Mapper;
import org.apache.hadoop.hive.contrib.mr.Output;
import org.apache.hadoop.hive.contrib.mr.Reducer;

public final class GenericMR {
    public void map(InputStream in, OutputStream out, Mapper mapper) throws Exception {
        this.map(new InputStreamReader(in), new OutputStreamWriter(out), mapper);
    }

    public void map(Reader in, Writer out, final Mapper mapper) throws Exception {
        this.handle(in, out, new RecordProcessor(){

            @Override
            public void processNext(RecordReader reader, Output output) throws Exception {
                mapper.map(reader.next(), output);
            }
        });
    }

    public void reduce(InputStream in, OutputStream out, Reducer reducer) throws Exception {
        this.reduce(new InputStreamReader(in), new OutputStreamWriter(out), reducer);
    }

    public void reduce(Reader in, Writer out, final Reducer reducer) throws Exception {
        this.handle(in, out, new RecordProcessor(){

            @Override
            public void processNext(RecordReader reader, Output output) throws Exception {
                reducer.reduce(reader.peek()[0], new KeyRecordIterator(reader.peek()[0], reader), output);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handle(Reader in, Writer out, RecordProcessor processor) throws Exception {
        RecordReader reader = new RecordReader(in);
        OutputStreamOutput output = new OutputStreamOutput(out);
        try {
            while (reader.hasNext()) {
                processor.processNext(reader, output);
            }
        }
        finally {
            try {
                output.close();
            }
            finally {
                reader.close();
            }
        }
    }

    private static interface RecordProcessor {
        public void processNext(RecordReader var1, Output var2) throws Exception;
    }

    private static final class RecordReader {
        private final BufferedReader reader;
        private String[] next;

        private RecordReader(InputStream in) {
            this(new InputStreamReader(in));
        }

        private RecordReader(Reader in) {
            this.reader = new BufferedReader(in);
            this.next = this.readNext();
        }

        private String[] next() {
            String[] ret = this.next;
            this.next = this.readNext();
            return ret;
        }

        private String[] readNext() {
            try {
                String line = this.reader.readLine();
                return line == null ? null : line.split("\t");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private boolean hasNext() {
            return this.next != null;
        }

        private String[] peek() {
            return this.next;
        }

        private void close() throws Exception {
            this.reader.close();
        }
    }

    private static final class OutputStreamOutput
    implements Output {
        private final PrintWriter out;

        private OutputStreamOutput(OutputStream out) {
            this(new OutputStreamWriter(out));
        }

        private OutputStreamOutput(Writer out) {
            this.out = new PrintWriter(out);
        }

        public void close() throws Exception {
            this.out.close();
        }

        @Override
        public void collect(String[] record) throws Exception {
            this.out.println(OutputStreamOutput._join(record, "\t"));
        }

        private static String _join(String[] record, String separator) {
            if (record == null || record.length == 0) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < record.length; ++i) {
                if (i > 0) {
                    sb.append(separator);
                }
                sb.append(record[i]);
            }
            return sb.toString();
        }
    }

    private static final class KeyRecordIterator
    implements Iterator<String[]> {
        private final String key;
        private final RecordReader reader;

        private KeyRecordIterator(String key, RecordReader reader) {
            this.key = key;
            this.reader = reader;
        }

        @Override
        public boolean hasNext() {
            return this.reader.hasNext() && this.key.equals(this.reader.peek()[0]);
        }

        @Override
        public String[] next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.reader.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

