/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.streaming;

import java.util.concurrent.atomic.LongAdder;

public class ConnectionStats {
    private LongAdder recordsWritten = new LongAdder();
    private LongAdder recordsSize = new LongAdder();
    private LongAdder committedTransactions = new LongAdder();
    private LongAdder abortedTransactions = new LongAdder();
    private LongAdder autoFlushCount = new LongAdder();
    private LongAdder metastoreCalls = new LongAdder();
    private LongAdder totalPartitions = new LongAdder();
    private LongAdder createdPartitions = new LongAdder();

    public void incrementRecordsWritten() {
        this.recordsWritten.increment();
    }

    public void incrementCommittedTransactions() {
        this.committedTransactions.increment();
    }

    public void incrementAbortedTransactions() {
        this.abortedTransactions.increment();
    }

    public void incrementAutoFlushCount() {
        this.autoFlushCount.increment();
    }

    public void incrementMetastoreCalls() {
        this.metastoreCalls.increment();
    }

    public void incrementRecordsSize(long delta) {
        this.recordsSize.add(delta);
    }

    public void incrementCreatedPartitions(long delta) {
        this.createdPartitions.add(delta);
    }

    public void incrementTotalPartitions(long delta) {
        this.totalPartitions.add(delta);
    }

    public long getRecordsWritten() {
        return this.recordsWritten.longValue();
    }

    public long getRecordsSize() {
        return this.recordsSize.longValue();
    }

    public long getCommittedTransactions() {
        return this.committedTransactions.longValue();
    }

    public long getAbortedTransactions() {
        return this.abortedTransactions.longValue();
    }

    public long getAutoFlushCount() {
        return this.autoFlushCount.longValue();
    }

    public long getMetastoreCalls() {
        return this.metastoreCalls.longValue();
    }

    public LongAdder getTotalPartitions() {
        return this.totalPartitions;
    }

    public LongAdder getCreatedPartitions() {
        return this.createdPartitions;
    }

    public String toString() {
        return "{records-written: " + String.valueOf(this.recordsWritten) + ", records-size: " + String.valueOf(this.recordsSize) + ", committed-transactions: " + String.valueOf(this.committedTransactions) + ", aborted-transactions: " + String.valueOf(this.abortedTransactions) + ", auto-flushes: " + String.valueOf(this.autoFlushCount) + ", metastore-calls: " + String.valueOf(this.metastoreCalls) + ", created-partitions: " + String.valueOf(this.createdPartitions) + ", total-partitions: " + String.valueOf(this.totalPartitions) + " }";
    }
}

