/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafkaesque.common.security.oauthbearer;

import java.util.Objects;
import javax.security.auth.callback.Callback;
import org.apache.kafkaesque.common.annotation.InterfaceStability;
import org.apache.kafkaesque.common.security.oauthbearer.OAuthBearerToken;

@InterfaceStability.Evolving
public class OAuthBearerValidatorCallback
implements Callback {
    private final String tokenValue;
    private OAuthBearerToken token = null;
    private String errorStatus = null;
    private String errorScope = null;
    private String errorOpenIDConfiguration = null;

    public OAuthBearerValidatorCallback(String tokenValue) {
        if (Objects.requireNonNull(tokenValue).isEmpty()) {
            throw new IllegalArgumentException("token value must not be empty");
        }
        this.tokenValue = tokenValue;
    }

    public String tokenValue() {
        return this.tokenValue;
    }

    public OAuthBearerToken token() {
        return this.token;
    }

    public String errorStatus() {
        return this.errorStatus;
    }

    public String errorScope() {
        return this.errorScope;
    }

    public String errorOpenIDConfiguration() {
        return this.errorOpenIDConfiguration;
    }

    public void token(OAuthBearerToken token) {
        this.token = Objects.requireNonNull(token);
        this.errorStatus = null;
        this.errorScope = null;
        this.errorOpenIDConfiguration = null;
    }

    public void error(String errorStatus, String errorScope, String errorOpenIDConfiguration) {
        if (Objects.requireNonNull(errorStatus).isEmpty()) {
            throw new IllegalArgumentException("error status must not be empty");
        }
        this.errorStatus = errorStatus;
        this.errorScope = errorScope;
        this.errorOpenIDConfiguration = errorOpenIDConfiguration;
        this.token = null;
    }
}

