/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafkaesque.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafkaesque.common.errors.UnsupportedVersionException;
import org.apache.kafkaesque.common.protocol.ApiMessage;
import org.apache.kafkaesque.common.protocol.Message;
import org.apache.kafkaesque.common.protocol.MessageUtil;
import org.apache.kafkaesque.common.protocol.ObjectSerializationCache;
import org.apache.kafkaesque.common.protocol.Readable;
import org.apache.kafkaesque.common.protocol.Writable;
import org.apache.kafkaesque.common.protocol.types.ArrayOf;
import org.apache.kafkaesque.common.protocol.types.Field;
import org.apache.kafkaesque.common.protocol.types.RawTaggedField;
import org.apache.kafkaesque.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafkaesque.common.protocol.types.Schema;
import org.apache.kafkaesque.common.protocol.types.Struct;
import org.apache.kafkaesque.common.protocol.types.Type;
import org.apache.kafkaesque.common.utils.ByteUtils;

public class DescribeConfigsRequestData
implements ApiMessage {
    private List<DescribeConfigsResource> resources;
    private boolean includeSynoyms;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("resources", new ArrayOf(DescribeConfigsResource.SCHEMA_0), "The resources whose configurations we want to describe."));
    public static final Schema SCHEMA_1;
    public static final Schema SCHEMA_2;
    public static final Schema[] SCHEMAS;

    public DescribeConfigsRequestData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public DescribeConfigsRequestData(Struct struct, short _version) {
        this.fromStruct(struct, _version);
    }

    public DescribeConfigsRequestData() {
        this.resources = new ArrayList<DescribeConfigsResource>();
        this.includeSynoyms = false;
    }

    @Override
    public short apiKey() {
        return 32;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 2;
    }

    @Override
    public void read(Readable _readable, short _version) {
        int arrayLength = _readable.readInt();
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field resources was serialized as null");
        }
        ArrayList<DescribeConfigsResource> newCollection = new ArrayList<DescribeConfigsResource>(arrayLength);
        for (int i = 0; i < arrayLength; ++i) {
            newCollection.add(new DescribeConfigsResource(_readable, _version));
        }
        this.resources = newCollection;
        this.includeSynoyms = _version >= 1 ? _readable.readByte() != 0 : false;
        this._unknownTaggedFields = null;
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _writable.writeInt(this.resources.size());
        for (DescribeConfigsResource resourcesElement : this.resources) {
            resourcesElement.write(_writable, _cache, _version);
        }
        if (_version >= 1) {
            _writable.writeByte(this.includeSynoyms ? (byte)1 : 0);
        } else if (this.includeSynoyms) {
            throw new UnsupportedVersionException("Attempted to write a non-default includeSynoyms at version " + _version);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void fromStruct(Struct struct, short _version) {
        this._unknownTaggedFields = null;
        Object[] _nestedObjects = struct.getArray("resources");
        this.resources = new ArrayList<DescribeConfigsResource>(_nestedObjects.length);
        for (Object nestedObject : _nestedObjects) {
            this.resources.add(new DescribeConfigsResource((Struct)nestedObject, _version));
        }
        this.includeSynoyms = _version >= 1 ? struct.getBoolean("include_synoyms") : false;
    }

    @Override
    public Struct toStruct(short _version) {
        Object _taggedFields = null;
        Struct struct = new Struct(SCHEMAS[_version]);
        Struct[] _nestedObjects = new Struct[this.resources.size()];
        int i = 0;
        for (DescribeConfigsResource element : this.resources) {
            _nestedObjects[i++] = element.toStruct(_version);
        }
        struct.set("resources", (Object)_nestedObjects);
        if (_version >= 1) {
            struct.set("include_synoyms", (Object)this.includeSynoyms);
        } else if (this.includeSynoyms) {
            throw new UnsupportedVersionException("Attempted to write a non-default includeSynoyms at version " + _version);
        }
        return struct;
    }

    @Override
    public int size(ObjectSerializationCache _cache, short _version) {
        int _size = 0;
        int _numTaggedFields = 0;
        int _arraySize = 0;
        _arraySize += 4;
        for (DescribeConfigsResource resourcesElement : this.resources) {
            _arraySize += resourcesElement.size(_cache, _version);
        }
        _size += _arraySize;
        if (_version >= 1) {
            ++_size;
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                _size += _field.size();
            }
        }
        if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
        return _size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DescribeConfigsRequestData)) {
            return false;
        }
        DescribeConfigsRequestData other = (DescribeConfigsRequestData)obj;
        if (this.resources == null ? other.resources != null : !this.resources.equals(other.resources)) {
            return false;
        }
        return this.includeSynoyms == other.includeSynoyms;
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.resources == null ? 0 : this.resources.hashCode());
        hashCode = 31 * hashCode + (this.includeSynoyms ? 1231 : 1237);
        return hashCode;
    }

    public String toString() {
        return "DescribeConfigsRequestData(resources=" + MessageUtil.deepToString(this.resources.iterator()) + ", includeSynoyms=" + (this.includeSynoyms ? "true" : "false") + ")";
    }

    public List<DescribeConfigsResource> resources() {
        return this.resources;
    }

    public boolean includeSynoyms() {
        return this.includeSynoyms;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public DescribeConfigsRequestData setResources(List<DescribeConfigsResource> v) {
        this.resources = v;
        return this;
    }

    public DescribeConfigsRequestData setIncludeSynoyms(boolean v) {
        this.includeSynoyms = v;
        return this;
    }

    static {
        SCHEMA_2 = SCHEMA_1 = new Schema(new Field("resources", new ArrayOf(DescribeConfigsResource.SCHEMA_0), "The resources whose configurations we want to describe."), new Field("include_synoyms", Type.BOOLEAN, "True if we should include all synonyms."));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2};
    }

    public static class DescribeConfigsResource
    implements Message {
        private byte resourceType;
        private String resourceName;
        private List<String> configurationKeys;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema[] SCHEMAS;

        public DescribeConfigsResource(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public DescribeConfigsResource(Struct struct, short _version) {
            this.fromStruct(struct, _version);
        }

        public DescribeConfigsResource() {
            this.resourceType = 0;
            this.resourceName = "";
            this.configurationKeys = new ArrayList<String>();
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 2;
        }

        @Override
        public void read(Readable _readable, short _version) {
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of DescribeConfigsResource");
            }
            this.resourceType = _readable.readByte();
            short length = _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field resourceName was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field resourceName had invalid length " + length);
            }
            this.resourceName = _readable.readString(length);
            int arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                this.configurationKeys = null;
            } else {
                ArrayList<String> newCollection = new ArrayList<String>(arrayLength);
                for (int i = 0; i < arrayLength; ++i) {
                    short length2 = _readable.readShort();
                    if (length2 < 0) {
                        throw new RuntimeException("non-nullable field configurationKeys element was serialized as null");
                    }
                    if (length2 > Short.MAX_VALUE) {
                        throw new RuntimeException("string field configurationKeys element had invalid length " + length2);
                    }
                    newCollection.add(_readable.readString(length2));
                }
                this.configurationKeys = newCollection;
            }
            this._unknownTaggedFields = null;
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of DescribeConfigsResource");
            }
            int _numTaggedFields = 0;
            _writable.writeByte(this.resourceType);
            Object _stringBytes = _cache.getSerializedValue(this.resourceName);
            _writable.writeShort((short)((byte[])_stringBytes).length);
            _writable.writeByteArray((byte[])_stringBytes);
            if (this.configurationKeys == null) {
                _writable.writeInt(-1);
            } else {
                _writable.writeInt(this.configurationKeys.size());
                _stringBytes = this.configurationKeys.iterator();
                while (_stringBytes.hasNext()) {
                    String configurationKeysElement = (String)_stringBytes.next();
                    byte[] _stringBytes2 = _cache.getSerializedValue(configurationKeysElement);
                    _writable.writeShort((short)_stringBytes2.length);
                    _writable.writeByteArray(_stringBytes2);
                }
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void fromStruct(Struct struct, short _version) {
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of DescribeConfigsResource");
            }
            this._unknownTaggedFields = null;
            this.resourceType = struct.getByte("resource_type");
            this.resourceName = struct.getString("resource_name");
            Object[] _nestedObjects = struct.getArray("configuration_keys");
            if (_nestedObjects == null) {
                this.configurationKeys = null;
            } else {
                this.configurationKeys = new ArrayList<String>(_nestedObjects.length);
                for (Object nestedObject : _nestedObjects) {
                    this.configurationKeys.add((String)nestedObject);
                }
            }
        }

        @Override
        public Struct toStruct(short _version) {
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of DescribeConfigsResource");
            }
            Object _taggedFields = null;
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("resource_type", (Object)this.resourceType);
            struct.set("resource_name", (Object)this.resourceName);
            if (this.configurationKeys == null) {
                struct.set("configuration_keys", null);
            } else {
                String[] _nestedObjects = new String[this.configurationKeys.size()];
                int i = 0;
                for (String element : this.configurationKeys) {
                    _nestedObjects[i++] = element;
                }
                struct.set("configuration_keys", (Object)_nestedObjects);
            }
            return struct;
        }

        @Override
        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of DescribeConfigsResource");
            }
            ++_size;
            byte[] _stringBytes = this.resourceName.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'resourceName' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.resourceName, _stringBytes);
            _size += _stringBytes.length + 2;
            if (this.configurationKeys == null) {
                _size += 4;
            } else {
                int _arraySize = 0;
                _arraySize += 4;
                for (String configurationKeysElement : this.configurationKeys) {
                    byte[] _stringBytes2 = configurationKeysElement.getBytes(StandardCharsets.UTF_8);
                    if (_stringBytes2.length > Short.MAX_VALUE) {
                        throw new RuntimeException("'configurationKeysElement' field is too long to be serialized");
                    }
                    _cache.cacheSerializedValue(configurationKeysElement, _stringBytes2);
                    _arraySize += _stringBytes2.length + 2;
                }
                _size += _arraySize;
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                    _size += _field.size();
                }
            }
            if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DescribeConfigsResource)) {
                return false;
            }
            DescribeConfigsResource other = (DescribeConfigsResource)obj;
            if (this.resourceType != other.resourceType) {
                return false;
            }
            if (this.resourceName == null ? other.resourceName != null : !this.resourceName.equals(other.resourceName)) {
                return false;
            }
            return !(this.configurationKeys == null ? other.configurationKeys != null : !this.configurationKeys.equals(other.configurationKeys));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.resourceType;
            hashCode = 31 * hashCode + (this.resourceName == null ? 0 : this.resourceName.hashCode());
            hashCode = 31 * hashCode + (this.configurationKeys == null ? 0 : this.configurationKeys.hashCode());
            return hashCode;
        }

        public String toString() {
            return "DescribeConfigsResource(resourceType=" + this.resourceType + ", resourceName=" + (this.resourceName == null ? "null" : "'" + this.resourceName.toString() + "'") + ", configurationKeys=" + (this.configurationKeys == null ? "null" : MessageUtil.deepToString(this.configurationKeys.iterator())) + ")";
        }

        public byte resourceType() {
            return this.resourceType;
        }

        public String resourceName() {
            return this.resourceName;
        }

        public List<String> configurationKeys() {
            return this.configurationKeys;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public DescribeConfigsResource setResourceType(byte v) {
            this.resourceType = v;
            return this;
        }

        public DescribeConfigsResource setResourceName(String v) {
            this.resourceName = v;
            return this;
        }

        public DescribeConfigsResource setConfigurationKeys(List<String> v) {
            this.configurationKeys = v;
            return this;
        }

        static {
            SCHEMA_2 = SCHEMA_1 = (SCHEMA_0 = new Schema(new Field("resource_type", Type.INT8, "The resource type."), new Field("resource_name", Type.STRING, "The resource name."), new Field("configuration_keys", ArrayOf.nullable(Type.STRING), "The configuration keys to list, or null to list all configuration keys.")));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2};
        }
    }
}

